/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.ISessionManager;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class RemoveActiveSessionAction
extends Action {
    public RemoveActiveSessionAction() {
        this.setText(ActionMessages.RemoveActiveSessionAction_label);
        this.setToolTipText(ActionMessages.RemoveActiveSessionAction_tooltip);
        ImageDescriptor enabledImageDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE");
        this.setImageDescriptor(enabledImageDescriptor);
        ImageDescriptor disabledImageDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE_DISABLED");
        this.setDisabledImageDescriptor(disabledImageDescriptor);
        this.setActionDefinitionId(ActionFactory.DELETE.getCommandId());
    }

    public void run() {
        ISession[] sessions;
        int length;
        ISessionManager manager = ApiPlugin.getDefault().getSessionManager();
        ISession session = manager.getActiveSession();
        if (session != null) {
            manager.removeSession(session);
        }
        if ((length = (sessions = manager.getSessions()).length) > 0) {
            manager.activateSession(sessions[length - 1]);
        }
    }
}

