/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;

public class CompilationUnit {
    private String name = null;
    private String filepath = null;
    private ICompilationUnit unit = null;
    private String encoding = null;

    public CompilationUnit(String filepath, String encoding) {
        File file = new File(filepath);
        if (!file.exists()) {
            throw new IllegalArgumentException("The specified path is not an existing file");
        }
        this.filepath = filepath;
        this.name = file.getName();
        this.encoding = this.resolveEncoding(encoding);
    }

    public CompilationUnit(ICompilationUnit compilationUnit) {
        this.unit = compilationUnit;
        this.name = compilationUnit.getElementName();
        this.encoding = this.resolveEncoding(null);
    }

    String resolveEncoding(String base) {
        if (base != null) {
            return base;
        }
        if (this.unit != null) {
            IResource resource = this.unit.getResource();
            if (resource != null && resource.getType() == 1) {
                try {
                    return ((IFile)resource).getCharset();
                }
                catch (CoreException coreException) {
                    try {
                        IProject p = resource.getProject();
                        if (p != null) {
                            return p.getDefaultCharset();
                        }
                    }
                    catch (CoreException coreException2) {}
                }
            }
            return ResourcesPlugin.getEncoding();
        }
        return System.getProperty("file.encoding");
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.unit != null) {
            try {
                return ((IFile)this.unit.getCorrespondingResource()).getContents();
            }
            catch (CoreException e) {
                throw new FileNotFoundException(e.getStatus().getMessage());
            }
        }
        return new FileInputStream(new File(this.filepath));
    }

    public String getEncoding() throws CoreException {
        return this.encoding;
    }

    public String toString() {
        return this.getName();
    }
}

