/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.templates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.AbstractTemplateProposalProvider;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.internal.Activator;
import org.eclipse.xtext.util.XtextSwitch;

@Singleton
public class DefaultTemplateProposalProvider
extends AbstractTemplateProposalProvider {
    private TemplateStore templateStore;
    private ContextTypeRegistry registry;
    private ContextTypeIdHelper helper;

    @Inject
    public DefaultTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        this.templateStore = templateStore;
        this.registry = registry;
        this.helper = helper;
    }

    @Override
    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        Template[] templates;
        TemplateContextType contextType = templateContext.getContextType();
        Template[] templateArray = templates = this.templateStore.getTemplates(contextType.getId());
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (!acceptor.canAcceptMoreTemplates()) {
                return;
            }
            if (this.validate(template, templateContext)) {
                acceptor.accept(this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template)));
            }
            ++n2;
        }
    }

    @Override
    protected TemplateContextType[] getContextTypes(ContentAssistContext context) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        IFollowElementAcceptor acceptor = this.createFollowElementAcceptor(result);
        ImmutableList<AbstractElement> grammarElements = context.getFirstSetGrammarElements();
        for (AbstractElement element : grammarElements) {
            acceptor.accept(element);
        }
        return result.toArray(new TemplateContextType[result.size()]);
    }

    protected IFollowElementAcceptor createFollowElementAcceptor(Collection<TemplateContextType> result) {
        return new FollowElementAcceptor(result);
    }

    public Image getImage(Template template) {
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        ImageDescriptor descriptor = registry.getDescriptor("defaultoutlinenode.gif");
        if (descriptor == null) {
            descriptor = Activator.getImageDescriptor("icons/defaultoutlinenode.gif");
            registry.put("defaultoutlinenode.gif", descriptor);
        }
        return registry.get("defaultoutlinenode.gif");
    }

    public int getRelevance(Template template) {
        return 90;
    }

    public class FollowElementAcceptor
    extends XtextSwitch<Boolean>
    implements IFollowElementAcceptor {
        private final Collection<TemplateContextType> result;

        public FollowElementAcceptor(Collection<TemplateContextType> result) {
            this.result = result;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }

        public Boolean caseKeyword(Keyword object) {
            this.addContextType(object);
            return Boolean.TRUE;
        }

        public Boolean caseRuleCall(RuleCall object) {
            this.doSwitch((EObject)object.getRule());
            return Boolean.TRUE;
        }

        public Boolean caseParserRule(ParserRule object) {
            this.addContextType(object);
            return Boolean.TRUE;
        }

        public Boolean caseAssignment(Assignment object) {
            this.accept(object.getTerminal());
            return Boolean.TRUE;
        }

        @Override
        public void accept(AbstractElement element) {
            this.doSwitch((EObject)element);
        }

        protected void addContextType(ParserRule rule) {
            this.addContextType(DefaultTemplateProposalProvider.this.helper.getId((AbstractRule)rule));
        }

        protected void addContextType(Keyword keyword) {
            this.addContextType(DefaultTemplateProposalProvider.this.helper.getId((AbstractElement)keyword));
        }

        protected void addContextType(String id) {
            TemplateContextType contextType = DefaultTemplateProposalProvider.this.registry.getContextType(id);
            if (contextType != null) {
                this.result.add(contextType);
            }
        }
    }
}

