/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.Optional;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.StringUtils;

class DisabledCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@Disabled is not present");

    DisabledCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        Optional disabled = AnnotationUtils.findAnnotation((Optional)element, Disabled.class);
        if (disabled.isPresent()) {
            String reason = disabled.map(Disabled::value).filter(StringUtils::isNotBlank).orElseGet(() -> element.get() + " is @Disabled");
            return ConditionEvaluationResult.disabled((String)reason);
        }
        return ENABLED;
    }
}

