/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.List;

public class LinearLeastSquaresFit {
    private double slope = 0.0;
    private double intercept = 0.0;
    private double slopeVariance = 0.0;
    private double interceptVariance = 0.0;
    private double slopeStdDev = 0.0;
    private double interceptStdDev = 0.0;

    public LinearLeastSquaresFit(List<Double> xList, List<Double> yList) {
        int npts = xList.size();
        assert (npts == yList.size());
        double[] x = new double[npts];
        double[] y = new double[npts];
        int j = 0;
        while (j < npts) {
            x[j] = xList.get(j);
            y[j] = yList.get(j);
            ++j;
        }
        double sumx = 0.0;
        double sumy = 0.0;
        double sumxy = 0.0;
        double sumx2 = 0.0;
        double sumy2 = 0.0;
        double sum = 0.0;
        int j2 = 0;
        while (j2 < npts) {
            sumx += x[j2];
            sumy += y[j2];
            sumxy += x[j2] * y[j2];
            sumx2 += x[j2] * x[j2];
            sumy2 += y[j2] * y[j2];
            sum += 1.0;
            ++j2;
        }
        double delta = -(sum * sumx2 - sumx * sumx);
        this.intercept = (sumx * sumxy - sumy * sumx2) / delta;
        this.slope = (sumx * sumy - sum * sumxy) / delta;
        double variance = (sumy2 + this.intercept * this.intercept * sum + this.slope * this.slope * sumx2 - 2.0 * (-this.intercept * sumy + this.slope * sumxy + this.intercept * this.slope * sumx)) / (double)(npts - 2);
        this.interceptVariance = Math.abs(variance / delta * sumx2);
        this.slopeVariance = Math.abs(variance / delta * sum);
        this.interceptStdDev = Math.sqrt(this.interceptVariance);
        this.slopeStdDev = Math.sqrt(this.slopeVariance);
    }

    public LinearLeastSquaresFit(double[] xList, double[] yList) {
        int npts = xList.length;
        assert (npts == yList.length);
        double[] x = xList;
        double[] y = yList;
        double sumx = 0.0;
        double sumy = 0.0;
        double sumxy = 0.0;
        double sumx2 = 0.0;
        double sumy2 = 0.0;
        double sum = 0.0;
        int j = 0;
        while (j < npts) {
            sumx += x[j];
            sumy += y[j];
            sumxy += x[j] * y[j];
            sumx2 += x[j] * x[j];
            sumy2 += y[j] * y[j];
            sum += 1.0;
            ++j;
        }
        double delta = -(sum * sumx2 - sumx * sumx);
        this.intercept = (sumx * sumxy - sumy * sumx2) / delta;
        this.slope = (sumx * sumy - sum * sumxy) / delta;
        double variance = (sumy2 + this.intercept * this.intercept * sum + this.slope * this.slope * sumx2 - 2.0 * (-this.intercept * sumy + this.slope * sumxy + this.intercept * this.slope * sumx)) / (double)(npts - 2);
        this.interceptVariance = Math.abs(variance / delta * sumx2);
        this.slopeVariance = Math.abs(variance / delta * sum);
        this.interceptStdDev = Math.sqrt(this.interceptVariance);
        this.slopeStdDev = Math.sqrt(this.slopeVariance);
    }

    public double getSlope() {
        return this.slope;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double getSlopeVariance() {
        return this.slopeVariance;
    }

    public double getInterceptVariance() {
        return this.interceptVariance;
    }

    public double getSlopeStdDev() {
        return this.slopeStdDev;
    }

    public double getInterceptStdDev() {
        return this.interceptStdDev;
    }
}

