/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.scenario.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.provider.CoreEditPlugin;
import org.eclipse.stem.core.common.provider.IdentifiableItemProvider;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioPackage;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.sequencer.SequencerFactory;
import org.eclipse.stem.core.solver.SolverFactory;

public class ScenarioItemProvider
extends IdentifiableItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ScenarioItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ScenarioPackage.Literals.SCENARIO__MODEL);
            this.childrenFeatures.add(ScenarioPackage.Literals.SCENARIO__SEQUENCER);
            this.childrenFeatures.add(ScenarioPackage.Literals.SCENARIO__SCENARIO_DECORATORS);
            this.childrenFeatures.add(ScenarioPackage.Literals.SCENARIO__SOLVER);
            this.childrenFeatures.add(ScenarioPackage.Literals.SCENARIO__LOGGERS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Scenario"));
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    @Override
    public String getTextGen(Object object) {
        URI labelValue = ((Scenario)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_Scenario_type") : String.valueOf(this.getString("_UI_Scenario_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Scenario.class)) {
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ScenarioPackage.Literals.SCENARIO__MODEL, ModelFactory.eINSTANCE.createModel()));
        newChildDescriptors.add(this.createChildParameter(ScenarioPackage.Literals.SCENARIO__SEQUENCER, SequencerFactory.eINSTANCE.createSequentialSequencer()));
        newChildDescriptors.add(this.createChildParameter(ScenarioPackage.Literals.SCENARIO__SEQUENCER, SequencerFactory.eINSTANCE.createRealTimeSequencer()));
        newChildDescriptors.add(this.createChildParameter(ScenarioPackage.Literals.SCENARIO__SOLVER, SolverFactory.eINSTANCE.createSolver()));
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        ArrayList<Identifiable> identifiableCollection = new ArrayList<Identifiable>();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identifiable identifable;
            URI uri;
            Object value;
            Object temp = value = iterator.next();
            if (value instanceof IFile) {
                IFile iFile = (IFile)value;
                uri = URI.createFileURI((String)iFile.getLocation().toString());
                identifable = Utility.getIdentifiable(uri);
                identifiableCollection.add(identifable);
                temp = identifable;
            } else if (value instanceof String) {
                String uriString = (String)value;
                try {
                    uri = URI.createURI((String)uriString);
                    identifable = Utility.getIdentifiable(uri);
                    temp = identifable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(temp instanceof Identifiable)) continue;
            identifiableCollection.add((Identifiable)temp);
        }
        return super.createAddCommand(domain, owner, feature, identifiableCollection, index);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        Object temp = value;
        if (value instanceof IFile) {
            IFile iFile = (IFile)value;
            URI uri = URI.createFileURI((String)iFile.getLocation().toString());
            Identifiable identifable = Utility.getIdentifiable(uri);
            temp = identifable;
        } else if (value instanceof String) {
            String uriString = (String)value;
            try {
                URI uri = URI.createURI((String)uriString);
                Identifiable identifable = Utility.getIdentifiable(uri);
                temp = identifable;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (temp instanceof Model) {
            return super.createSetCommand(domain, owner, (EStructuralFeature)ScenarioPackage.eINSTANCE.getScenario_Model(), temp, index);
        }
        if (temp instanceof Sequencer) {
            return super.createSetCommand(domain, owner, (EStructuralFeature)ScenarioPackage.eINSTANCE.getScenario_Sequencer(), temp, index);
        }
        if (temp instanceof Decorator) {
            return super.createAddCommand(domain, owner, ScenarioPackage.eINSTANCE.getScenario().getEStructuralFeature(5), Arrays.asList(temp), index);
        }
        return super.createSetCommand(domain, owner, feature, value, index);
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return super.createDragAndDropCommand(domain, owner, location, operations | 4, operation, collection);
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
        return new CreateChildCommand(domain, owner, feature, value, collection, (CreateChildCommand.Helper)this){

            protected Command createCommand() {
                Command retValue = null;
                Command createChildCommand = super.createCommand();
                if (this.child instanceof Model) {
                    Model model = (Model)this.child;
                    if (model.eResource() == null) {
                        Resource parentResource = this.owner.eResource();
                        AddCommand addCommand = new AddCommand(this.domain, parentResource.getContents(), (Object)model);
                        CompoundCommand compoundCommand = new CompoundCommand(0, createChildCommand.getLabel(), createChildCommand.getDescription());
                        compoundCommand.append(createChildCommand);
                        compoundCommand.append((Command)addCommand);
                        retValue = compoundCommand;
                    }
                } else {
                    retValue = createChildCommand;
                }
                return retValue;
            }
        };
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return CoreEditPlugin.INSTANCE;
    }
}

