/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class FeatureInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "feature-context";

    public FeatureInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return this.createResourceModel((IFileEditorInput)input);
        }
        if (input instanceof IStorageEditorInput) {
            return this.createStorageModel((IStorageEditorInput)input);
        }
        if (input instanceof IURIEditorInput) {
            return this.createSystemFileModel((IURIEditorInput)input);
        }
        return null;
    }

    private IBaseModel createResourceModel(IFileEditorInput input) {
        IFile file = input.getFile();
        WorkspaceFeatureModel model = new WorkspaceFeatureModel(file);
        model.load();
        return model;
    }

    private IBaseModel createStorageModel(IStorageEditorInput input) throws CoreException {
        BufferedInputStream stream = null;
        IStorage storage = input.getStorage();
        try {
            stream = new BufferedInputStream(storage.getContents());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
        ExternalFeatureModel model = new ExternalFeatureModel();
        IPath path = input.getStorage().getFullPath();
        model.setInstallLocation(path == null ? "" : path.removeLastSegments(1).toOSString());
        try {
            try {
                model.load((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
        return model;
    }

    private IBaseModel createSystemFileModel(IURIEditorInput input) throws CoreException {
        IFileStore store = EFS.getStore((URI)input.getURI());
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(store.getParent().toString());
        model.load(store.openInputStream(4096, (IProgressMonitor)new NullProgressMonitor()), true);
        return model;
    }

    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> ops, IModelChangedEvent event) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                StringWriter swriter = new StringWriter();
                try {
                    try (PrintWriter writer = new PrintWriter(swriter);){
                        editableModel.save(writer);
                        writer.flush();
                        String content = swriter.toString();
                        content = AbstractModel.fixLineDelimiter((String)content, (IFile)((IFile)((IModel)this.getModel()).getUnderlyingResource()));
                        doc.set(content);
                    }
                    if (swriter == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (swriter == null) throw throwable;
                    swriter.close();
                    throw throwable;
                }
                swriter.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    protected boolean synchronizeModel(IDocument doc) {
        if (doc == null) {
            return false;
        }
        IFeatureModel model = (IFeatureModel)this.getModel();
        String text = doc.get();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));){
                model.reload((InputStream)stream, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException throwable) {
            return false;
        }
        return true;
    }

    @Override
    protected void reorderInsertEdits(ArrayList<TextEdit> ops) {
    }

    @Override
    protected String getPartitionName() {
        return "___feature_partition";
    }
}

