/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor;

import org.eclipse.stem.ui.grapheditor.ConnectionData;
import org.eclipse.stem.ui.grapheditor.NodeData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public class TextAndButtonModifyListener
implements ModifyListener,
SelectionListener {
    public static final int NODE_TITLE = 1;
    public static final int EDGE_TITLE = 2;
    public static final int MIGRATION_LABEL_RATE = 3;
    public static final int MIGRATION_LABEL_POPULATION = 4;
    public static final int MIGRATION_LABEL_ABSOLUTE = 5;
    public static final int MIGRATION_LABEL_PERIOD = 6;
    public static final int COMMON_BORDER_LABEL_LENGTH = 7;
    public static final int AREA_LABEL_VALUE = 8;
    public static final int POPULATION_LABEL_POPULATION = 9;
    public static final int POPULATION_LABEL_COUNT = 10;
    public static final int POPULATION_LABEL_AREA = 11;
    public static final int ROAD_LABEL_NAME = 12;
    public static final int ROAD_LABEL_CLASS = 13;
    public static final int ROAD_LABEL_CROSSINGS = 14;
    public static final int PIPE_LABEL_POPULATION = 15;
    public static final int PIPE_LABEL_FLOW = 16;
    public static final int PIPE_LABEL_PERIOD = 17;
    private int attribute;
    private Graph zestGraph;

    TextAndButtonModifyListener(Graph zestGraph, int attribute) {
        this.attribute = attribute;
        this.zestGraph = zestGraph;
    }

    public void modifyText(ModifyEvent e) {
        Text text = (Text)e.widget;
        if (!text.isFocusControl()) {
            return;
        }
        String newValue = text.getText();
        NodeData nodeData = null;
        ConnectionData edgeData = null;
        if (this.zestGraph.getSelection().size() == 1) {
            GraphItem selection = (GraphItem)this.zestGraph.getSelection().get(0);
            if (selection instanceof GraphNode) {
                nodeData = (NodeData)selection.getData();
            }
            if (selection instanceof GraphConnection) {
                edgeData = (ConnectionData)selection.getData();
            }
        }
        try {
            if (this.attribute == 1) {
                nodeData.setNodeTitle(newValue);
            } else if (this.attribute == 2) {
                edgeData.setEdgeTitle(newValue);
            } else if (this.attribute == 3) {
                edgeData.setMigrationRate(Double.parseDouble(newValue));
            } else if (this.attribute == 4) {
                edgeData.setMigrationPopulation(newValue);
            } else if (this.attribute == 6) {
                edgeData.setMigrationPeriod(Long.parseLong(newValue));
            } else if (this.attribute == 7) {
                edgeData.setCommonBorderLength(Double.parseDouble(newValue));
            } else if (this.attribute == 8) {
                nodeData.setAreaLabelValue(Double.parseDouble(newValue));
            } else if (this.attribute == 9) {
                nodeData.setPopulationLabelPopulation(newValue);
            } else if (this.attribute == 10) {
                nodeData.setPopulationLabelCount(Double.parseDouble(newValue));
            } else if (this.attribute == 11) {
                nodeData.setPopulationLabelArea(Double.parseDouble(newValue));
            } else if (this.attribute == 12) {
                edgeData.setRoadName(newValue);
            } else if (this.attribute == 13) {
                edgeData.setRoadClass(newValue);
            } else if (this.attribute == 14) {
                edgeData.setRoadCrossings(Integer.parseInt(newValue));
            } else if (this.attribute == 15) {
                edgeData.setPipePopulation(newValue);
            } else if (this.attribute == 16) {
                edgeData.setPipeFlow(Double.parseDouble(newValue));
            } else if (this.attribute == 14) {
                edgeData.setPipePeriod(Long.parseLong(newValue));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void widgetSelected(SelectionEvent e) {
        GraphItem selection;
        Button button = (Button)e.widget;
        if (!button.isFocusControl()) {
            return;
        }
        boolean newValue = button.getSelection();
        ConnectionData edgeData = null;
        if (this.zestGraph.getSelection().size() == 1 && (selection = (GraphItem)this.zestGraph.getSelection().get(0)) instanceof GraphConnection) {
            edgeData = (ConnectionData)selection.getData();
        }
        if (this.attribute == 5) {
            edgeData.setMigrationAbsolute(newValue);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

