/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAStreamBuffer;

public class RAStreamBufferMgr {
    private RandomAccessFile randomFile;
    private int totalBuffer;
    private long length;
    private List bufferList = new ArrayList(128);
    private Map bufferMap = new HashMap();
    private RAStreamBuffer currentBuffer;

    public RAStreamBufferMgr(RandomAccessFile randomFile) throws IOException {
        this.randomFile = randomFile;
        this.length = randomFile.length();
        this.totalBuffer = 0;
        this.currentBuffer = null;
    }

    public long getFilePointer() {
        return this.currentBuffer == null ? 0L : this.currentBuffer.getOffset() + (long)this.currentBuffer.getBufCur();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.getBuffer(0L);
        }
        while (len > 0) {
            int ret = this.currentBuffer.write(b, off, len);
            off += ret;
            if ((len -= ret) <= 0) continue;
            this.currentBuffer = this.getBuffer(this.currentBuffer.getOffset() + 8192L);
            this.currentBuffer.setBufCur(0);
        }
        long fp = this.getFilePointer();
        if (fp > this.length) {
            this.length = fp;
        }
    }

    public void seek(long localPos) throws IOException {
        long offset = localPos / 8192L * 8192L;
        if (this.currentBuffer == null || this.currentBuffer.getOffset() != offset) {
            this.currentBuffer = this.getBuffer(offset);
        }
        this.currentBuffer.setBufCur((int)(localPos - offset));
        if (localPos > this.length) {
            this.length = localPos;
        }
    }

    public long length() {
        return this.length;
    }

    public void flushBuffer() throws IOException {
        int i = 0;
        while (i < this.totalBuffer) {
            RAStreamBuffer buffer = (RAStreamBuffer)this.bufferList.get(i);
            buffer.flushBuffer();
            ++i;
        }
    }

    private RAStreamBuffer getBuffer(long offset) throws IOException {
        Long offsetKey = new Long(offset);
        RAStreamBuffer buffer = (RAStreamBuffer)this.bufferMap.get(offsetKey);
        if (buffer != null) {
            return buffer;
        }
        if (this.totalBuffer < 128) {
            buffer = new RAStreamBuffer(this.randomFile);
            buffer.resetBuffer(offset);
            ++this.totalBuffer;
            this.bufferList.add(buffer);
            this.bufferMap.put(offsetKey, buffer);
            return buffer;
        }
        buffer = (RAStreamBuffer)this.bufferList.get(0);
        buffer.flushBuffer();
        this.bufferMap.remove(new Long(buffer.getOffset()));
        buffer.resetBuffer(offset);
        this.bufferMap.put(offsetKey, buffer);
        this.bufferList.remove(0);
        this.bufferList.add(buffer);
        return buffer;
    }
}

