/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.functionservice.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.impl.IFunctionProvider;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class FunctionProvider {
    private static Logger logger = Logger.getLogger(FunctionProvider.class.getName());
    private static String PROVIDER_CLASS = "org.eclipse.birt.core.internal.function.impl.FunctionProviderImpl";
    private static IFunctionProvider instance;

    public static void setFunctionProvider(IFunctionProvider provider) {
        instance = provider;
    }

    protected static synchronized IFunctionProvider getFunctionProvider() {
        if (instance == null) {
            try {
                Class<?> clazz = Class.forName(PROVIDER_CLASS);
                if (clazz != null) {
                    instance = (IFunctionProvider)clazz.newInstance();
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "failed to initialize IFunctionProvider instance", ex);
            }
        }
        return instance;
    }

    public static IScriptFunctionCategory[] getCategories() throws BirtException {
        IFunctionProvider provider = FunctionProvider.getFunctionProvider();
        if (provider != null) {
            return provider.getCategories();
        }
        return new IScriptFunctionCategory[0];
    }

    public static IScriptFunction[] getFunctions(String categoryName) throws BirtException {
        IFunctionProvider provider = FunctionProvider.getFunctionProvider();
        if (provider != null) {
            return provider.getFunctions(categoryName);
        }
        return new IScriptFunction[0];
    }

    public static void registerScriptFunction(Context cx, Scriptable scope) throws BirtException {
        IFunctionProvider provider = FunctionProvider.getFunctionProvider();
        if (provider != null) {
            provider.registerScriptFunction(cx, scope);
        }
    }
}

