/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.adapters.color.ColorProvider;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.IColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.IColorProviderChangedListener;
import org.eclipse.stem.ui.preferences.Messages;
import org.eclipse.stem.ui.widgets.ColorProviderPropertiesComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class GeoViewOptionsBar
extends Composite {
    private final List<PropertySelectionListener> selectionListeners = new CopyOnWriteArrayList<PropertySelectionListener>();
    protected final List<IColorProviderChangedListener> colorProviderChangedListeners = new CopyOnWriteArrayList<IColorProviderChangedListener>();
    Combo decoratorsCombo;
    Combo populationsCombo;
    Combo colorProvidersCombo;
    static final int DECORATORS_WIDTH = 35;
    static final int POPIDS_WIDTH = 25;
    static final int PROVIDERS_WIDTH = 45;
    Combo edgesCombo;
    Composite colorProviderComposite;
    Composite colorsLegendComposite;
    Group geoViewOptionsGroup;
    Group edgesGroup;
    List<Decorator> decorators;
    List<String> populationIdentifiers;
    List<Class<? extends ColorProvider>> supportedColorProviders = null;
    List<String> supportedColorProvidersNames = null;
    Map<String, String> edgeTypeToUriPrefixMap = new HashMap<String, String>();
    Class<? extends ColorProvider> selectedColorProvider = null;
    Decorator selectedDecorator;
    String selectedPopulationIdentifier;
    private DecoratorFilter decoratorFilter = new DecoratorFilter(){

        @Override
        public boolean accept(Decorator decorator) {
            EList labels = decorator.getLabelsToUpdate();
            if (labels == null) {
                return false;
            }
            for (DynamicLabel l : labels) {
                RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)l, RelativeValueProvider.class);
                if (rvp == null) continue;
                return true;
            }
            return false;
        }
    };

    public GeoViewOptionsBar(Composite parent, int style) {
        super(parent, style);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.fill = true;
        this.setLayout((Layout)rowLayout);
        this.geoViewOptionsGroup = new Group((Composite)this, 0);
        FormLayout formLayout = new FormLayout();
        this.geoViewOptionsGroup.setLayout((Layout)formLayout);
        this.geoViewOptionsGroup.setText(org.eclipse.stem.ui.views.geographic.map.Messages.getString("IMView.MProp"));
        this.geoViewOptionsGroup.setVisible(false);
        this.decoratorsCombo = new Combo((Composite)this.geoViewOptionsGroup, 0x100000C);
        this.populationsCombo = new Combo((Composite)this.geoViewOptionsGroup, 0x100000C);
        this.colorProvidersCombo = new Combo((Composite)this.geoViewOptionsGroup, 0x100000C);
        FormData decoratorsComboFormData = new FormData();
        decoratorsComboFormData.left = new FormAttachment(0, 0);
        decoratorsComboFormData.right = new FormAttachment(35, 0);
        this.decoratorsCombo.setLayoutData((Object)decoratorsComboFormData);
        FormData populationComboFormData = new FormData();
        populationComboFormData.top = new FormAttachment((Control)this.decoratorsCombo, 5);
        populationComboFormData.left = new FormAttachment(0, 0);
        populationComboFormData.right = new FormAttachment(25, 0);
        this.populationsCombo.setLayoutData((Object)populationComboFormData);
        FormData colorProvidersComboFormData = new FormData();
        colorProvidersComboFormData.top = new FormAttachment((Control)this.populationsCombo, 5);
        colorProvidersComboFormData.left = new FormAttachment(0, 0);
        colorProvidersComboFormData.right = new FormAttachment(45, 0);
        this.colorProvidersCombo.setLayoutData((Object)colorProvidersComboFormData);
        this.supportedColorProviders = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProviders();
        this.supportedColorProvidersNames = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProvidersNames();
        this.pack();
        this.decoratorsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Decorator tempDecorator;
                if (!GeoViewOptionsBar.this.decorators.isEmpty() && GeoViewOptionsBar.this.selectedDecorator != (tempDecorator = GeoViewOptionsBar.this.decorators.get(GeoViewOptionsBar.this.decoratorsCombo.getSelectionIndex()))) {
                    GeoViewOptionsBar.this.selectedDecorator = tempDecorator;
                    List<String> popIds = GeoViewOptionsBar.this.getPopulationIdentifiers(GeoViewOptionsBar.this.selectedDecorator);
                    GeoViewOptionsBar.this.populationIdentifiers = popIds;
                    if (GeoViewOptionsBar.this.populationIdentifiers != null) {
                        GeoViewOptionsBar.this.selectedPopulationIdentifier = GeoViewOptionsBar.this.populationIdentifiers.get(0);
                    }
                    GeoViewOptionsBar.this.initializeCombo(GeoViewOptionsBar.this.populationsCombo, GeoViewOptionsBar.this.getPopulationIdNames(popIds), GeoViewOptionsBar.this.getPopulationIdIndex(GeoViewOptionsBar.this.selectedPopulationIdentifier, GeoViewOptionsBar.this.populationIdentifiers));
                    GeoViewOptionsBar.this.updateColorProviderComposites();
                    GeoViewOptionsBar.this.firePropertySelectionEvent(new PropertySelectionEvent(GeoViewOptionsBar.this.selectedDecorator, GeoViewOptionsBar.this.selectedPopulationIdentifier, null, GeoViewOptionsBar.this.colorProvidersCombo));
                }
            }
        });
        this.populationsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String tempPopId;
                if (!GeoViewOptionsBar.this.populationIdentifiers.isEmpty() && !GeoViewOptionsBar.this.selectedPopulationIdentifier.equals(tempPopId = GeoViewOptionsBar.this.populationIdentifiers.get(GeoViewOptionsBar.this.populationsCombo.getSelectionIndex()))) {
                    GeoViewOptionsBar.this.selectedPopulationIdentifier = tempPopId;
                    GeoViewOptionsBar.this.updateColorProviderComposites();
                    GeoViewOptionsBar.this.firePropertySelectionEvent(new PropertySelectionEvent(GeoViewOptionsBar.this.selectedDecorator, GeoViewOptionsBar.this.selectedPopulationIdentifier, null, GeoViewOptionsBar.this.colorProvidersCombo));
                }
            }
        });
        this.colorProvidersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeoViewOptionsBar.this.selectedColorProvider = GeoViewOptionsBar.this.supportedColorProviders.get(GeoViewOptionsBar.this.colorProvidersCombo.getSelectionIndex());
                GeoViewOptionsBar.this.updateColorProviderComposites();
            }
        });
        this.edgesGroup = new Group((Composite)this, 0);
        this.edgesCombo = new Combo((Composite)this.edgesGroup, 0x100000C);
        this.edgesCombo.add("");
        this.edgesGroup.setLayout((Layout)new FormLayout());
        this.edgesGroup.setVisible(false);
        this.edgesGroup.setText(org.eclipse.stem.ui.views.geographic.map.Messages.getString("IMView.Edges"));
        this.edgesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedEdges = GeoViewOptionsBar.this.edgesCombo.getText();
                if (selectedEdges == null || selectedEdges.equals("")) {
                    GeoViewOptionsBar.this.firePropertySelectionEvent(null);
                } else {
                    String edgePrefix = GeoViewOptionsBar.this.edgeTypeToUriPrefixMap.get(selectedEdges);
                    GeoViewOptionsBar.this.firePropertySelectionEvent(new PropertySelectionEvent(null, null, null, edgePrefix));
                }
            }
        });
        this.setSimulation(null);
    }

    public boolean isInitialized() {
        return this.decorators != null && !this.decorators.isEmpty();
    }

    public void setDecorators(List<Decorator> decorators) {
        this.decorators = decorators;
        Decorator decorator = this.selectedDecorator = decorators.isEmpty() ? null : decorators.get(0);
        if (decorators.size() >= 2 && !(this.selectedDecorator instanceof DiseaseModel)) {
            int i = 0;
            while (i < decorators.size()) {
                if (decorators.get(i) instanceof DiseaseModel) {
                    this.selectedDecorator = decorators.get(i);
                    break;
                }
                ++i;
            }
        }
        List<String> popIds = this.getPopulationIdentifiers(this.selectedDecorator);
        this.populationIdentifiers = popIds;
        if (this.populationIdentifiers != null) {
            this.selectedPopulationIdentifier = this.populationIdentifiers.get(0);
        }
        this.initializeCombo(this.decoratorsCombo, this.getDecoratorNames(decorators), this.getDecoratorIndex(this.selectedDecorator, decorators));
        this.initializeCombo(this.populationsCombo, this.getPopulationIdNames(popIds), this.getPopulationIdIndex(this.selectedPopulationIdentifier, this.populationIdentifiers));
    }

    List<String> getPopulationIdentifiers(Decorator decorator) {
        if (decorator instanceof DiseaseModel) {
            return ((DiseaseModel)decorator).getAllLabelIdentifiers();
        }
        if (decorator instanceof PopulationModel) {
            return ((PopulationModel)decorator).getAllLabelIdentifiers();
        }
        return null;
    }

    public void setPopulationIdentifiers(List<String> popIds) {
        this.populationIdentifiers = popIds;
        this.selectedPopulationIdentifier = popIds.isEmpty() ? null : popIds.get(0);
        this.initializeCombo(this.populationsCombo, this.getPopulationIdNames(popIds), this.getPopulationIdIndex(this.selectedPopulationIdentifier, this.populationIdentifiers));
    }

    public void setColorProviders(List<Decorator> decorators) {
        if (this.supportedColorProviders.isEmpty()) {
            return;
        }
        for (String providerName : this.supportedColorProvidersNames) {
            this.colorProvidersCombo.add(providerName);
        }
        this.colorProvidersCombo.select(0);
        this.selectedColorProvider = this.supportedColorProviders.get(0);
        this.updateColorProviderComposites();
    }

    private void setEdges() {
        if (this.selectedDecorator == null) {
            return;
        }
        Set edgesURIs = this.selectedDecorator.getGraph().getEdges().keySet();
        for (URI nextUri : edgesURIs) {
            String edgePrefix = nextUri.trimSegments(1).toString();
            String edgeType = Messages.getString(edgePrefix);
            if (edgeType.startsWith("!") && edgeType.endsWith("!")) {
                edgePrefix = nextUri.trimSegments(2).toString();
                edgeType = Messages.getString(edgePrefix);
            }
            if (this.edgeTypeToUriPrefixMap.containsKey(edgeType)) continue;
            this.edgeTypeToUriPrefixMap.put(edgeType, edgePrefix);
            this.edgesCombo.add(edgeType);
        }
    }

    public void setSimulation(ISimulation simulation) {
        if (simulation == null) {
            return;
        }
        this.setDecorators(this.getDecoratorsToDisplay(simulation));
        if (this.decorators != null) {
            this.setColorProviders(this.decorators);
            this.geoViewOptionsGroup.setVisible(true);
            this.setEdges();
            this.edgesGroup.setVisible(true);
            this.getInformation(simulation);
        }
    }

    public void setDecoratorFilter(DecoratorFilter decoratorFilter) {
        this.decoratorFilter = decoratorFilter;
    }

    protected void updateColorProviderComposites() {
        AdapterFactory adapterFactory;
        if (this.colorProviderComposite != null) {
            this.colorProviderComposite.dispose();
        }
        if (this.colorsLegendComposite != null) {
            this.colorsLegendComposite.dispose();
        }
        if ((adapterFactory = ColorProviderAdapterFactory.INSTANCE.getFactoryForType(this.selectedColorProvider)) instanceof IColorProviderAdapterFactory) {
            IColorProviderAdapterFactory selectedColorProviderAdapterFactory = (IColorProviderAdapterFactory)adapterFactory;
            this.colorProviderComposite = selectedColorProviderAdapterFactory.createPropertiesComposite((Composite)this.geoViewOptionsGroup, 0, this.selectedDecorator, this.selectedPopulationIdentifier);
            if (this.colorProviderComposite == null) {
                return;
            }
            if (this.colorProviderComposite instanceof ColorProviderPropertiesComposite) {
                ((ColorProviderPropertiesComposite)this.colorProviderComposite).addPropertySelectionListener(new ColorProviderPropertiesComposite.PropertySelectionListener(){

                    @Override
                    public void propertySelected(ColorProviderPropertiesComposite.PropertySelectionEvent propertySelectionEvent) {
                        GeoViewOptionsBar.this.firePropertySelectionEvent(new PropertySelectionEvent(null, null, null, propertySelectionEvent.getSource()));
                    }
                });
            }
            FormData colorProviderCompositeFormData = new FormData();
            colorProviderCompositeFormData.top = new FormAttachment(0, 0);
            colorProviderCompositeFormData.left = new FormAttachment(35, 0);
            colorProviderCompositeFormData.right = new FormAttachment(45, 0);
            this.colorProviderComposite.setLayoutData((Object)colorProviderCompositeFormData);
            this.geoViewOptionsGroup.layout();
            this.colorsLegendComposite = selectedColorProviderAdapterFactory.createColorsLegendComposite(this, 0);
            if (this.colorsLegendComposite != null) {
                this.colorsLegendComposite.pack();
                this.colorsLegendComposite.layout();
            }
            this.layout();
        }
        this.fireColorProviderChangedEvent();
    }

    private List<Decorator> getDecoratorsToDisplay(ISimulation simulation) {
        Graph canonicalGraph;
        ArrayList<Decorator> retValue = new ArrayList<Decorator>();
        if (simulation != null && (canonicalGraph = simulation.getScenario().getCanonicalGraph()) != null) {
            for (Object element : canonicalGraph.getDecorators()) {
                Decorator decorator = (Decorator)element;
                if (!this.decoratorFilter.accept(decorator)) continue;
                retValue.add(decorator);
            }
        }
        return retValue;
    }

    private void getInformation(ISimulation simulation) {
        Graph canonicalGraph;
        if (simulation != null && (canonicalGraph = simulation.getScenario().getCanonicalGraph()) != null) {
            canonicalGraph.getGraphLabels();
            canonicalGraph.getNodeLabelsByTypeURI(URI.createURI((String)"stemtype://org.eclipse.stem/label/population"));
        }
    }

    private void initializeCombo(Combo combo, String[] names, int selectionIndex) {
        combo.setItems(names);
        combo.select(selectionIndex);
    }

    private String[] getDecoratorNames(List<Decorator> decorators) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (decorators != null) {
            Iterator<Decorator> iterator = decorators.iterator();
            while (iterator.hasNext()) {
                ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                Decorator decorator = iterator.next();
                IItemLabelProvider lp = (IItemLabelProvider)itemProviderFactory.adapt((Notifier)decorator, IItemLabelProvider.class);
                String title = lp.getText((Object)decorator);
                title = title == null ? "null" : title;
                retValue.add(title);
            }
        }
        return retValue.toArray(new String[0]);
    }

    private String[] getPopulationIdNames(List<String> popIds) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (popIds != null) {
            for (String decid : popIds) {
                String title = decid;
                title = title == null ? "null" : title;
                retValue.add(title);
            }
        }
        return retValue.toArray(new String[0]);
    }

    private int getDecoratorIndex(Decorator selectedDecorator, List<Decorator> decorators) {
        if (selectedDecorator != null && decorators != null && !decorators.isEmpty()) {
            return decorators.indexOf(selectedDecorator);
        }
        return 0;
    }

    private int getPopulationIdIndex(String selectedPopId, List<String> popIds) {
        if (selectedPopId != null && popIds != null && !popIds.isEmpty()) {
            return popIds.indexOf(selectedPopId);
        }
        return 0;
    }

    public void addPropertySelectionListener(PropertySelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removePropertySelectionListener(PropertySelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void firePropertySelectionEvent(PropertySelectionEvent pse) {
        for (PropertySelectionListener listener : this.selectionListeners) {
            listener.propertySelected(pse);
        }
    }

    public void addColorProviderChangedListener(IColorProviderChangedListener listener) {
        this.colorProviderChangedListeners.add(listener);
    }

    public void removeColorProviderChangedListener(IColorProviderChangedListener listener) {
        this.colorProviderChangedListeners.remove(listener);
    }

    protected void fireColorProviderChangedEvent() {
        for (IColorProviderChangedListener listener : this.colorProviderChangedListeners) {
            listener.colorProviderChanged(this.selectedColorProvider);
        }
    }

    public Decorator getSelectedDecorator() {
        return this.selectedDecorator;
    }

    public String getSelectedPopulationIdentifier() {
        return this.selectedPopulationIdentifier;
    }

    public static interface DecoratorFilter {
        public boolean accept(Decorator var1);
    }

    public static class PropertySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private final transient ItemPropertyDescriptor property;
        private final transient Decorator decorator;
        private final transient String populationIdentifier;

        public PropertySelectionEvent(Decorator decorator, String popId, ItemPropertyDescriptor property, Object source) {
            super(source);
            this.decorator = decorator;
            this.property = property;
            this.populationIdentifier = popId;
        }

        public final Decorator getDecorator() {
            return this.decorator;
        }

        public final String getPopulationIdentifier() {
            return this.populationIdentifier;
        }

        public final ItemPropertyDescriptor getProperty() {
            return this.property;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.decorator == null ? "null," : this.decorator.getDublinCore().getTitle());
            sb.append(this.property == null ? "null" : this.property.getDisplayName((Object)this.property));
            return sb.toString();
        }
    }

    public static interface PropertySelectionListener {
        public void propertySelected(PropertySelectionEvent var1);
    }
}

