/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.batch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.DisplaySafeExecutor;
import org.eclipse.stem.jobs.batch.BatchEvent;
import org.eclipse.stem.jobs.batch.BatchState;
import org.eclipse.stem.jobs.batch.IBatch;
import org.eclipse.stem.jobs.batch.IBatchListener;
import org.eclipse.stem.jobs.batch.IBatchListenerSync;
import org.eclipse.stem.jobs.batch.Messages;
import org.eclipse.stem.jobs.execution.Executable;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Batch
extends Executable
implements IBatch,
ISimulationListener {
    private BatchState batchState = BatchState.PAUSED;
    private Experiment experiment = null;
    private final List<ISimulation> activeSimulations = new ArrayList<ISimulation>();
    private boolean runningSimulationsSequentially = true;
    private boolean runningInBackground = false;
    private boolean keepRunning = true;
    private final List<IBatchListener> listeners = new CopyOnWriteArrayList<IBatchListener>();
    private final List<IBatchListenerSync> listenersSync = new CopyOnWriteArrayList<IBatchListenerSync>();
    private IProgressMonitor monitor;
    private boolean cancelRequested;

    Batch(Experiment experiment, int sequenceNumber) {
        super("Batch: " + sequenceNumber, sequenceNumber);
        this.experiment = experiment;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus retValue = Status.OK_STATUS;
        this.monitor = monitor;
        try {
            this.setBatchState(BatchState.RUNNING);
            monitor.beginTask("Batch: " + this.getSequenceNumber(), this.getTotalWork());
            this.getExperiment().initScenario();
            ISimulation simulation = this.getNextSimulationToRun();
            while (this.keepRunning && simulation != null) {
                this.setBatchState(BatchState.RUNNING);
                this.startSimulationRunning(simulation);
                if (!this.isRunningSimulationsSequentially()) {
                    if (monitor.isCanceled()) {
                        this.cancelRequested = true;
                        this.stopAllSimulations();
                        retValue = Status.CANCEL_STATUS;
                    }
                    simulation = this.getNextSimulationToRun();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.handleException(e);
            this.keepRunning = false;
            if (this.activeSimulations.size() > 0) {
                this.cancelRequested = true;
                this.stopAllSimulations();
            }
            monitor.done();
            this.setBatchState(BatchState.STOPPED);
        }
        return retValue;
    }

    private void handleException(Exception e) {
        String tempErrorMessage = "";
        boolean logIt = false;
        if (e instanceof NullPointerException) {
            if (this.experiment.getScenario() == null) {
                tempErrorMessage = MessageFormat.format(Messages.getString("Exp.MissingScenario"), this.getName());
            } else if (this.experiment.getScenario().getSequencer() == null) {
                tempErrorMessage = MessageFormat.format(Messages.getString("Exp.MissingSeq"), this.getName());
            } else if (this.experiment.getScenario().getModel() == null) {
                tempErrorMessage = MessageFormat.format(Messages.getString("Exp.MissingModel"), this.getName());
            } else {
                logIt = true;
                tempErrorMessage = MessageFormat.format(Messages.getString("Exp.IErr"), this.getName());
            }
        } else {
            logIt = true;
            tempErrorMessage = MessageFormat.format(Messages.getString("Exp.IErr"), this.getName());
        }
        final String errorMessage = tempErrorMessage;
        if (logIt) {
            Activator.logError(errorMessage, e);
        }
        try {
            Display d = DisplaySafeExecutor.safeGetDefaultDisplay();
            if (d != null) {
                d.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        Status warning = new Status(2, "org.eclipse.stem.jobs", 1, errorMessage, null);
                        ErrorDialog.openError((Shell)window.getShell(), null, null, (IStatus)warning);
                    }
                });
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private void stopAllSimulations() {
        for (ISimulation simulation : this.activeSimulations) {
            simulation.stop();
            simulation.cancel();
        }
    }

    private void startSimulationRunning(ISimulation simulation) {
        this.activeSimulations.add(simulation);
        simulation.addSimulationListener(this);
        simulation.run();
    }

    protected int getTotalWork() {
        return 1;
    }

    protected ISimulation getNextSimulationToRun() {
        ISimulation retValue = null;
        if (!this.experiment.isComplete()) {
            retValue = SimulationManager.getManager().createSimulation(this.experiment.updateScenario(), null);
        }
        return retValue;
    }

    @Override
    public void run() {
        this.schedule();
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void step() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop() {
        this.keepRunning = false;
    }

    @Override
    public boolean isRunning() {
        return !this.batchState.equals((Object)BatchState.PAUSED);
    }

    @Override
    public void simulationChanged(SimulationEvent event) {
        if (event.getSimulationState() == SimulationState.COMPLETED_SEQUENCE) {
            this.monitor.worked(1);
            event.getSimulation().stop();
            if (this.keepRunning) {
                if (!this.monitor.isCanceled() && this.runningSimulationsSequentially) {
                    ISimulation simulation = this.getNextSimulationToRun();
                    if (simulation != null) {
                        this.startSimulationRunning(simulation);
                    } else if (this.activeSimulations.size() == 0) {
                        this.monitor.done();
                        this.setBatchState(BatchState.STOPPED);
                    }
                }
            } else if (this.activeSimulations.size() == 0) {
                this.monitor.done();
                this.setBatchState(BatchState.STOPPED);
            }
        } else if (event.getSimulationState() == SimulationState.STOPPED) {
            this.activeSimulations.remove(event.getSimulation());
            event.getSimulation().removeSimulationListener(this);
            if (this.activeSimulations.size() == 0) {
                this.monitor.done();
                this.setBatchState(BatchState.STOPPED);
            }
        }
        if (!this.cancelRequested && this.monitor.isCanceled()) {
            this.keepRunning = false;
            this.cancelRequested = true;
            this.stopAllSimulations();
        }
        if (!this.keepRunning && !this.cancelRequested) {
            this.cancelRequested = true;
            this.stopAllSimulations();
        }
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    @Override
    public final BatchState getBatchState() {
        return this.batchState;
    }

    private void setBatchState(BatchState batchState) {
        if (this.getBatchState() != batchState) {
            this.batchState = batchState;
            this.fireBatchChanged(batchState);
        }
    }

    @Override
    public final boolean isRunningSimulationsSequentially() {
        return this.runningSimulationsSequentially;
    }

    @Override
    public final void setRunningSimulationsSequentially(boolean runningSimulationsSequentially) {
        this.runningSimulationsSequentially = runningSimulationsSequentially;
    }

    @Override
    public final boolean isRunningInBackground() {
        return this.runningInBackground;
    }

    @Override
    public final void setRunningInBackground(boolean runningInBackground) {
        this.runningInBackground = runningInBackground;
    }

    @Override
    public final void addBatchListener(IBatchListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public final void removeBatchListener(IBatchListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addBatchListenerSync(IBatchListenerSync listener) {
        if (!this.listenersSync.contains(listener)) {
            this.listenersSync.add(listener);
        }
    }

    @Override
    public void removeBatchListenerSync(IBatchListenerSync listener) {
        this.listenersSync.remove(listener);
    }

    private void fireBatchChanged(BatchState batchState) {
        BatchEvent event = new BatchEvent(this, batchState);
        for (IBatchListener iBatchListener : this.listeners) {
            iBatchListener.batchChanged(event);
        }
        for (IBatchListenerSync iBatchListenerSync : this.listenersSync) {
            iBatchListenerSync.batchChangedSync(event);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.getSequenceNumber());
        sb.append("] ");
        sb.append(this.isRunningSimulationsSequentially() ? "S/" : "P/");
        sb.append(this.isRunningInBackground() ? "B " : "F ");
        sb.append(this.getBatchState().toString());
        return sb.toString();
    }
}

