/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.stem.model.codegen.ModelGeneratorAdapter;
import org.eclipse.stem.model.codegen.STEMGenClass;
import org.eclipse.stem.model.codegen.descriptor.EClassDescriptor;
import org.eclipse.stem.model.codegen.descriptor.JavaClassDescriptor;

public class GeneratorUtils {
    public static List<STEMGenClass> getSTEMGenClasses(List<GenClass> genClasses) {
        ArrayList<STEMGenClass> classes = new ArrayList<STEMGenClass>();
        for (GenClass gc : genClasses) {
            classes.add(STEMGenClass.get(gc));
        }
        return classes;
    }

    public static List<GenClass> findGenClassesThatExtendBaseType(GenPackage pkg, EClassDescriptor descriptor) {
        ArrayList<GenClass> classes = new ArrayList<GenClass>();
        for (GenClass genClass : pkg.getGenClasses()) {
            if (!GeneratorUtils.classExtends(genClass, descriptor)) continue;
            classes.add(genClass);
        }
        return classes;
    }

    public static String getQualifiedJavaNameForDescriptor(JavaClassDescriptor descriptor) {
        if (descriptor != null) {
            return descriptor.getQualifiedClassName();
        }
        return null;
    }

    public static String getQualifiedJavaNameForDescriptor(GenPackage basePackage, EClassDescriptor descriptor) {
        GenClass gc;
        if (descriptor != null && (gc = GeneratorUtils.findGenClassForNSURI(basePackage, descriptor.getNSURI(), descriptor.getClassName())) != null) {
            return gc.getQualifiedInterfaceName();
        }
        return null;
    }

    public static GenClass findGenClassForNSURI(GenPackage baseGenPackage, String nsURI, String className) {
        GenPackage containerGenPackage = GeneratorUtils.findGenPackageForNSURI(baseGenPackage, nsURI);
        if (containerGenPackage != null) {
            return GeneratorUtils.findGenClassInPkg(containerGenPackage, className);
        }
        return null;
    }

    public static boolean classExtends(GenClass genClass, EClassDescriptor descriptor) {
        for (GenClass g2 : genClass.getAllBaseGenClasses()) {
            if (!g2.getGenPackage().getNSURI().equals(descriptor.getNSURI()) || !g2.getName().equals(descriptor.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, GenClass> getGenClassesForAnnotations(GenClass baseGenClass, EAnnotation annotation) {
        HashMap<String, GenClass> retVal = new HashMap<String, GenClass>();
        for (Map.Entry entry : annotation.getDetails().entrySet()) {
            GenClass match = GeneratorUtils.findGenClass(baseGenClass.getGenPackage(), (String)entry.getValue());
            retVal.put((String)entry.getKey(), match);
            if (match != null) continue;
            ModelGeneratorAdapter.addWarning("Unable to find class " + (String)entry.getValue() + " for " + baseGenClass.getName() + "/" + annotation.getSource() + "/" + (String)entry.getKey());
        }
        return retVal;
    }

    public static GenClass getDefaultOrFirstEntryFromMap(Map<String, GenClass> data, String defaultKey) {
        GenClass entry = GeneratorUtils.getDefaultEntryFromMap(data, defaultKey);
        if (entry == null && data != null && data.size() > 0) {
            entry = data.values().iterator().next();
        }
        return entry;
    }

    public static GenClass getDefaultEntryFromMap(Map<String, GenClass> data, String defaultKey) {
        GenClass defaultEntry = null;
        if (data != null) {
            defaultEntry = data.get(defaultKey);
        }
        return defaultEntry;
    }

    public static GenPackage findGenPackageForNSURI(GenPackage basePackage, String nsURI) {
        EList pkgs = basePackage.getGenModel().getUsedGenPackages();
        if (basePackage.getNSURI().equals(nsURI)) {
            return basePackage;
        }
        for (GenPackage pkg : pkgs) {
            if (!pkg.getNSURI().equals(nsURI)) continue;
            return pkg;
        }
        return null;
    }

    public static List<GenPackage> findGenPackageForJavaPackageName(GenPackage genPackage, String packageName) {
        EList pkgs = genPackage.getGenModel().getUsedGenPackages();
        ArrayList<GenPackage> candidates = new ArrayList<GenPackage>();
        if (genPackage.getClassPackageName().equals(packageName) || genPackage.getInterfacePackageName().equals(packageName)) {
            candidates.add(genPackage);
        }
        for (GenPackage pkg : pkgs) {
            if (!pkg.getClassPackageName().equals(packageName) && !pkg.getInterfacePackageName().equals(packageName)) continue;
            candidates.add(pkg);
        }
        return candidates;
    }

    private static GenClass findGenClass(GenPackage genPackage, String className) {
        String pkgName = null;
        int pkgIdx = className.lastIndexOf(46);
        if (pkgIdx >= 0) {
            pkgName = className.substring(0, pkgIdx);
            className = className.substring(pkgIdx + 1);
        }
        List<GenPackage> pkgsToSearch = null;
        if (pkgName != null) {
            pkgsToSearch = GeneratorUtils.findGenPackageForJavaPackageName(genPackage, pkgName);
        } else {
            pkgsToSearch = new ArrayList<GenPackage>();
            pkgsToSearch.add(genPackage);
            pkgsToSearch.addAll((Collection<GenPackage>)genPackage.getGenModel().getUsedGenPackages());
        }
        GenClass cls = null;
        for (GenPackage pkg : pkgsToSearch) {
            cls = GeneratorUtils.findGenClassInPkg(pkg, className);
            if (cls != null) break;
        }
        return cls;
    }

    private static GenClass findGenClassInPkg(GenPackage genPkg, String className) {
        GenClass match = null;
        for (GenClass cls : genPkg.getGenClasses()) {
            if (!cls.getName().equals(className) && !cls.getClassName().equals(className) && !cls.getInterfaceName().equals(className)) continue;
            match = cls;
            break;
        }
        return match;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static String formatToCapWords(String str) {
        StringBuilder sb = new StringBuilder();
        if (str.length() > 0) {
            sb.appendCodePoint(Character.toUpperCase(str.codePointAt(0)));
            int idx = 1;
            while (idx < str.length()) {
                int cp = str.codePointAt(idx);
                if (Character.isUpperCase(cp) && (Character.isLowerCase(str.codePointAt(idx - 1)) || str.length() > idx + 1 && Character.isLowerCase(str.codePointAt(idx + 1)))) {
                    sb.append(' ');
                }
                sb.appendCodePoint(cp);
                ++idx;
            }
        }
        return sb.toString();
    }
}

