/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.ui.wizards.ModelGeneratorWizard;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreatePackagePage
extends WizardPage {
    private Composite resourceLoaderContainer;
    private Button createNewPackageRadio;
    private Button loadPackageRadio;
    private Button browseFileSystemButton;
    private Button browseWorkspaceButton;
    private Button resourceLoadButton;
    private Text resourcePathText;
    private Package loadedPackage;

    public CreatePackagePage() {
        super("New Project Page");
        this.setTitle("New Project");
        this.setDescription("Create a new STEM Model Project");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.createNewPackageRadio = new Button(container, 16);
        GridData createNewPackageRadioData = new GridData(768);
        createNewPackageRadioData.grabExcessHorizontalSpace = true;
        this.createNewPackageRadio.setLayoutData((Object)createNewPackageRadioData);
        this.createNewPackageRadio.setText("Create and configure a new STEM Model Package");
        this.createNewPackageRadio.setSelection(true);
        this.createNewPackageRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreatePackagePage.this.radioToggled();
            }
        });
        this.validatePage();
        this.setControl((Control)container);
    }

    private Composite createResourceLoaderContainer(Composite parent) {
        Composite resourceLoaderContainer = new Composite(parent, 0);
        resourceLoaderContainer.setLayoutData((Object)new GridData(768));
        resourceLoaderContainer.setLayout((Layout)new GridLayout(1, false));
        Composite resourceButtonContainer = new Composite(resourceLoaderContainer, 0);
        resourceButtonContainer.setLayoutData((Object)new GridData(256));
        resourceButtonContainer.setLayout((Layout)new GridLayout(2, false));
        this.browseFileSystemButton = new Button(resourceButtonContainer, 8);
        this.browseFileSystemButton.setText("Browse File System");
        this.browseFileSystemButton.setLayoutData((Object)new GridData(128));
        this.browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog selectFileDialog = new FileDialog(CreatePackagePage.this.getShell(), 4096);
                selectFileDialog.setFilterExtensions(new String[]{"*.metamodel"});
                selectFileDialog.open();
                String path = selectFileDialog.getFilterPath();
                String fileName = selectFileDialog.getFileName();
                if (!WizardHelper.isNullOrEmpty(path) && !WizardHelper.isNullOrEmpty(fileName)) {
                    CreatePackagePage.this.resourcePathText.setText(URI.createFileURI((String)(String.valueOf(path) + File.separator + fileName)).toString());
                }
            }
        });
        this.browseWorkspaceButton = new Button(resourceButtonContainer, 8);
        this.browseWorkspaceButton.setText("Browse Workspace");
        this.browseWorkspaceButton.setLayoutData((Object)new GridData(128));
        this.browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceResourceDialog.openNewFile((Shell)CreatePackagePage.this.getShell(), null, null, null, null);
            }
        });
        Composite resourcePathContainer = new Composite(resourceLoaderContainer, 0);
        resourcePathContainer.setLayoutData((Object)new GridData(256));
        resourcePathContainer.setLayout((Layout)new GridLayout(3, false));
        Label fileToLoadLabel = new Label(resourcePathContainer, 0);
        fileToLoadLabel.setText("File To Load");
        this.resourcePathText = new Text(resourcePathContainer, 2048);
        this.resourcePathText.setLayoutData((Object)new GridData(768));
        this.resourceLoadButton = new Button(resourcePathContainer, 8);
        this.resourceLoadButton.setText("Load");
        this.resourceLoadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String uri = CreatePackagePage.this.resourcePathText.getText();
                Status status = null;
                if (!WizardHelper.isNullOrEmpty(uri)) {
                    try {
                        CreatePackagePage.this.load(URI.createURI((String)uri));
                        MessageDialog.openInformation((Shell)CreatePackagePage.this.getShell(), (String)"Model loaded", (String)"The selected model is loaded");
                    }
                    catch (Exception exp) {
                        status = new Status(4, "org.eclipse.stem.model.ui", 0, "An error occurred while loading the model definition file", (Throwable)exp);
                    }
                } else {
                    status = new Status(4, "org.eclipse.stem.model.ui", 0, "You must specify file to load", null);
                }
                if (status != null) {
                    ErrorDialog.openError((Shell)CreatePackagePage.this.getShell(), (String)"Load Error", (String)"Error loading the Model Package definition", (IStatus)status);
                }
            }
        });
        return resourceLoaderContainer;
    }

    protected void load(URI uri) throws Exception {
        this.loadedPackage = WizardHelper.loadPackageFromUri(uri);
        this.validatePage();
    }

    protected void radioToggled() {
        if (this.loadPackageRadio.getSelection()) {
            this.resourceLoaderContainer.setVisible(true);
        } else {
            this.resourceLoaderContainer.setVisible(false);
        }
        this.validatePage();
    }

    protected Package getPackage() {
        if (this.createNewPackageRadio.getSelection()) {
            return MetamodelFactory.eINSTANCE.createPackage();
        }
        return this.loadedPackage;
    }

    protected void validatePage() {
        Package selectedPackage = this.getPackage();
        if (selectedPackage != null) {
            this.setPageComplete(true);
            if (this.getWizard() instanceof ModelGeneratorWizard) {
                ((ModelGeneratorWizard)this.getWizard()).setPackage(selectedPackage);
            }
        } else {
            this.setPageComplete(false);
        }
    }
}

