/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointOrganizerExtension;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class BreakpointOrganizerManager {
    private static BreakpointOrganizerManager fgManager;
    private Map fOrganizers = new HashMap();
    private List fSorted = null;

    public static BreakpointOrganizerManager getDefault() {
        if (fgManager == null) {
            fgManager = new BreakpointOrganizerManager();
        }
        return fgManager;
    }

    private BreakpointOrganizerManager() {
        this.loadOrganizers();
        this.start("org.eclipse.debug.ui.workingSetOrganizer");
        this.start("org.eclipse.debug.ui.breakpointWorkingSetOrganizer");
    }

    private void start(String organizerId) {
        IBreakpointOrganizer organizer = this.getOrganizer(organizerId);
        IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
            }
        };
        organizer.addPropertyChangeListener(listener);
        organizer.removePropertyChangeListener(listener);
    }

    private void loadOrganizers() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "breakpointOrganizers");
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            BreakpointOrganizerExtension organizer = new BreakpointOrganizerExtension(element);
            if (BreakpointOrganizerManager.validateOrganizer(organizer)) {
                this.fOrganizers.put(organizer.getIdentifier(), organizer);
            }
            ++i;
        }
    }

    protected static boolean validateOrganizer(IBreakpointOrganizer organizer) {
        String id = organizer.getIdentifier();
        String label = organizer.getLabel();
        return id != null && id.length() > 0 && label != null && label.length() > 0;
    }

    public IBreakpointOrganizer[] getOrganizers() {
        if (this.fSorted == null) {
            Collection collection = this.fOrganizers.values();
            this.fSorted = new ArrayList();
            this.fSorted.addAll(collection);
            Collections.sort(this.fSorted, new Comparator(){

                public int compare(Object o1, Object o2) {
                    IBreakpointOrganizer b1 = (IBreakpointOrganizer)o1;
                    IBreakpointOrganizer b2 = (IBreakpointOrganizer)o2;
                    return b1.getLabel().compareTo(b2.getLabel());
                }

                public boolean equals(Object obj) {
                    return this == obj;
                }
            });
        }
        return this.fSorted.toArray(new IBreakpointOrganizer[this.fSorted.size()]);
    }

    public IBreakpointOrganizer getOrganizer(String id) {
        return (IBreakpointOrganizer)this.fOrganizers.get(id);
    }

    public void shutdown() {
        IBreakpointOrganizer[] organizers = this.getOrganizers();
        int i = 0;
        while (i < organizers.length) {
            IBreakpointOrganizer organizer = organizers[i];
            organizer.dispose();
            ++i;
        }
    }
}

