/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;

public class PartitionEndSkippingEditStrategy
extends AbstractEditStrategy {
    private String end;

    public PartitionEndSkippingEditStrategy withRightDelimiter(String end) {
        this.end = end;
        return this;
    }

    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.length == 0 && command.text.length() > 0) {
            ITypedRegion partition = document.getPartition(command.offset);
            String part = document.get(partition.getOffset(), partition.getLength());
            if (this.end != null) {
                int relativeOffset = command.offset - partition.getOffset();
                if (relativeOffset < partition.getLength() - this.end.length()) {
                    return;
                }
                if (!part.endsWith(this.end)) {
                    return;
                }
                String text = command.text;
                if (part.length() - relativeOffset < text.length()) {
                    text = text.substring(0, part.length() - relativeOffset);
                }
                if (part.substring(relativeOffset, relativeOffset + text.length()).equals(text)) {
                    command.length = text.length();
                }
            } else if (part.substring(command.offset - partition.getOffset()).equals(command.text)) {
                command.length = command.text.length();
            }
        }
    }
}

