/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.util.Strings;

public class JdtClasspathUriResolver
implements IClasspathUriResolver {
    private IJavaElement javaElement;

    public URI resolve(Object context, URI classpathUri) {
        if (!(context instanceof IJavaElement)) {
            throw new IllegalArgumentException("Context must implement IResource");
        }
        this.javaElement = (IJavaElement)context;
        try {
            if (ClasspathUriUtil.isClasspathUri((URI)classpathUri)) {
                IJavaProject javaProject = this.javaElement.getJavaProject();
                URI result = this.findResourceInWorkspace(javaProject, classpathUri);
                if (classpathUri.fragment() != null) {
                    result = result.appendFragment(classpathUri.fragment());
                }
                return result;
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    protected URI findResourceInWorkspace(IJavaProject javaProject, URI classpathUri) throws CoreException {
        if (javaProject.exists()) {
            String packagePath = classpathUri.trimSegments(1).path();
            String fullPath = classpathUri.path();
            String fileName = classpathUri.lastSegment();
            Path filePath = new Path(fileName);
            String packageName = Strings.isEmpty((String)packagePath) ? "" : packagePath.substring(1).replace('/', '.');
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
                if (packageFragment.exists()) {
                    IJarEntryResource jarEntryResource;
                    Object nonJavaResource;
                    int n3;
                    int n4;
                    Object[] objectArray;
                    Object[] nonJavaResources;
                    IResource packageFragmentResource = packageFragment.getResource();
                    if (packageFragmentResource instanceof IContainer) {
                        IFile file = ((IContainer)packageFragmentResource).getFile((IPath)filePath);
                        if (file.exists()) {
                            return this.createPlatformResourceURI((IResource)file);
                        }
                    } else if (packageFragmentRoot.isArchive()) {
                        objectArray = nonJavaResources = packageFragment.getNonJavaResources();
                        n4 = nonJavaResources.length;
                        n3 = 0;
                        while (n3 < n4) {
                            nonJavaResource = objectArray[n3];
                            jarEntryResource = (IJarEntryResource)nonJavaResource;
                            if (fullPath.equals(jarEntryResource.getFullPath().toString())) {
                                IResource packageFragmentRootResource = packageFragmentRoot.getResource();
                                if (packageFragmentRootResource != null) {
                                    URI packageFragmentRootURI = this.createPlatformResourceURI(packageFragmentRootResource);
                                    URI result = this.createArchiveURI(packageFragmentRootURI, fullPath);
                                    return result;
                                }
                                IPath packageFragmentRootPath = packageFragmentRoot.getPath();
                                URI packageFragmentRootURI = URI.createFileURI((String)packageFragmentRootPath.toString());
                                URI result = this.createArchiveURI(packageFragmentRootURI, fullPath);
                                return result;
                            }
                            ++n3;
                        }
                    } else if (packageFragmentRoot.isExternal()) {
                        objectArray = nonJavaResources = packageFragment.getNonJavaResources();
                        n4 = nonJavaResources.length;
                        n3 = 0;
                        while (n3 < n4) {
                            nonJavaResource = objectArray[n3];
                            jarEntryResource = (IJarEntryResource)nonJavaResource;
                            if (fileName.equals(jarEntryResource.getName())) {
                                IResource packageFragmentRootResource = ((ExternalPackageFragmentRoot)packageFragmentRoot).resource();
                                IPath absolutePath = packageFragmentRootResource.getFullPath();
                                absolutePath = absolutePath.append(fullPath);
                                return this.createPlatformResourceURI(absolutePath);
                            }
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
        }
        return classpathUri;
    }

    protected URI createArchiveURI(URI baseURI, String entryPath) {
        URI result = URI.createURI((String)("archive:" + baseURI.toString() + "!" + entryPath));
        return result;
    }

    protected URI createPlatformResourceURI(IResource resource) {
        IPath resourcePath = resource.getFullPath();
        return this.createPlatformResourceURI(resourcePath);
    }

    private URI createPlatformResourceURI(IPath resourcePath) {
        URI result = URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true);
        return result;
    }
}

