/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

public class XExpressionHelper {
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private TypeConformanceComputer conformanceComputer;
    @Inject
    private TypeReferences typeReferences;

    public boolean isLiteral(XExpression expr) {
        if (expr.eClass().getEPackage() != XbasePackage.eINSTANCE) {
            return false;
        }
        switch (expr.eClass().getClassifierID()) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    public boolean isFieldOrVariableReference(XExpression expr) {
        if (expr instanceof XFeatureCall) {
            XFeatureCall featureCall = (XFeatureCall)expr;
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (feature == null || feature.eIsProxy()) {
                return false;
            }
            if (feature instanceof JvmField || feature instanceof JvmFormalParameter || feature instanceof XVariableDeclaration) {
                return true;
            }
        }
        return false;
    }

    public boolean hasSideEffects(XExpression expr) {
        if (expr instanceof XClosure || expr instanceof XStringLiteral || expr instanceof XTypeLiteral || expr instanceof XBooleanLiteral || expr instanceof XNumberLiteral || expr instanceof XNullLiteral) {
            return false;
        }
        if (expr instanceof XAssignment) {
            return true;
        }
        if (expr instanceof XAbstractFeatureCall) {
            JvmOperation jvmOperation;
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)expr;
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (feature instanceof JvmConstructor) {
                return true;
            }
            return feature instanceof JvmOperation && this.findPureAnnotation((JvmExecutable)(jvmOperation = (JvmOperation)feature)) == null;
        }
        if (expr instanceof XConstructorCall) {
            XConstructorCall constrCall = (XConstructorCall)expr;
            return this.findPureAnnotation((JvmExecutable)constrCall.getConstructor()) == null;
        }
        return true;
    }

    public JvmAnnotationReference findInlineAnnotation(XAbstractFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature instanceof JvmAnnotationTarget) {
            return this.findAnnotation((JvmAnnotationTarget)feature, Inline.class.getName());
        }
        return null;
    }

    public JvmAnnotationReference findPureAnnotation(JvmExecutable featureCall) {
        return this.findAnnotation((JvmAnnotationTarget)featureCall, Pure.class.getName());
    }

    protected JvmAnnotationReference findAnnotation(JvmAnnotationTarget feature, String annotationType) {
        if (annotationType == null) {
            throw new NullPointerException();
        }
        EList annotations = feature.getAnnotations();
        for (JvmAnnotationReference annotation : annotations) {
            if (!annotationType.equals(annotation.getAnnotation().getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    public String getAndOperator() {
        return "&&";
    }

    public String getOrOperator() {
        return "||";
    }

    public boolean isShortCircuiteBooleanOperation(XAbstractFeatureCall featureCall) {
        if (featureCall instanceof XBinaryOperation) {
            XExpression leftOperand = ((XBinaryOperation)featureCall).getLeftOperand();
            String op = featureCall.getConcreteSyntaxFeatureName();
            if (this.getAndOperator().equals(op) || this.getOrOperator().equals(op)) {
                JvmTypeReference booleanType = this.typeReferences.getTypeForName(Boolean.TYPE, (Notifier)leftOperand, new JvmTypeReference[0]);
                JvmTypeReference leftOperandType = this.typeProvider.getType(leftOperand);
                JvmTypeReference operationReturnType = this.typeProvider.getType(featureCall);
                return this.conformanceComputer.isConformant(booleanType, leftOperandType) && this.conformanceComputer.isConformant(booleanType, operationReturnType);
            }
        }
        return false;
    }

    public boolean isInlined(XAbstractFeatureCall call) {
        return this.findInlineAnnotation(call) != null;
    }
}

