/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.TemporaryTraceRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class LeafIterator
extends AbstractIterator<AbstractTraceRegion> {
    private AbstractTraceRegion current;
    private int expectedOffset;
    private int expectedLine;
    private LinkedList<Integer> traversalIndizes = Lists.newLinkedList();

    public LeafIterator(AbstractTraceRegion root) {
        this.current = root;
        this.expectedOffset = root.getMyOffset();
        this.expectedLine = root.getMyLineNumber();
    }

    protected AbstractTraceRegion computeNext() {
        if (this.current.getMyOffset() == this.expectedOffset) {
            return this.firstLeafOfCurrent();
        }
        if (this.current.getNestedRegions().isEmpty()) {
            this.current = this.current.getParent();
        }
        int idx = this.traversalIndizes.removeLast();
        while (idx == this.current.getNestedRegions().size() - 1) {
            if (this.expectedOffset != this.current.getMyOffset() + this.current.getMyLength()) {
                this.traversalIndizes.add(idx);
                TemporaryTraceRegion result = new TemporaryTraceRegion(this.expectedOffset, this.current.getMyOffset() + this.current.getMyLength() - this.expectedOffset, this.expectedLine, this.current.getMyEndLineNumber(), this.current.getAssociatedLocations(), this.current);
                this.expectedOffset = this.current.getMyOffset() + this.current.getMyLength();
                this.expectedLine = this.current.getMyEndLineNumber();
                return result;
            }
            if (this.traversalIndizes.isEmpty()) {
                return (AbstractTraceRegion)this.endOfData();
            }
            this.current = this.current.getParent();
            idx = this.traversalIndizes.removeLast();
        }
        if (idx < this.current.getNestedRegions().size() - 1) {
            AbstractTraceRegion next = this.current.getNestedRegions().get(idx + 1);
            if (next.getMyOffset() < this.expectedOffset) {
                return (AbstractTraceRegion)this.endOfData();
            }
            if (next.getMyOffset() == this.expectedOffset) {
                this.current = next;
                this.traversalIndizes.add(idx + 1);
                return this.firstLeafOfCurrent();
            }
            AbstractTraceRegion parent = this.current;
            TemporaryTraceRegion result = new TemporaryTraceRegion(this.expectedOffset, next.getMyOffset() - this.expectedOffset, this.expectedLine, next.getMyLineNumber(), this.current.getAssociatedLocations(), parent);
            this.traversalIndizes.add(idx);
            this.expectedOffset = next.getMyOffset();
            this.expectedLine = next.getMyLineNumber();
            return result;
        }
        return (AbstractTraceRegion)this.endOfData();
    }

    protected AbstractTraceRegion firstLeafOfCurrent() {
        while (!this.current.getNestedRegions().isEmpty()) {
            AbstractTraceRegion next = this.current.getNestedRegions().get(0);
            if (next.getMyOffset() != this.current.getMyOffset()) {
                TemporaryTraceRegion result = new TemporaryTraceRegion(this.current.getMyOffset(), next.getMyOffset() - this.current.getMyOffset(), this.current.getMyLineNumber(), next.getMyLineNumber(), this.current.getAssociatedLocations(), this.current);
                this.traversalIndizes.add(-1);
                this.expectedOffset = next.getMyOffset();
                this.expectedLine = next.getMyLineNumber();
                return result;
            }
            this.traversalIndizes.add(0);
            this.current = next;
        }
        this.expectedOffset = this.current.getMyOffset() + this.current.getMyLength();
        this.expectedLine = this.current.getMyEndLineNumber();
        return this.current;
    }
}

