/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.chain.plugin;

import org.eclipse.tea.library.build.chain.TeaBuildElement;
import org.eclipse.tea.library.build.chain.TeaBuildProjectElement;
import org.eclipse.tea.library.build.chain.TeaDependencyWire;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.PluginData;

public class TeaBuildPluginElement
extends TeaBuildProjectElement {
    private State state = State.NEW;
    private final PluginBuild plugin;

    public TeaBuildPluginElement(PluginBuild pb) {
        super(((PluginData)pb.getData()).getProject());
        this.plugin = pb;
    }

    public PluginBuild getPlugin() {
        return this.plugin;
    }

    public boolean isAllDependenciesBuilt() {
        if (this.state == State.OK) {
            return true;
        }
        for (TeaDependencyWire wire : this.getDependencyWires()) {
            TeaBuildElement e = wire.getTarget();
            if (!(e instanceof TeaBuildPluginElement) || ((TeaBuildPluginElement)e).state == State.OK) continue;
            return false;
        }
        return true;
    }

    public void done() {
        this.state = State.OK;
    }

    public void error() {
        this.state = State.ERROR;
    }

    @Override
    public String getName() {
        return this.plugin.getPluginName();
    }

    private static enum State {
        NEW,
        OK,
        ERROR;

    }
}

