/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.latency.analyzer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.linuxtools.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.lttng.core.latency.analyzer.StackWrapper;
import org.eclipse.linuxtools.lttng.core.util.EventsPair;

public class EventMatcher {
    private static EventMatcher fInstance = null;
    private StackWrapper fStack = new StackWrapper();
    private HashMap<String, String> fMatch = new HashMap();
    private HashMap<String, String> fInverseMatch = new HashMap();
    private int fProcessedEvents = 0;
    private int fMatchedEvents = 0;
    public static final String ADD_TO_PAGE_CACHE = "add_to_page_cache";
    public static final String BIO_BACKMERGE = "bio_backmerge";
    public static final String BIO_FRONTMERGE = "bio_frontmerge";
    public static final String BIO_QUEUE = "bio_queue";
    public static final String BUFFER_WAIT_END = "buffer_wait_end";
    public static final String BUFFER_WAIT_START = "buffer_wait_start";
    public static final String CALL = "call";
    public static final String CLOSE = "close";
    public static final String CORE_MARKER_FORMAT = "core_marker_format";
    public static final String CORE_MARKER_ID = "core_marker_id";
    public static final String DEV_RECEIVE = "dev_receive";
    public static final String DEV_XMIT = "dev_xmit";
    public static final String END_COMMIT = "end_commit";
    public static final String EXEC = "exec";
    public static final String FILE_DESCRIPTOR = "file_descriptor";
    public static final String GETRQ = "getrq";
    public static final String GETRQ_BIO = "getrq_bio";
    public static final String IDT_TABLE = "idt_table";
    public static final String INTERRUPT = "interrupt";
    public static final String IOCTL = "ioctl";
    public static final String IRQ_ENTRY = "irq_entry";
    public static final String IRQ_EXIT = "irq_exit";
    public static final String LIST_MODULE = "list_module";
    public static final String LLSEEK = "llseek";
    public static final String LSEEK = "lseek";
    public static final String NAPI_COMPLETE = "napi_complete";
    public static final String NAPI_POLL = "napi_poll";
    public static final String NAPI_SCHEDULE = "napi_schedule";
    public static final String NETWORK_IPV4_INTERFACE = "network_ipv4_interface";
    public static final String NETWORK_IP_INTERFACE = "network_ip_interface";
    public static final String OPEN = "open";
    public static final String PAGE_FAULT_ENTRY = "page_fault_entry";
    public static final String PAGE_FAULT_EXIT = "page_fault_exit";
    public static final String PAGE_FAULT_GET_USER_ENTRY = "page_fault_get_user_entry";
    public static final String PAGE_FAULT_GET_USER_EXIT = "page_fault_get_user_exit";
    public static final String PAGE_FREE = "page_free";
    public static final String PLUG = "plug";
    public static final String POLLFD = "pollfd";
    public static final String PREAD64 = "pread64";
    public static final String PRINTF = "printf";
    public static final String PRINTK = "printk";
    public static final String PROCESS_EXIT = "process_exit";
    public static final String PROCESS_FORK = "process_fork";
    public static final String PROCESS_FREE = "process_free";
    public static final String PROCESS_STATE = "process_state";
    public static final String PROCESS_WAIT = "process_wait";
    public static final String READ = "read";
    public static final String REMAP = "remap";
    public static final String REMOVE_FROM_PAGE_CACHE = "remove_from_page_cache";
    public static final String RQ_COMPLETE_FS = "rq_complete_fs";
    public static final String RQ_COMPLETE_PC = "rq_complete_pc";
    public static final String RQ_INSERT_FS = "rq_insert_fs";
    public static final String RQ_INSERT_PC = "rq_insert_pc";
    public static final String RQ_ISSUE_FS = "rq_issue_fs";
    public static final String RQ_ISSUE_PC = "rq_issue_pc";
    public static final String RQ_REQUEUE_PC = "rq_requeue_pc";
    public static final String SCHED_MIGRATE_TASK = "sched_migrate_task";
    public static final String SCHED_SCHEDULE = "sched_schedule";
    public static final String SCHED_TRY_WAKEUP = "sched_try_wakeup";
    public static final String SCHED_WAKEUP_NEW_TASK = "sched_wakeup_new_task";
    public static final String SELECT = "select";
    public static final String SEM_CREATE = "sem_create";
    public static final String SEND_SIGNAL = "send_signal";
    public static final String SHM_CREATE = "shm_create";
    public static final String SLEEPRQ_BIO = "sleeprq_bio";
    public static final String SOCKET_ACCEPT = "socket_accept";
    public static final String SOCKET_BIND = "socket_bind";
    public static final String SOCKET_CALL = "socket_call";
    public static final String SOCKET_CONNECT = "socket_connect";
    public static final String SOCKET_CREATE = "socket_create";
    public static final String SOCKET_GETPEERNAME = "socket_getpeername";
    public static final String SOCKET_GETSOCKNAME = "socket_getsockname";
    public static final String SOCKET_GETSOCKOPT = "socket_getsockopt";
    public static final String SOCKET_LISTEN = "socket_listen";
    public static final String SOCKET_SETSOCKOPT = "socket_setsockopt";
    public static final String SOCKET_SHUTDOWN = "socket_shutdown";
    public static final String SOCKET_SOCKETPAIR = "socket_socketpair";
    public static final String SOFTIRQ_ENTRY = "softirq_entry";
    public static final String SOFTIRQ_EXIT = "softirq_exit";
    public static final String SOFTIRQ_RAISE = "softirq_raise";
    public static final String SOFTIRQ_VEC = "softirq_vec";
    public static final String START_COMMIT = "start_commit";
    public static final String STATEDUMP_END = "statedump_end";
    public static final String SYS_CALL_TABLE = "sys_call_table";
    public static final String SYSCALL_ENTRY = "syscall_entry";
    public static final String SYSCALL_EXIT = "syscall_exit";
    public static final String TASKLET_LOW_ENTRY = "tasklet_low_entry";
    public static final String TASKLET_LOW_EXIT = "tasklet_low_exit";
    public static final String TCPV4_RCV = "tcpv4_rcv";
    public static final String TIMER_ITIMER_EXPIRED = "timer_itimer_expired";
    public static final String TIMER_ITIMER_SET = "timer_itimer_set";
    public static final String TIMER_SET = "timer_set";
    public static final String TIMER_TIMEOUT = "timer_timeout";
    public static final String TIMER_UPDATE_TIME = "timer_update_time";
    public static final String UDPV4_RCV = "udpv4_rcv";
    public static final String UNPLUG_IO = "unplug_io";
    public static final String UNPLUG_TIMER = "unplug_timer";
    public static final String VM_MAP = "vm_map";
    public static final String VPRINTK = "vprintk";
    public static final String WAIT_ON_PAGE_END = "wait_on_page_end";
    public static final String WAIT_ON_PAGE_START = "wait_on_page_start";
    public static final String WRITE = "write";
    public static final String WRITEV = "writev";

    private EventMatcher() {
        this.createMatchTable();
    }

    public static EventMatcher getInstance() {
        if (fInstance == null) {
            fInstance = new EventMatcher();
        }
        return fInstance;
    }

    public int getNBProcessedEvents() {
        return this.fProcessedEvents;
    }

    public int getNBMatchedEvents() {
        return this.fMatchedEvents;
    }

    public static void releaseInstance() {
        fInstance = null;
    }

    private void createMatchTable() {
        this.fMatch.put(PAGE_FAULT_GET_USER_EXIT, PAGE_FAULT_GET_USER_ENTRY);
        this.fMatch.put(TASKLET_LOW_EXIT, TASKLET_LOW_ENTRY);
        this.fMatch.put(PAGE_FAULT_EXIT, PAGE_FAULT_ENTRY);
        this.fMatch.put(SYSCALL_EXIT, SYSCALL_ENTRY);
        this.fMatch.put(IRQ_EXIT, IRQ_ENTRY);
        this.fMatch.put(WRITE, READ);
        this.fMatch.put(CLOSE, OPEN);
        this.fMatch.put(BUFFER_WAIT_END, BUFFER_WAIT_START);
        this.fMatch.put(END_COMMIT, START_COMMIT);
        this.fMatch.put(WAIT_ON_PAGE_END, WAIT_ON_PAGE_START);
        Set<Map.Entry<String, String>> pairs = this.fMatch.entrySet();
        for (Map.Entry<String, String> pair : pairs) {
            this.fInverseMatch.put(pair.getValue(), pair.getKey());
        }
    }

    public LttngEvent process(LttngEvent event) {
        ++this.fProcessedEvents;
        String markerName = event.getMarkerName();
        if (this.fMatch.containsKey(markerName)) {
            String startEventType = this.fMatch.get(markerName);
            Stack<LttngEvent> events = this.fStack.getStackOf(startEventType);
            if (events != null) {
                int i = events.size() - 1;
                while (i >= 0) {
                    LttngEvent request = (LttngEvent)((Object)events.get(i));
                    if (request.getCpuId() == event.getCpuId() && event.getTimestamp().getValue() > request.getTimestamp().getValue()) {
                        this.fStack.removeEvent(startEventType, request);
                        ++this.fMatchedEvents;
                        return request;
                    }
                    --i;
                }
            }
            return null;
        }
        if (this.fMatch.containsValue(event.getMarkerName())) {
            this.fStack.put(event.clone());
        }
        return null;
    }

    public void clearStack() {
        this.fStack.clear();
        this.fProcessedEvents = 0;
        this.fMatchedEvents = 0;
    }

    public void resetMatches() {
        this.fMatch.clear();
        this.fInverseMatch.clear();
        this.fStack.clear();
        this.fProcessedEvents = 0;
        this.fMatchedEvents = 0;
    }

    public Collection<String> getStartEvents() {
        return this.fMatch.values();
    }

    public Set<String> getEndEvents() {
        return this.fMatch.keySet();
    }

    public EventsPair getEvents() {
        Vector<String> start = new Vector<String>(this.getStartEvents());
        Vector<String> end = new Vector<String>(this.fMatch.size());
        Collections.sort(start);
        int i = 0;
        while (i < start.size()) {
            end.add(this.fInverseMatch.get(start.get(i)));
            ++i;
        }
        return new EventsPair(start, end);
    }

    public void addMatch(String startType, String endType) {
        this.fMatch.put(endType, startType);
        this.fInverseMatch.put(startType, endType);
    }

    public void removeMatch(String startType, String endType) {
        this.fMatch.remove(endType);
        this.fInverseMatch.remove(startType);
    }

    public Vector<String> getTypeList() {
        Vector<String> eventsList = new Vector<String>(103);
        eventsList.add(ADD_TO_PAGE_CACHE);
        eventsList.add(BIO_BACKMERGE);
        eventsList.add(BIO_FRONTMERGE);
        eventsList.add(BIO_QUEUE);
        eventsList.add(BUFFER_WAIT_END);
        eventsList.add(BUFFER_WAIT_START);
        eventsList.add(CALL);
        eventsList.add(CLOSE);
        eventsList.add(CORE_MARKER_FORMAT);
        eventsList.add(CORE_MARKER_ID);
        eventsList.add(DEV_RECEIVE);
        eventsList.add(DEV_XMIT);
        eventsList.add(END_COMMIT);
        eventsList.add(EXEC);
        eventsList.add(FILE_DESCRIPTOR);
        eventsList.add(GETRQ);
        eventsList.add(GETRQ_BIO);
        eventsList.add(IDT_TABLE);
        eventsList.add(INTERRUPT);
        eventsList.add(IOCTL);
        eventsList.add(IRQ_ENTRY);
        eventsList.add(IRQ_EXIT);
        eventsList.add(LIST_MODULE);
        eventsList.add(LLSEEK);
        eventsList.add(LSEEK);
        eventsList.add(NAPI_COMPLETE);
        eventsList.add(NAPI_POLL);
        eventsList.add(NAPI_SCHEDULE);
        eventsList.add(NETWORK_IPV4_INTERFACE);
        eventsList.add(NETWORK_IP_INTERFACE);
        eventsList.add(OPEN);
        eventsList.add(PAGE_FAULT_ENTRY);
        eventsList.add(PAGE_FAULT_EXIT);
        eventsList.add(PAGE_FAULT_GET_USER_ENTRY);
        eventsList.add(PAGE_FAULT_GET_USER_EXIT);
        eventsList.add(PAGE_FREE);
        eventsList.add(PLUG);
        eventsList.add(POLLFD);
        eventsList.add(PREAD64);
        eventsList.add(PRINTF);
        eventsList.add(PRINTK);
        eventsList.add(PROCESS_EXIT);
        eventsList.add(PROCESS_FORK);
        eventsList.add(PROCESS_FREE);
        eventsList.add(PROCESS_STATE);
        eventsList.add(PROCESS_WAIT);
        eventsList.add(READ);
        eventsList.add(REMAP);
        eventsList.add(REMOVE_FROM_PAGE_CACHE);
        eventsList.add(RQ_COMPLETE_FS);
        eventsList.add(RQ_COMPLETE_PC);
        eventsList.add(RQ_INSERT_FS);
        eventsList.add(RQ_INSERT_PC);
        eventsList.add(RQ_ISSUE_FS);
        eventsList.add(RQ_ISSUE_PC);
        eventsList.add(RQ_REQUEUE_PC);
        eventsList.add(SCHED_MIGRATE_TASK);
        eventsList.add(SCHED_SCHEDULE);
        eventsList.add(SCHED_TRY_WAKEUP);
        eventsList.add(SCHED_WAKEUP_NEW_TASK);
        eventsList.add(SELECT);
        eventsList.add(SEM_CREATE);
        eventsList.add(SEND_SIGNAL);
        eventsList.add(SHM_CREATE);
        eventsList.add(SLEEPRQ_BIO);
        eventsList.add(SOCKET_ACCEPT);
        eventsList.add(SOCKET_BIND);
        eventsList.add(SOCKET_CALL);
        eventsList.add(SOCKET_CONNECT);
        eventsList.add(SOCKET_CREATE);
        eventsList.add(SOCKET_GETPEERNAME);
        eventsList.add(SOCKET_GETSOCKNAME);
        eventsList.add(SOCKET_GETSOCKOPT);
        eventsList.add(SOCKET_LISTEN);
        eventsList.add(SOCKET_SETSOCKOPT);
        eventsList.add(SOCKET_SHUTDOWN);
        eventsList.add(SOCKET_SOCKETPAIR);
        eventsList.add(SOFTIRQ_ENTRY);
        eventsList.add(SOFTIRQ_EXIT);
        eventsList.add(SOFTIRQ_RAISE);
        eventsList.add(SOFTIRQ_VEC);
        eventsList.add(START_COMMIT);
        eventsList.add(STATEDUMP_END);
        eventsList.add(SYS_CALL_TABLE);
        eventsList.add(SYSCALL_ENTRY);
        eventsList.add(SYSCALL_EXIT);
        eventsList.add(TASKLET_LOW_ENTRY);
        eventsList.add(TASKLET_LOW_EXIT);
        eventsList.add(TCPV4_RCV);
        eventsList.add(TIMER_ITIMER_EXPIRED);
        eventsList.add(TIMER_ITIMER_SET);
        eventsList.add(TIMER_SET);
        eventsList.add(TIMER_TIMEOUT);
        eventsList.add(TIMER_UPDATE_TIME);
        eventsList.add(UDPV4_RCV);
        eventsList.add(UNPLUG_IO);
        eventsList.add(UNPLUG_TIMER);
        eventsList.add(VM_MAP);
        eventsList.add(VPRINTK);
        eventsList.add(WAIT_ON_PAGE_END);
        eventsList.add(WAIT_ON_PAGE_START);
        eventsList.add(WRITE);
        eventsList.add(WRITEV);
        return eventsList;
    }

    public void print() {
        this.fStack.printContent();
    }
}

