/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.rpm.core.IProjectConfiguration;
import org.eclipse.linuxtools.rpm.core.utils.Utils;

public class RPM {
    private static final String DEFINE = "--define";
    private String[] macroDefines;
    private String rpmCmd;

    public RPM(IProjectConfiguration config) {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.core");
        this.rpmCmd = node.get("RPM_CMD", "");
        String[] tmpMacroDefines = new String[]{this.rpmCmd, "-v", DEFINE, "_sourcedir " + config.getSourcesFolder().getLocation().toOSString(), DEFINE, "_srcrpmdir " + config.getSrpmsFolder().getLocation().toOSString(), DEFINE, "_builddir " + config.getBuildFolder().getLocation().toOSString(), DEFINE, "_rpmdir " + config.getRpmsFolder().getLocation().toOSString(), DEFINE, "_specdir " + config.getSpecsFolder().getLocation().toOSString()};
        this.macroDefines = tmpMacroDefines;
    }

    public String install(IFile sourceRPM) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.macroDefines));
        command.add("-i");
        command.add(sourceRPM.getLocation().toOSString());
        try {
            return Utils.runCommandToString(command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }
}

