/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.request;

import java.util.concurrent.CountDownLatch;
import org.eclipse.linuxtools.tmf.core.Tracer;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;

public abstract class TmfDataRequest<T extends ITmfEvent>
implements ITmfDataRequest<T> {
    public static final int DEFAULT_BLOCK_SIZE = 1000;
    public static final int ALL_DATA = Integer.MAX_VALUE;
    private static int fRequestNumber = 0;
    private final Class<T> fDataType;
    private final ITmfDataRequest.ExecutionType fExecType;
    private final int fRequestId;
    private int fIndex;
    private final int fNbRequested;
    private final int fBlockSize;
    private int fNbRead;
    private CountDownLatch startedLatch = new CountDownLatch(1);
    private CountDownLatch completedLatch = new CountDownLatch(1);
    private boolean fRequestRunning;
    private boolean fRequestCompleted;
    private boolean fRequestFailed;
    private boolean fRequestCanceled;

    public static void reset() {
        fRequestNumber = 0;
    }

    public TmfDataRequest(Class<T> dataType) {
        this(dataType, 0, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfDataRequest(Class<T> dataType, ITmfDataRequest.ExecutionType execType) {
        this(dataType, 0, Integer.MAX_VALUE, 1000, execType);
    }

    public TmfDataRequest(Class<T> dataType, int index) {
        this(dataType, index, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfDataRequest(Class<T> dataType, int index, ITmfDataRequest.ExecutionType execType) {
        this(dataType, index, Integer.MAX_VALUE, 1000, execType);
    }

    public TmfDataRequest(Class<T> dataType, int index, int nbRequested) {
        this(dataType, index, nbRequested, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfDataRequest(Class<T> dataType, int index, int nbRequested, ITmfDataRequest.ExecutionType execType) {
        this(dataType, index, nbRequested, 1000, execType);
    }

    public TmfDataRequest(Class<T> dataType, int index, int nbRequested, int blockSize) {
        this(dataType, index, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfDataRequest(Class<T> dataType, int index, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType execType) {
        this.fRequestId = fRequestNumber++;
        this.fDataType = dataType;
        this.fIndex = index;
        this.fNbRequested = nbRequested;
        this.fBlockSize = blockSize;
        this.fExecType = execType;
        this.fNbRead = 0;
        this.fRequestRunning = false;
        this.fRequestCompleted = false;
        this.fRequestFailed = false;
        this.fRequestCanceled = false;
        if (Tracer.isRequestTraced()) {
            Tracer.traceRequest(this, "created");
        }
    }

    private TmfDataRequest(TmfDataRequest<T> other) {
        this(null, 0, Integer.MAX_VALUE, 1000);
    }

    @Override
    public int getRequestId() {
        return this.fRequestId;
    }

    @Override
    public int getIndex() {
        return this.fIndex;
    }

    @Override
    public ITmfDataRequest.ExecutionType getExecType() {
        return this.fExecType;
    }

    @Override
    public int getNbRequested() {
        return this.fNbRequested;
    }

    @Override
    public int getBlockSize() {
        return this.fBlockSize;
    }

    @Override
    public synchronized int getNbRead() {
        return this.fNbRead;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.fRequestRunning;
    }

    @Override
    public synchronized boolean isCompleted() {
        return this.fRequestCompleted;
    }

    @Override
    public synchronized boolean isFailed() {
        return this.fRequestFailed;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.fRequestCanceled;
    }

    @Override
    public Class<T> getDataType() {
        return this.fDataType;
    }

    protected void setIndex(int index) {
        this.fIndex = index;
    }

    @Override
    public void handleData(T data) {
        if (data != null) {
            ++this.fNbRead;
        }
    }

    @Override
    public void handleStarted() {
        if (Tracer.isRequestTraced()) {
            Tracer.traceRequest(this, "started");
        }
    }

    @Override
    public synchronized void handleCompleted() {
        if (this.fRequestFailed) {
            this.handleFailure();
        } else if (this.fRequestCanceled) {
            this.handleCancel();
        } else {
            this.handleSuccess();
        }
        if (Tracer.isRequestTraced()) {
            Tracer.traceRequest(this, "completed (" + this.fNbRead + " events read)");
        }
    }

    @Override
    public void handleSuccess() {
        if (Tracer.isRequestTraced()) {
            Tracer.traceRequest(this, "succeeded");
        }
    }

    @Override
    public void handleFailure() {
        if (Tracer.isRequestTraced()) {
            Tracer.traceRequest(this, "failed");
        }
    }

    @Override
    public void handleCancel() {
        if (Tracer.isRequestTraced()) {
            Tracer.traceRequest(this, "cancelled");
        }
    }

    public void waitForStart() throws InterruptedException {
        while (!this.fRequestRunning) {
            this.startedLatch.await();
        }
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
        while (!this.fRequestCompleted) {
            this.completedLatch.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            this.fRequestRunning = true;
        }
        this.handleStarted();
        this.startedLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            if (this.fRequestCompleted) {
                return;
            }
            this.fRequestRunning = false;
            this.fRequestCompleted = true;
        }
        try {
            this.handleCompleted();
        }
        finally {
            this.completedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail() {
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            this.fRequestFailed = true;
        }
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            this.fRequestCanceled = true;
        }
        this.done();
    }

    public int hashCode() {
        return this.getRequestId();
    }

    public boolean equals(Object other) {
        if (other instanceof TmfDataRequest) {
            TmfDataRequest request = (TmfDataRequest)other;
            return request.fDataType == this.fDataType && request.fIndex == this.fIndex && request.fNbRequested == this.fNbRequested;
        }
        return false;
    }

    public String toString() {
        return "[TmfDataRequest(" + this.fRequestId + "," + this.fDataType.getSimpleName() + "," + this.fIndex + "," + this.fNbRequested + "," + this.getBlockSize() + ")]";
    }
}

