/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;

public class TitanListener
extends BaseErrorListener {
    protected List<SyntacticErrorStorage> errorsStored = null;

    public TitanListener() {
        this.errorsStored = new ArrayList<SyntacticErrorStorage>();
    }

    public TitanListener(List<SyntacticErrorStorage> storage) {
        this.errorsStored = storage;
    }

    public void reset() {
        this.errorsStored.clear();
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        SyntacticErrorStorage errorStorage;
        if (offendingSymbol instanceof CommonToken) {
            CommonToken token = (CommonToken)offendingSymbol;
            errorStorage = new SyntacticErrorStorage(line, token.getStartIndex(), token.getStopIndex() + 1, msg, e);
        } else {
            errorStorage = new SyntacticErrorStorage(line, charPositionInLine, charPositionInLine + 1, msg, e);
        }
        this.errorsStored.add(errorStorage);
    }

    public List<SyntacticErrorStorage> getErrorsStored() {
        return this.errorsStored;
    }

    public boolean addAll(List<SyntacticErrorStorage> errorStore) {
        return this.errorsStored.addAll(errorStore);
    }
}

