/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.makefile;

public final class ModuleStruct
implements Comparable<ModuleStruct> {
    private String directory;
    private String originalLocation;
    private String fileName;
    private String moduleName;
    private boolean isRegular = true;

    public ModuleStruct(String directory, String originalLocation, String fileName, String moduleName) {
        this.setDirectory(directory);
        this.setOriginalLocation(originalLocation);
        this.setFileName(fileName);
        this.setModuleName(moduleName);
    }

    public StringBuilder fileName() {
        StringBuilder result = new StringBuilder();
        if (this.getDirectory() != null) {
            result.append(this.getDirectory()).append('/');
        }
        result.append(this.getFileName());
        return result;
    }

    public StringBuilder generatedName(boolean addDirectory, String suffix) {
        return this.generatedName(addDirectory, suffix, null);
    }

    public StringBuilder generatedName(boolean addDirectory, String suffix, String fileNameSuffix) {
        StringBuilder result = new StringBuilder();
        if (addDirectory && this.getDirectory() != null) {
            result.append(this.getDirectory()).append('/');
        }
        result.append(this.getModuleName().replace('-', '_'));
        if (fileNameSuffix != null) {
            result.append(fileNameSuffix);
        }
        if (suffix != null) {
            result.append('.').append(suffix);
        }
        return result;
    }

    public StringBuilder preprocessedName(boolean addDirectory) {
        StringBuilder result = new StringBuilder();
        if (addDirectory && this.getDirectory() != null) {
            result.append(this.getDirectory()).append('/');
        }
        result.append(this.getModuleName());
        result.append(".ttcn");
        return result;
    }

    @Override
    public int compareTo(ModuleStruct other) {
        return this.getFileName().compareTo(other.getFileName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ModuleStruct) {
            return this.getFileName().equals(((ModuleStruct)obj).getFileName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFileName().hashCode();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getOriginalLocation() {
        return this.originalLocation;
    }

    public void setOriginalLocation(String originalLocation) {
        this.originalLocation = originalLocation;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean isRegular() {
        return this.isRegular;
    }

    public void setRegular(boolean isRegular) {
        this.isRegular = isRegular;
    }
}

