/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.path;

import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;

public final class TitanURIUtil {
    private TitanURIUtil() {
    }

    public static boolean isPrefix(URI source, URI other) {
        if (source.getScheme() == null && other.getScheme() != null || !source.getScheme().equals(other.getScheme())) {
            return false;
        }
        Path sourcePath = new Path(source.getPath());
        Path otherPath = new Path(other.getPath());
        return sourcePath.isPrefixOf((IPath)otherPath);
    }

    public static URI removeLastSegment(URI original) {
        String lastSegment = URIUtil.lastSegment((URI)original);
        if (lastSegment == null) {
            return original;
        }
        String originalAsString = original.toString();
        String newAsString = originalAsString.substring(0, originalAsString.length() - lastSegment.length() - 1);
        return URI.create(newAsString);
    }
}

