/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Definition_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class TryCatch_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".try";
    private static final String FULLNAMEPART2 = ".catch";
    private static final String STATEMENT_NAME = "try-catch";
    private final StatementBlock tryBlock;
    private final Identifier exceptionIdentifier;
    private final StatementBlock catchBlock;
    private final StatementBlock catchSurroundingBlock;

    public TryCatch_Statement(StatementBlock tryBlock, Identifier exceptionIdentifier, StatementBlock catchBlock) {
        this.tryBlock = tryBlock;
        this.exceptionIdentifier = exceptionIdentifier;
        this.catchBlock = catchBlock;
        tryBlock.setFullNameParent(this);
        this.catchSurroundingBlock = new StatementBlock();
        this.catchSurroundingBlock.setFullNameParent(this);
        if (exceptionIdentifier == null) {
            return;
        }
        this.catchSurroundingBlock.setLocation(exceptionIdentifier.getLocation());
        CharString_Type strType = new CharString_Type();
        strType.setLocation(exceptionIdentifier.getLocation());
        Def_Var strDefinition = new Def_Var(exceptionIdentifier, strType, null, FormalParameter.parameterEvaluationType.NORMAL_EVAL);
        strDefinition.setLocation(exceptionIdentifier.getLocation());
        Definition_Statement strStatement = new Definition_Statement(strDefinition);
        strStatement.setLocation(exceptionIdentifier.getLocation());
        this.catchSurroundingBlock.addStatement(strStatement, true);
        catchBlock.setFullNameParent(this.catchSurroundingBlock);
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_TRY_CATCH;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.tryBlock == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.catchBlock == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.tryBlock.setMyScope(scope);
        this.catchSurroundingBlock.setMyScope(scope);
        this.catchBlock.setMyScope(this.catchSurroundingBlock);
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.tryBlock != null) {
            this.tryBlock.setCodeSection(codeSection);
        }
        if (this.catchSurroundingBlock != null) {
            this.catchSurroundingBlock.setCodeSection(codeSection);
        }
        if (this.catchBlock != null) {
            this.catchBlock.setCodeSection(codeSection);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        if (this.tryBlock != null) {
            this.tryBlock.setMyStatementBlock(statementBlock, index);
        }
        if (this.catchSurroundingBlock != null) {
            this.catchSurroundingBlock.setMyStatementBlock(statementBlock, index);
        }
        if (this.catchBlock != null) {
            this.catchBlock.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.tryBlock != null) {
            this.tryBlock.setMyDefinition(definition);
        }
        if (this.catchSurroundingBlock != null) {
            this.catchSurroundingBlock.setMyDefinition(definition);
        }
        if (this.catchBlock != null) {
            this.catchBlock.setMyDefinition(definition);
        }
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        if (this.tryBlock != null) {
            this.tryBlock.setMyAltguards(altGuards);
        }
        if (this.catchSurroundingBlock != null) {
            this.catchSurroundingBlock.setMyAltguards(altGuards);
        }
        if (this.catchBlock != null) {
            this.catchBlock.setMyAltguards(altGuards);
        }
    }

    @Override
    protected void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        if (this.tryBlock != null) {
            this.tryBlock.setMyLaicStmt(pAltGuards, pLoopStmt);
        }
        if (this.catchBlock != null) {
            this.catchBlock.setMyLaicStmt(pAltGuards, pLoopStmt);
        }
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        StatementBlock.ReturnStatus_type catchReturn;
        StatementBlock.ReturnStatus_type tryReturn = this.tryBlock.hasReturn(timestamp);
        if (tryReturn.equals((Object)(catchReturn = this.catchBlock.hasReturn(timestamp)))) {
            return tryReturn;
        }
        return StatementBlock.ReturnStatus_type.RS_MAYBE;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.tryBlock.check(timestamp);
        this.catchSurroundingBlock.check(timestamp);
        this.catchBlock.check(timestamp);
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.tryBlock != null) {
            this.tryBlock.updateSyntax(reparser, false);
            reparser.updateLocation(this.tryBlock.getLocation());
        }
        if (this.exceptionIdentifier != null) {
            reparser.updateLocation(this.exceptionIdentifier.getLocation());
        }
        if (this.catchBlock != null) {
            this.catchBlock.updateSyntax(reparser, false);
            reparser.updateLocation(this.catchBlock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.tryBlock != null) {
            this.tryBlock.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.catchSurroundingBlock != null) {
            this.catchSurroundingBlock.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.catchBlock != null) {
            this.catchBlock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.tryBlock != null && !this.tryBlock.accept(v)) {
            return false;
        }
        if (this.catchSurroundingBlock != null && !this.catchSurroundingBlock.accept(v)) {
            return false;
        }
        return this.catchBlock == null || this.catchBlock.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        aData.addCommonLibraryImport("TTCN_Runtime");
        aData.addCommonLibraryImport("TtcnError");
        String tempId = aData.getTemporaryVariableName();
        source.append("try {\n");
        source.append("TTCN_Runtime.increase_try_catch_counter();\n");
        this.tryBlock.generateCode(aData, source);
        source.append(MessageFormat.format("'}' catch(final TtcnError {0}) '{'\n", tempId));
        this.catchSurroundingBlock.generateCode(aData, source);
        source.append(MessageFormat.format("{0}.operator_assign({1}.get_message());\n", this.exceptionIdentifier.getName(), tempId));
        this.catchBlock.generateCode(aData, source);
        source.append("}\n");
        source.append("finally {\n");
        source.append("TTCN_Runtime.decrease_try_catch_counter();\n");
        source.append("}\n");
    }
}

