/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Types;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_AbsFunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Constructor;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.statements.Assignment_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.ClassTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.UniversalCharstring_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Class_Type
extends Type
implements ITypeWithComponents {
    private static final String ONLYONEMODIFIER = "A class cannot have more than one of the @final, @abstract and @trait modifiers";
    private static final String EXTERNALABSTRACT = "External classes cannot be abstract";
    private static final String CLASSEXPECTED = "Class type expected instead of `{0}''";
    private static final String TRAITEXTENDTRAIT = "A trait class cannot extend a non-trait class";
    private static final String CANNOTEXTENDMORETHANONE = "A class cannot extend more than one non-trait class";
    private static final String PREVEXTENDED = "Previous extended non-trait class is here";
    private static final String BASECANNOTBEFINAL = "The superclass cannot be final";
    private static final String EXTERNALEXTENDINTERNAL = "An external class cannot extend an internal class";
    private static final String DUPLICATECLASSTYPE = "Duplicate class type in list of classes being extended";
    private static final String RUNSONINCOMPATIBLE = "The `runs on'' component type of the subclass, `{0}'', is not compatible with the `runs on'' component type of the superclass, `{1}''";
    private static final String MTCINCOMPATIBLE = "The `mtc'' component type of the subclass, `{0}'', is not compatible with the `mtc'' component type of the superclass, `{1}''";
    private static final String SYSTEMINCOMPATIBLE = "The `system'' component type of the subclass, `{0}'', is not compatible with the `system'' component type of the superclass, `{1}''";
    private static final String SUBCLASSHASNORUNSON = "Supertrait `{0}'' has a `runs on'' component type, but the subclass and its superclass does not";
    private static final String SUBCLASSHASNOMTC = "Supertrait `{0}'' has an `mtc'' component type, but the subclass and its superclass does not";
    private static final String SUBCLASSHASNOSYSTEM = "Supertrait `{0}'' has a `system'' component type, but the subclass and its superclass does not";
    private static final String RUNSONINCOMPATIBLETRAIT = "The `runs on'' component type of the subclass (`{0}'') is not compatible with the `runs on'' component type of supertrait `{1}'' (`{2}'')";
    private static final String MTCINCOMPATIBLETRAIT = "The `mtc'' component type of the subclass (`{0}'') is not compatible with the `mtc'' component type of supertrait `{1}'' (`{2}'')";
    private static final String SYSTEMINCOMPATIBLETRAIT = "The `system'' component type of the subclass (`{0}'') is not compatible with the `system'' component type of supertrait `{1}'' (`{2}'')";
    private static final String MEMBERCANNOTBEPUBLIC = "Class members cannot be public";
    private static final String SHADOWSRUNSON = "`{0}'' shadows a definition in runs-on component type `{1}''";
    private static final String SHADOWSMTC = "`{0}'' shadows a definition in mtc component type `{1}''";
    private static final String SHADOWSSYSTEM = "`{0}'' shadows a definition in system component type `{1}''";
    private static final String DIFFERSFROMOBJECTMETHOD = "The prototype of method `{0}'' is not identical to that of the method inherited from the `object'' class";
    private static final String SHADOWSOBJECTMETHOD = "`{0}'' shadows a method inherited from the `object'' class";
    private static final String PARAMNAMEDIFFERS = "One or more parameter names differ from previous definition";
    private static final String PROTOTYPENOTIDENTICAL = "The prototype of method `{0}'' is not identical to that of inherited method `{1}''";
    private static final String PROTOTYPESDIFFER = "The prototypes of methods `{0}'' inherited from classes `{1}'' and `{2}'' are not identical";
    private static final String CANNOTOVERRIDEFINAL = "Cannot override final method `{0}''";
    private static final String PUBLICCANBEOVERRIDDEN = "Public methods can be only overridden by public methods `{0}''";
    private static final String PROTECTEDCANBEOVERRIDDEN = "Protected methods can be only overridden by public or protected methods `{0}''";
    private static final String SHADOWSINHERITEDMEMBER = "`{0}'' shadows inherited member `{1}''";
    private static final String SHADOWSINHERITED2 = "`{0}'' shadows inherited {1} `{2}''";
    private static final String TRAITNOCONSTRUCTOR = "Trait class type `{0}'' cannot have a constructor";
    private static final String TRAITCANNOTHAVEFINALLY = "Trait class type `{0}'' cannot have a destructor";
    private static final String EXTERNALCANNOTCONTAIN = "An external class cannot contain a {0}";
    private static final String EXTERNALCANNOTHAVEFINALLY = "An external class cannot have a destructor";
    private static final String MISSINGABSIMPLEMENTATION = "Missing implementation of abstract method `{0}''";
    private static final String UNKNOWNFIELD = "Unknown field reference";
    private static final String PRIVATEINACCESSIBLE = "Private member is inaccessible due to its protection level";
    private boolean isBuiltIn;
    private final boolean isAbstract;
    private final boolean isFinal;
    private final boolean isTrait;
    private final boolean isExternal;
    private final Location modifierLocation;
    private final StatementBlock finallyBlock;
    private final Reference runsOnRef;
    private final Reference mtcRef;
    private final Reference systemRef;
    private Component_Type runsOnType;
    private Component_Type mtcType;
    private Component_Type systemType;
    private ClassTypeBody body;
    private Identifier classId;
    private Types baseTraits;
    private Type baseType;
    private Definitions members;
    private Class_Type baseClass;
    private Def_Constructor constructor;
    private Map<FormalParameter, String> defaultParameterList;
    private Map<String, Def_AbsFunction> abstractFunctions = new HashMap<String, Def_AbsFunction>();
    private boolean defaultConstructor;

    public Class_Type(Identifier identifier, boolean isAbstract, boolean isFinal, boolean isTrait, boolean isExternal, Location modifierLocation, Reference runsOnRef, Reference mtcRef, Reference systemRef, Definitions members, Types baseTraits, StatementBlock finallyBlock) {
        this.classId = identifier;
        this.isAbstract = isAbstract;
        this.isFinal = isFinal;
        this.isTrait = isTrait;
        this.isExternal = isExternal;
        this.modifierLocation = modifierLocation;
        this.finallyBlock = finallyBlock;
        this.runsOnRef = runsOnRef;
        this.mtcRef = mtcRef;
        this.systemRef = systemRef;
        this.members = members != null ? members : new Definitions();
        this.baseTraits = baseTraits;
        if (runsOnRef != null) {
            runsOnRef.setFullNameParent(this);
        }
        if (mtcRef != null) {
            mtcRef.setFullNameParent(this);
        }
        if (systemRef != null) {
            systemRef.setFullNameParent(this);
        }
        if (baseTraits != null) {
            baseTraits.setFullNameParent(this);
        }
        if (finallyBlock != null) {
            finallyBlock.setFullNameParent(this);
            finallyBlock.setOwnerIsFinally();
        }
        this.body = new ClassTypeBody(this);
        this.body.setFullNameParent(this);
    }

    public Class_Type() {
        this(null, true, false, false, false, null, null, null, null, null, null, null);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_CLASS;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.isBuiltIn) {
            return;
        }
        this.body.setMyScope(scope);
        if (this.baseType != null) {
            this.baseType.setMyScope(scope);
        }
        if (this.baseTraits != null) {
            this.baseTraits.setMyScope(scope);
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.setMyScope(scope);
        }
        if (this.mtcRef != null) {
            this.mtcRef.setMyScope(scope);
        }
        if (this.systemRef != null) {
            this.systemRef.setMyScope(scope);
        }
        if (this.members != null) {
            this.members.setParentScope(this.body);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.setParentScope(scope);
        }
    }

    @Override
    public Identifier getIdentifier() {
        return this.classId;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        Assignment assignment = this.getLocalAssignmentByID(timestamp, subreference.getId());
        if (assignment == null) {
            if (subreference.getReferenceType() == ISubReference.Subreference_type.parameterisedSubReference) {
                if (subreference.getId().getName().equals("toString")) {
                    Identifier id = new Identifier(Identifier.Identifier_type.ID_NAME, "toString");
                    Def_Function function = new Def_Function(id, new FormalParameterList(new ArrayList<FormalParameter>()), new UniversalCharstring_Type());
                    function.setMyScope(reference.getMyScope());
                    function.setLocation(NULL_Location.INSTANCE);
                    return function.getType(timestamp);
                }
                if (subreference.getId().getName().equals("equals")) {
                    Identifier id = new Identifier(Identifier.Identifier_type.ID_NAME, "equals");
                    Identifier objid = new Identifier(Identifier.Identifier_type.ID_NAME, "obj");
                    ArrayList<FormalParameter> list = new ArrayList<FormalParameter>();
                    list.add(new FormalParameter(null, Assignment.Assignment_type.A_PAR_VAL_IN, new Class_Type(), objid, null, null));
                    FormalParameterList paramList = new FormalParameterList(list);
                    Def_Function function = new Def_Function(id, paramList, new Boolean_Type());
                    function.setMyScope(reference.getMyScope());
                    function.setLocation(NULL_Location.INSTANCE);
                    return function.getType(timestamp);
                }
            }
            subreference.getLocation().reportSemanticError(UNKNOWNFIELD);
            return null;
        }
        Definition def = (Definition)assignment;
        if (def.getVisibilityModifier() == VisibilityModifier.Private) {
            subreference.getLocation().reportSemanticError(PRIVATEINACCESSIBLE);
            return null;
        }
        if (assignment instanceof Def_Function) {
            FormalParameterList fpl = ((Def_Function)assignment).getFormalParameterList();
            ISubReference sr = reference.getSubreferences().get(actualSubReference);
            if (sr instanceof ParameterisedSubReference) {
                ((ParameterisedSubReference)sr).checkParameters(timestamp, fpl);
            }
        }
        if (subreferences.size() == actualSubReference + 1) {
            return assignment.getType(timestamp);
        }
        Type type = (Type)assignment.getType(timestamp);
        return (Type)type.getFieldType(timestamp, reference, actualSubReference + 1, expectedIndex, interruptIfOptional);
    }

    public Reference getRunsOnRef() {
        return this.runsOnRef;
    }

    public Reference getMtcRef() {
        return this.mtcRef;
    }

    public Reference getSystemRef() {
        return this.systemRef;
    }

    public int getNofAbstractFunctions() {
        return this.abstractFunctions.size();
    }

    public synchronized void addAbstractFunction(String key, Def_AbsFunction value) {
        this.abstractFunctions.put(key, value);
    }

    public Map<String, Def_AbsFunction> getAbstractFunctions() {
        return this.abstractFunctions;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Definition member;
        Type baseTrait;
        Definition ass;
        int i;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.isBuiltIn) {
            return;
        }
        if (this.isFinal && this.isAbstract || this.isFinal && this.isTrait || this.isAbstract && this.isTrait) {
            this.modifierLocation.reportSemanticError(ONLYONEMODIFIER);
        }
        if (this.isExternal && this.isAbstract) {
            this.modifierLocation.reportSemanticError(EXTERNALABSTRACT);
        }
        if (this.baseTraits != null) {
            for (i = 0; i < this.baseTraits.getNofTypes(); ++i) {
                Type t = this.baseTraits.getType(i);
                if (t == null) continue;
                t.check(timestamp);
                if (!(t.getTypeRefdLast(timestamp) instanceof Class_Type)) {
                    if (!t.getIsErroneous(timestamp)) {
                        t.getLocation().reportSemanticError(MessageFormat.format(CLASSEXPECTED, t.getTypename()));
                    }
                    this.baseTraits.extractTypeByIndex(i);
                    continue;
                }
                Class_Type tClass = t.getTypeRefdLast(timestamp).getClassType();
                if (!tClass.isTrait) {
                    if (this.isTrait) {
                        t.getLocation().reportSemanticError(TRAITEXTENDTRAIT);
                    } else if (this.baseClass != null) {
                        t.getLocation().reportSemanticError(CANNOTEXTENDMORETHANONE);
                    } else {
                        this.baseTraits.extractTypeByIndex(i);
                        this.baseType = t;
                        this.baseClass = tClass;
                        if (this.baseClass.isFinal) {
                            this.baseClass.getModifierLocation().reportSemanticError(BASECANNOTBEFINAL);
                        }
                        if (this.isExternal && !this.baseClass.isExternal) {
                            this.baseClass.getLocation().reportSemanticError(EXTERNALEXTENDINTERNAL);
                        }
                    }
                }
                for (int j = 0; j < i; ++j) {
                    Type t2 = this.baseTraits.getType(j);
                    if (t2 == null || !t2.getTypename().equals(t.getTypename())) continue;
                    t.getLocation().reportSemanticError(DUPLICATECLASSTYPE);
                }
            }
        }
        if (this.baseClass != null && this.baseClass.isBuiltIn) {
            this.baseClass = null;
            this.baseType = null;
        }
        if (this.runsOnRef != null) {
            Component_Type baseRunsOnType;
            this.runsOnType = this.runsOnRef.chkComponentypeReference(timestamp);
            if (this.baseClass != null && (baseRunsOnType = this.baseClass.getRunsOnType(timestamp)) != null && !baseRunsOnType.isCompatible(timestamp, this.runsOnType, null, null, null)) {
                this.runsOnRef.getLocation().reportSemanticError(MessageFormat.format(RUNSONINCOMPATIBLE, this.runsOnType.getTypename(), baseRunsOnType.getTypename()));
            }
        } else if (this.baseClass != null) {
            this.runsOnType = this.baseClass.getRunsOnType(timestamp);
        }
        if (this.mtcRef != null) {
            Component_Type baseMtcType;
            this.mtcType = this.mtcRef.chkComponentypeReference(timestamp);
            if (this.baseClass != null && (baseMtcType = this.baseClass.getMtcType(timestamp)) != null && !baseMtcType.isCompatible(timestamp, this.mtcType, null, null, null)) {
                this.mtcRef.getLocation().reportSemanticError(MessageFormat.format(MTCINCOMPATIBLE, this.mtcType.getTypename(), baseMtcType.getTypename()));
            }
        } else if (this.baseClass != null) {
            this.mtcType = this.baseClass.getMtcType(timestamp);
        }
        if (this.systemRef != null) {
            Component_Type baseSystemType;
            this.systemType = this.systemRef.chkComponentypeReference(timestamp);
            if (this.baseClass != null && (baseSystemType = this.baseClass.getSystemType(timestamp)) != null && !baseSystemType.isCompatible(timestamp, this.systemType, null, null, null)) {
                this.systemRef.getLocation().reportSemanticError(MessageFormat.format(SYSTEMINCOMPATIBLE, this.systemType.getTypename(), baseSystemType.getTypename()));
            }
        } else if (this.baseClass != null) {
            this.systemType = this.baseClass.getSystemType(timestamp);
        }
        if (this.baseTraits != null) {
            for (i = 0; i < this.baseTraits.getNofTypes(); ++i) {
                Component_Type baseSystemType;
                Component_Type baseMtcType;
                Type baseTrait2 = this.baseTraits.getType(i);
                if (baseTrait2 == null) continue;
                Class_Type baseTraitClass = (Class_Type)baseTrait2.getTypeRefdLast(timestamp);
                Component_Type baseRunsOnType = baseTraitClass.getRunsOnType(timestamp);
                if (baseRunsOnType != null) {
                    if (this.runsOnType == null) {
                        this.getLocation().reportSemanticError(MessageFormat.format(SUBCLASSHASNORUNSON, baseTraitClass.getFullName()));
                    } else if (!baseRunsOnType.isCompatible(timestamp, this.runsOnType, null, null, null)) {
                        this.runsOnRef.getLocation().reportSemanticError(MessageFormat.format(RUNSONINCOMPATIBLETRAIT, this.runsOnType.getTypename(), baseTraitClass.getIdentifier().getDisplayName(), baseRunsOnType.getTypename()));
                    }
                }
                if ((baseMtcType = baseTraitClass.getMtcType(timestamp)) != null) {
                    if (this.mtcType == null) {
                        this.getLocation().reportSemanticError(MessageFormat.format(SUBCLASSHASNOMTC, baseTraitClass.getFullName()));
                    } else if (!baseMtcType.isCompatible(timestamp, this.mtcType, null, null, null)) {
                        this.mtcRef.getLocation().reportSemanticError(MessageFormat.format(MTCINCOMPATIBLETRAIT, this.mtcType.getTypename(), baseTraitClass.getIdentifier().getDisplayName(), baseMtcType.getTypename()));
                    }
                }
                if ((baseSystemType = baseTraitClass.getSystemType(timestamp)) == null) continue;
                if (this.systemType == null) {
                    this.getLocation().reportSemanticError(MessageFormat.format(SUBCLASSHASNOSYSTEM, baseTraitClass.getFullName()));
                    continue;
                }
                if (baseSystemType.isCompatible(timestamp, this.systemType, null, null, null)) continue;
                this.systemRef.getLocation().reportSemanticError(MessageFormat.format(SYSTEMINCOMPATIBLETRAIT, this.systemType.getTypename(), baseTraitClass.getIdentifier().getDisplayName(), baseSystemType.getTypename()));
            }
        }
        for (i = 0; i < this.members.getNofAssignments(); ++i) {
            ass = this.members.getAssignmentByIndex(i);
            if (ass.getAssignmentType() != Assignment.Assignment_type.A_CONSTRUCTOR) continue;
            this.constructor = (Def_Constructor)ass;
        }
        this.members.check(timestamp);
        block33: for (i = 0; i < this.members.getNofAssignments(); ++i) {
            ass = this.members.getAssignmentByIndex(i);
            if (ass == null) continue;
            switch (ass.getAssignmentType()) {
                case A_CONST: 
                case A_VAR: 
                case A_TEMPLATE: 
                case A_VAR_TEMPLATE: {
                    if (ass.isProperty() || ass.getVisibility() != VisibilityModifier.Public) continue block33;
                    ass.getLocation().reportSemanticError(MEMBERCANNOTBEPUBLIC);
                    continue block33;
                }
            }
        }
        if (this.runsOnType != null | this.mtcType != null | this.systemType != null) {
            for (i = 0; i < this.members.getNofAssignments(); ++i) {
                Definition localDef = this.members.getAssignmentByIndex(i);
                Identifier localId = localDef.getIdentifier();
                if (this.runsOnType != null && this.runsOnType.getComponentBody().hasLocalAssignmentWithId(localId)) {
                    localDef.getLocation().reportSemanticError(MessageFormat.format(SHADOWSRUNSON, localDef.getDescription(), this.runsOnType.getTypename()));
                }
                if (this.mtcType != null && this.mtcType.getComponentBody().hasLocalAssignmentWithId(localId)) {
                    localDef.getLocation().reportSemanticError(MessageFormat.format(SHADOWSMTC, localDef.getDescription(), this.mtcType.getTypename()));
                }
                if (this.systemType == null || !this.systemType.getComponentBody().hasLocalAssignmentWithId(localId)) continue;
                localDef.getLocation().reportSemanticError(MessageFormat.format(SHADOWSSYSTEM, localDef.getDescription(), this.systemType.getTypename()));
            }
        }
        boolean nameClash = false;
        if (this.baseClass != null) {
            nameClash = this.compareMembers(this, this.baseClass, null, timestamp);
        }
        if (this.baseTraits != null) {
            for (int i2 = 0; i2 < this.baseTraits.getNofTypes(); ++i2) {
                baseTrait = this.baseTraits.getType(i2);
                if (baseTrait == null) continue;
                Class_Type baseTraitClass = baseTrait.getTypeRefdLast(timestamp).getClassType();
                nameClash |= this.compareMembers(this, baseTraitClass, null, timestamp);
                if (this.baseClass != null) {
                    nameClash |= this.compareMembers(this.baseClass, baseTraitClass, this.getLocation(), timestamp);
                }
                for (int j = 0; j < i2; ++j) {
                    Type baseTrait2 = this.baseTraits.getType(j);
                    if (baseTrait2 == null) continue;
                    Class_Type baseTraitClass2 = baseTrait2.getTypeRefdLast(timestamp).getClassType();
                    nameClash |= this.compareMembers(baseTraitClass, baseTraitClass2, this.getLocation(), timestamp);
                }
            }
        }
        block37: for (int i3 = 0; i3 < this.members.getNofAssignments(); ++i3) {
            Identifier id;
            FormalParameterList fpl;
            Definition def = this.members.getAssignmentByIndex(i3);
            if (!(def instanceof IParameterisedAssignment) || (fpl = Class_Type.getObjectMethodFormalParameterList((id = def.getIdentifier()).getName())) == null) continue;
            FormalParameterList.IsIdenticalResult identical = FormalParameterList.IsIdenticalResult.RES_DIFFERS;
            FormalParameterList fpl2 = ((IParameterisedAssignment)((Object)def)).getFormalParameterList();
            if (fpl2 != null) {
                identical = fpl.isIdentical(timestamp, fpl2);
            } else if (fpl.getNofParameters() == 0) {
                identical = FormalParameterList.IsIdenticalResult.RES_IDENTICAL;
            }
            switch (def.getAssignmentType()) {
                case A_FUNCTION_RVAL: 
                case A_EXT_FUNCTION_RVAL: {
                    if (def.getVisibility() == VisibilityModifier.Public && identical != FormalParameterList.IsIdenticalResult.RES_DIFFERS && !(def instanceof Def_AbsFunction) && def.getType(timestamp).isIdentical(timestamp, Class_Type.getObjectMethodReturnType(id.getName()))) {
                        if (identical != FormalParameterList.IsIdenticalResult.RES_NAME_DIFFERS) continue block37;
                        fpl2.getLocation().reportSemanticWarning(PARAMNAMEDIFFERS);
                        continue block37;
                    }
                }
                case A_FUNCTION: 
                case A_FUNCTION_RTEMP: 
                case A_EXT_FUNCTION: 
                case A_EXT_FUNCTION_RTEMP: {
                    ((Def_FunctionBase)def).getSignatureLocation().reportSemanticError(MessageFormat.format(DIFFERSFROMOBJECTMETHOD, def.getDescription()));
                    continue block37;
                }
                default: {
                    ((Def_FunctionBase)def).getSignatureLocation().reportSemanticError(MessageFormat.format(SHADOWSOBJECTMETHOD, def.getDescription()));
                    nameClash = true;
                }
            }
        }
        if (this.constructor != null && this.isTrait) {
            this.constructor.getLocation().reportSemanticError(MessageFormat.format(TRAITNOCONSTRUCTOR, this.getTypename()));
        }
        if (this.constructor == null && !nameClash && !this.isTrait) {
            Def_Constructor baseConstructor;
            Reference baseCall = null;
            FormalParameterList fpl = null;
            if (!this.isExternal && this.baseClass != null && (baseConstructor = this.baseClass.getConstructor(timestamp)) != null) {
                FormalParameterList baseFpl = baseConstructor.getFormalParameterList();
                fpl = new FormalParameterList(baseFpl);
                ParsedActualParameters parsedApList = new ParsedActualParameters();
                for (int i4 = 0; i4 < baseFpl.getNofParameters(); ++i4) {
                    Reference ref = new Reference(null, baseFpl.getParameterByIndex(i4).getIdentifier().newInstance());
                    Referenced_Value val = new Referenced_Value(ref);
                    SpecificValue_Template temp = new SpecificValue_Template(val);
                    TemplateInstance instance = new TemplateInstance(null, null, temp);
                    parsedApList.addUnnamedParameter(instance);
                    FormalParameter fp = fpl.getParameterByIndex(i4);
                    if (!fp.hasDefaultValue()) continue;
                    this.addDefaultParameter(fp);
                }
                ParameterisedSubReference paramSubRef = new ParameterisedSubReference(this.classId, parsedApList);
                paramSubRef.setLocation(NULL_Location.INSTANCE);
                ArrayList<ISubReference> subrefs = new ArrayList<ISubReference>();
                subrefs.add(paramSubRef);
                baseCall = new Reference(this.baseClass.getMyScope().getParentScope().getModuleScope().getIdentifier().newInstance(), subrefs);
            }
            if (fpl == null) {
                fpl = new FormalParameterList(new ArrayList<FormalParameter>());
            }
            StatementBlock block = null;
            if (!this.isExternal) {
                block = new StatementBlock();
                block39: for (int i5 = 0; i5 < this.members.getNofAssignments(); ++i5) {
                    Definition member2 = this.members.getAssignmentByIndex(i5);
                    boolean isTemplate = false;
                    TemplateInstance defVal = null;
                    switch (member2.getAssignmentType()) {
                        case A_CONST: {
                            if (((Def_Const)member2).getValue() == null) break;
                            continue block39;
                        }
                        case A_TEMPLATE: {
                            if (((Def_Template)member2).getTemplate(timestamp) != null) continue block39;
                            isTemplate = true;
                            break;
                        }
                        case A_VAR: {
                            if (((Def_Var)member2).getInitialValue() == null) break;
                            Def_Var varMember = (Def_Var)member2;
                            defVal = new TemplateInstance(null, null, new SpecificValue_Template(varMember.stealValue()));
                            break;
                        }
                        case A_VAR_TEMPLATE: {
                            isTemplate = true;
                            if (((Def_Var_Template)member2).getInitialValue() == null) break;
                            Def_Var_Template varTemplateMember = (Def_Var_Template)member2;
                            defVal = new TemplateInstance(null, null, varTemplateMember.stealValue());
                            break;
                        }
                        default: {
                            continue block39;
                        }
                    }
                    Identifier id = member2.getIdentifier().newInstance();
                    FormalParameter fp = new FormalParameter(TemplateRestriction.Restriction_type.TR_NONE, isTemplate ? Assignment.Assignment_type.A_PAR_TEMP_IN : Assignment.Assignment_type.A_PAR_VAL_IN, (Type)member2.getType(timestamp), id, defVal, FormalParameter.parameterEvaluationType.NORMAL_EVAL);
                    fpl.addFormalparameter(fp);
                    Identifier id1 = id.newInstance();
                    Reference refLeft = new Reference(new Identifier(Identifier.Identifier_type.ID_TTCN, id1.getName()), Reference.Ref_Type.REF_THIS);
                    FieldSubReference subref = new FieldSubReference(id1);
                    refLeft.addSubReference(subref);
                    Reference refRight = new Reference(new Identifier(Identifier.Identifier_type.ID_TTCN, id.newInstance().getName()));
                    Referenced_Value refdVal = new Referenced_Value(refRight);
                    SpecificValue_Template valTemplate = new SpecificValue_Template(refdVal);
                    Assignment_Statement assignment = new Assignment_Statement(refLeft, valTemplate);
                    block.addStatement(assignment);
                }
            }
            Identifier id = new Identifier(Identifier.Identifier_type.ID_TTCN, "create");
            id.setLocation(NULL_Location.INSTANCE);
            this.constructor = new Def_Constructor(id, fpl, baseCall, block);
            this.constructor.setLocation(NULL_Location.INSTANCE);
            this.constructor.setSignatureLocation(NULL_Location.INSTANCE);
            this.constructor.setMyScope(this.getClassTypeBody());
            this.defaultConstructor = true;
            this.constructor.check(timestamp);
        }
        if (!(this.constructor == null || this.defaultConstructor || nameClash || this.isTrait)) {
            for (int i6 = 0; i6 < this.members.getNofAssignments(); ++i6) {
                member = this.members.getAssignmentByIndex(i6);
                boolean needsInitCheck = false;
                boolean isTemplate = false;
                switch (member.getAssignmentType()) {
                    case A_CONST: {
                        needsInitCheck = ((Def_Const)member).getValue() == null;
                        break;
                    }
                    case A_TEMPLATE: {
                        needsInitCheck = ((Def_Template)member).getTemplate(timestamp) == null;
                        isTemplate = true;
                        break;
                    }
                }
                if (!needsInitCheck) continue;
                this.constructor.addUninitializedMember(member.getIdentifier(), isTemplate);
            }
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.check(timestamp);
            if (this.isTrait) {
                this.finallyBlock.getLocation().reportSemanticError(MessageFormat.format(TRAITCANNOTHAVEFINALLY, this.getTypename()));
            }
        }
        if (this.isExternal) {
            block41: for (int i7 = 0; i7 < this.members.getNofAssignments(); ++i7) {
                member = this.members.getAssignmentByIndex(i7);
                switch (member.getAssignmentType()) {
                    case A_EXT_FUNCTION_RVAL: 
                    case A_EXT_FUNCTION: 
                    case A_EXT_FUNCTION_RTEMP: 
                    case A_CONSTRUCTOR: {
                        continue block41;
                    }
                    default: {
                        member.getLocation().reportSemanticError(MessageFormat.format(EXTERNALCANNOTCONTAIN, member.getAssignmentName()));
                    }
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.getLocation().reportSemanticError(MessageFormat.format(EXTERNALCANNOTHAVEFINALLY, this.getTypename()));
            }
        }
        if (this.isAbstract || this.isTrait) {
            if (this.baseClass != null && this.baseClass.isAbstract) {
                for (Map.Entry<String, Def_AbsFunction> absFunc : this.baseClass.getAbstractFunctions().entrySet()) {
                    this.addAbstractFunction(absFunc.getKey(), absFunc.getValue());
                }
            }
            if (this.baseTraits != null) {
                for (int i8 = 0; i8 < this.baseTraits.getNofTypes(); ++i8) {
                    baseTrait = this.baseTraits.getType(i8);
                    if (baseTrait == null) continue;
                    Class_Type baseTraitClass = baseTrait.getTypeRefdLast(timestamp).getClassType();
                    for (Map.Entry<String, Def_AbsFunction> traitAbs : baseTraitClass.getAbstractFunctions().entrySet()) {
                        if (this.abstractFunctions.containsKey(traitAbs.getKey())) continue;
                        this.addAbstractFunction(traitAbs.getKey(), traitAbs.getValue());
                    }
                }
            }
            block45: for (int i9 = 0; i9 < this.members.getNofAssignments(); ++i9) {
                member = this.members.getAssignmentByIndex(i9);
                switch (member.getAssignmentType()) {
                    case A_FUNCTION_RVAL: 
                    case A_FUNCTION: 
                    case A_FUNCTION_RTEMP: {
                        String defName;
                        Def_AbsFunction defAbsFunc;
                        if (!(member instanceof Def_AbsFunction) || (defAbsFunc = (Def_AbsFunction)member) == null || this.abstractFunctions.containsKey(defName = defAbsFunc.getIdentifier().getName())) continue block45;
                        this.addAbstractFunction(defName, defAbsFunc);
                        continue block45;
                    }
                }
            }
        }
        if (!this.isAbstract && !this.isTrait) {
            if (this.baseClass != null && this.baseClass.isAbstract) {
                for (Map.Entry<String, Def_AbsFunction> absFuncs : this.baseClass.getAbstractFunctions().entrySet()) {
                    Def_AbsFunction defAbsFunc = absFuncs.getValue();
                    Assignment ass2 = this.getLocalAssignmentByID(timestamp, defAbsFunc.getIdentifier());
                    switch (ass2.getAssignmentType()) {
                        case A_FUNCTION_RVAL: 
                        case A_FUNCTION: 
                        case A_FUNCTION_RTEMP: {
                            if (!(ass2 instanceof Def_AbsFunction)) break;
                            this.getLocation().reportSemanticError(MessageFormat.format(MISSINGABSIMPLEMENTATION, defAbsFunc.getFullName()));
                            break;
                        }
                    }
                }
            }
            if (this.baseTraits != null) {
                for (int i10 = 0; i10 < this.baseTraits.getNofTypes(); ++i10) {
                    baseTrait = this.baseTraits.getType(i10);
                    if (baseTrait == null) continue;
                    Class_Type baseTraitClass = baseTrait.getTypeRefdLast(timestamp).getClassType();
                    for (Map.Entry<String, Def_AbsFunction> absFuncs : baseTraitClass.getAbstractFunctions().entrySet()) {
                        Assignment ass3 = this.getLocalAssignmentByID(timestamp, absFuncs.getValue().getIdentifier());
                        switch (ass3.getAssignmentType()) {
                            case A_FUNCTION_RVAL: 
                            case A_FUNCTION: 
                            case A_FUNCTION_RTEMP: {
                                if (!(ass3 instanceof Def_AbsFunction)) break;
                                this.getLocation().reportSemanticError(MessageFormat.format(MISSINGABSIMPLEMENTATION, absFuncs.getValue().getFullName()));
                                break;
                            }
                        }
                    }
                }
            }
        }
        this.lastTimeChecked = timestamp;
    }

    private void addDefaultParameter(FormalParameter fp) {
        String name = this.classId.getName() + "_defpar_type_" + this.defaultParameterList.size();
        this.defaultParameterList.put(fp, name);
    }

    private boolean compareMembers(Class_Type c1, Class_Type c2, Location subclassLoc, CompilationTimeStamp timestamp) {
        int i;
        if (subclassLoc != null && (c1.isParentClass(timestamp, c2) || c2.isParentClass(timestamp, c1))) {
            return false;
        }
        boolean nameClash = false;
        block6: for (i = 0; i < c1.members.getNofAssignments(); ++i) {
            Identifier id1;
            Definition def1 = c1.members.getAssignmentByIndex(i);
            if (def1.getAssignmentType() == Assignment.Assignment_type.A_CONSTRUCTOR || !c2.hasLocalAssignemtWithID(timestamp, id1 = def1.getIdentifier())) continue;
            Assignment def2 = c2.getLocalAssignmentByID(timestamp, id1);
            Class_Type def2Class = def2.getMyScope().getScopeClass();
            if (subclassLoc != null && def2Class != c2 && def2Class != c1 && c1.isParentClass(timestamp, def2Class)) continue;
            switch (def1.getAssignmentType()) {
                case A_FUNCTION_RVAL: 
                case A_EXT_FUNCTION_RVAL: 
                case A_FUNCTION: 
                case A_FUNCTION_RTEMP: 
                case A_EXT_FUNCTION: 
                case A_EXT_FUNCTION_RTEMP: {
                    switch (def2.getAssignmentType()) {
                        case A_FUNCTION_RVAL: 
                        case A_EXT_FUNCTION_RVAL: 
                        case A_FUNCTION: 
                        case A_FUNCTION_RTEMP: 
                        case A_EXT_FUNCTION: 
                        case A_EXT_FUNCTION_RTEMP: {
                            Def_FunctionBase func1 = (Def_FunctionBase)def1;
                            Def_FunctionBase func2 = (Def_FunctionBase)def2;
                            boolean func1IsAbstract = def1 instanceof Def_AbsFunction;
                            boolean func2IsAbstract = def2 instanceof Def_AbsFunction;
                            FormalParameterList.IsIdenticalResult identical = func1.isIdentical(timestamp, func2);
                            if (identical == FormalParameterList.IsIdenticalResult.RES_NAME_DIFFERS) {
                                def1.getLocation().reportSemanticWarning(PARAMNAMEDIFFERS);
                            }
                            if (def2.getVisibility() != VisibilityModifier.Private && (identical == FormalParameterList.IsIdenticalResult.RES_DIFFERS || func1IsAbstract != func2IsAbstract)) {
                                if (subclassLoc == null && identical == FormalParameterList.IsIdenticalResult.RES_DIFFERS) {
                                    def1.getLocation().reportSemanticError(MessageFormat.format(PROTOTYPENOTIDENTICAL, id1.getDisplayName(), def2.getFullName()));
                                    break;
                                }
                                if (subclassLoc == null || def1.getVisibility() == VisibilityModifier.Private) continue block6;
                                subclassLoc.reportSemanticError(MessageFormat.format(PROTOTYPESDIFFER, id1.getDisplayName(), c1.getIdentifier().getDisplayName(), c2.getIdentifier().getDisplayName()));
                                break;
                            }
                            if (subclassLoc == null && func2.isFinal()) {
                                func1.getSignatureLocation().reportSemanticError(MessageFormat.format(CANNOTOVERRIDEFINAL, def2.getFullName()));
                                break;
                            }
                            if (subclassLoc != null || func1.isIdentical(timestamp, func2) == FormalParameterList.IsIdenticalResult.RES_DIFFERS) continue block6;
                            if (def2.getVisibility() == VisibilityModifier.Public && def1.getVisibility() != VisibilityModifier.Public) {
                                func1.getSignatureLocation().reportSemanticError(MessageFormat.format(PUBLICCANBEOVERRIDDEN, id1.getDisplayName()));
                                break;
                            }
                            if (def2.getVisibility() != VisibilityModifier.Protected || def1.getVisibility() == VisibilityModifier.Public || def1.getVisibility() == VisibilityModifier.Protected) continue block6;
                            func1.getSignatureLocation().reportSemanticError(MessageFormat.format(PROTECTEDCANBEOVERRIDDEN, id1.getDisplayName()));
                            break;
                        }
                        default: {
                            def1.getLocation().reportSemanticError(MessageFormat.format(SHADOWSINHERITEDMEMBER, def1.getDescription(), def2.getFullName()));
                            nameClash = true;
                            break;
                        }
                    }
                    continue block6;
                }
                default: {
                    def1.getLocation().reportSemanticError(MessageFormat.format(SHADOWSINHERITED2, def1.getDescription(), def2 instanceof Def_FunctionBase ? "method" : "member", def2.getFullName()));
                    nameClash = true;
                }
            }
        }
        if (subclassLoc != null) {
            if (c1.baseClass != null) {
                nameClash |= this.compareMembers(c1.baseClass, c2, subclassLoc, timestamp);
            }
            if (c1.baseTraits != null) {
                for (i = 0; i < c1.baseTraits.getNofTypes(); ++i) {
                    Type baseTrait = c1.baseTraits.getType(i);
                    if (baseTrait == null) continue;
                    Class_Type baseTraitClass = baseTrait.getTypeRefdLast(timestamp).getClassType();
                    nameClash |= this.compareMembers(baseTraitClass, c2, subclassLoc, timestamp);
                }
            }
        }
        return nameClash;
    }

    public Class_Type getScopeClass() {
        Scope parentScope = this.getMyScope().getParentScope();
        if (parentScope != null) {
            return parentScope.getScopeClass();
        }
        return null;
    }

    public static FormalParameterList getObjectMethodFormalParameterList(String methodName) {
        ArrayList<FormalParameter> fplist = new ArrayList<FormalParameter>();
        switch (methodName) {
            case "toString": {
                return new FormalParameterList(fplist);
            }
            case "equals": {
                FormalParameter param = new FormalParameter(TemplateRestriction.Restriction_type.TR_NONE, Assignment.Assignment_type.A_PAR_VAL_IN, new Class_Type(), new Identifier(Identifier.Identifier_type.ID_TTCN, "obj"), null, null);
                fplist.add(param);
                return new FormalParameterList(fplist);
            }
        }
        return null;
    }

    public Def_Constructor getConstructor(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            this.check(timestamp);
        }
        return this.constructor;
    }

    public Class_Type getBaseClass() {
        return this.baseClass;
    }

    public Types getBaseTraits() {
        return this.baseTraits;
    }

    public static Type getObjectMethodReturnType(String methodName) {
        switch (methodName) {
            case "toString": {
                return new UniversalCharstring_Type();
            }
            case "equals": {
                return new Boolean_Type();
            }
        }
        return null;
    }

    public boolean isParentClass(CompilationTimeStamp timestamp, Class_Type pclass) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            this.check(timestamp);
        }
        if (this == pclass || !this.isTrait && pclass.isBuiltIn) {
            return true;
        }
        if (this.baseClass != null && this.baseClass.isParentClass(timestamp, pclass)) {
            return true;
        }
        if (this.baseTraits != null) {
            for (int i = 0; i < this.baseTraits.getNofTypes(); ++i) {
                Type baseTrait = this.baseTraits.getType(i);
                if (baseTrait == null || !baseTrait.getTypeRefdLast(timestamp).getClassType().isParentClass(timestamp, pclass)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLocalAssignemtWithID(CompilationTimeStamp timestamp, Identifier id) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            this.check(timestamp);
        }
        if (this.isBuiltIn) {
            return false;
        }
        if (this.members.hasLocalAssignmentWithID(timestamp, id)) {
            return true;
        }
        if (this.baseClass != null && this.baseClass.hasLocalAssignemtWithID(timestamp, id)) {
            return true;
        }
        if (this.baseTraits != null) {
            for (int i = 0; i < this.baseTraits.getNofTypes(); ++i) {
                Type baseTrait = this.baseTraits.getType(i);
                if (baseTrait == null || !baseTrait.getTypeRefdLast(timestamp).getClassType().hasLocalAssignemtWithID(timestamp, id)) continue;
                return true;
            }
        }
        return false;
    }

    public Assignment getLocalAssignmentByID(CompilationTimeStamp timestamp, Identifier id) {
        if (this.isBuiltIn) {
            // empty if block
        }
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            this.check(timestamp);
        }
        Assignment ass = null;
        if (this.members.hasLocalAssignmentWithID(timestamp, id)) {
            ass = this.members.getLocalAssignmentByID(timestamp, id);
        }
        if (ass == null && this.baseClass != null) {
            ass = this.baseClass.getLocalAssignmentByID(timestamp, id);
        }
        if (ass == null && this.baseTraits != null) {
            Type baseTrait;
            for (int i = 0; i < this.baseTraits.getNofTypes() && ((baseTrait = this.baseTraits.getType(i)) == null || (ass = baseTrait.getTypeRefdLast(timestamp).getClassType().getLocalAssignmentByID(timestamp, id)) == null); ++i) {
            }
        }
        return ass;
    }

    public ClassTypeBody getClassTypeBody() {
        return this.body;
    }

    public Definitions getDefinitionMap() {
        return this.members;
    }

    public List<Definition> getDefinitions() {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        if (this.members.getDefinitionMap() != null) {
            for (Map.Entry<String, Definition> defs : this.members.getDefinitionMap().entrySet()) {
                definitions.add(defs.getValue());
            }
        }
        return definitions;
    }

    private Map<Definition, Boolean> getAllDefinitions() {
        HashMap<Definition, Boolean> definitions = new HashMap<Definition, Boolean>();
        if (this.baseClass != null) {
            for (Definition definition : this.baseClass.getDefinitions()) {
                definitions.put(definition, true);
            }
        }
        if (this.baseTraits != null) {
            for (int i = 0; i < this.baseTraits.getNofTypes(); ++i) {
                Type type = this.baseTraits.getType(i);
                if (!(type instanceof Class_Type)) continue;
                for (Definition def : ((Class_Type)type).getDefinitions()) {
                    definitions.put(def, true);
                }
            }
        }
        if (this.members.getDefinitionMap() != null) {
            for (Map.Entry entry : this.members.getDefinitionMap().entrySet()) {
                definitions.put((Definition)entry.getValue(), false);
            }
        }
        return definitions;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean handled = false;
            boolean enveloped = false;
            Location temporalIdentifier = this.classId.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser idReparser = new IdentifierReparser(reparser);
                int result = idReparser.parseAndSetNameChanged();
                this.classId = idReparser.getIdentifier();
                if (result == 0 && this.classId != null) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.runsOnRef != null) {
                if (enveloped) {
                    this.runsOnRef.updateSyntax(reparser, false);
                    reparser.updateLocation(this.runsOnRef.getLocation());
                } else if (reparser.envelopsDamage(this.runsOnRef.getLocation())) {
                    this.runsOnRef.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.runsOnRef.getLocation());
                }
            }
            if (this.mtcRef != null) {
                if (enveloped) {
                    this.mtcRef.updateSyntax(reparser, false);
                    reparser.updateLocation(this.mtcRef.getLocation());
                } else if (reparser.envelopsDamage(this.mtcRef.getLocation())) {
                    this.mtcRef.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.mtcRef.getLocation());
                }
            }
            if (this.systemRef != null) {
                if (enveloped) {
                    this.systemRef.updateSyntax(reparser, false);
                    reparser.updateLocation(this.systemRef.getLocation());
                } else if (reparser.envelopsDamage(this.systemRef.getLocation())) {
                    this.systemRef.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.systemRef.getLocation());
                }
            }
            if (this.subType != null) {
                this.subType.updateSyntax(reparser, false);
                handled = true;
            }
            if (handled) {
                return;
            }
            throw new ReParseException();
        }
        reparser.updateLocation(this.classId.getLocation());
        if (this.runsOnRef != null) {
            this.runsOnRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.runsOnRef.getLocation());
        }
        if (this.mtcRef != null) {
            this.mtcRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.mtcRef.getLocation());
        }
        if (this.systemRef != null) {
            this.systemRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.systemRef.getLocation());
        }
        if (this.body != null) {
            this.body.updateSyntax(reparser, false);
            reparser.updateLocation(this.body.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public String getOutlineIcon() {
        return "class.gif";
    }

    @Override
    public Object[] getOutlineChildren() {
        return this.getAllDefinitions().keySet().toArray();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isTrait() {
        return this.isTrait;
    }

    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Component_Type getRunsOnType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnType;
    }

    public Component_Type getMtcType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.mtcType;
    }

    public Component_Type getSystemType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.systemType;
    }

    public Location getModifierLocation() {
        return this.modifierLocation;
    }

    @Override
    public Identifier getComponentIdentifierByName(Identifier identifier) {
        return null;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        return false;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        return true;
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return "TitanClass";
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return null;
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        return null;
    }

    public void addClassMembers(Assignment assignment, Ttcn3HoverContent content, DocumentComment dc) {
        content.addTag("Members:");
        Map<String, String> members = null;
        if (dc != null) {
            members = dc.getMembers();
        }
        for (Map.Entry<Definition, Boolean> defs : this.getAllDefinitions().entrySet()) {
            IParameterisedAssignment paramAssignment;
            FormalParameterList fpl;
            Definition def = defs.getKey();
            switch (def.getVisibilityModifier()) {
                case Private: {
                    content.addText("<span style=\"margin-left: 20px; margin-right: 5px; color: red;\">\u25fc</span>");
                    break;
                }
                case Public: {
                    content.addText("<span style=\"margin-left: 20px; margin-right: 5px; color: green;\">\u25fc</span>");
                    break;
                }
                default: {
                    content.addText("<span style=\"margin-left: 20px; margin-right: 5px; color: orange;\">\u25fc</span>");
                }
            }
            String id = def.getIdentifier().getDisplayName();
            String memberText = null;
            if (members != null) {
                memberText = members.get(id);
            }
            String memberTypeName = null;
            boolean isOverride = false;
            if (def instanceof Def_Function) {
                memberTypeName = "function";
                if (((Def_Function)def).isOverride()) {
                    isOverride = true;
                }
            } else if (def instanceof Def_AbsFunction) {
                memberTypeName = "abstract function";
            } else if (def instanceof Def_Constructor) {
                memberTypeName = "constructor";
            } else if (def instanceof Def_Timer) {
                memberTypeName = "timer";
            } else {
                IType memberType = def.getType(this.lastTimeChecked);
                if (memberType != null) {
                    memberTypeName = memberType.getTypename();
                }
            }
            if (memberTypeName != null) {
                content.addText(memberTypeName).addText(" ");
            }
            content.addText("<b>" + def.getIdentifier().getDisplayName() + "</b>");
            if (def instanceof IParameterisedAssignment && (fpl = (paramAssignment = (IParameterisedAssignment)((Object)def)).getFormalParameterList()) != null) {
                ArrayList<String> params = new ArrayList<String>();
                for (int i = 0; i < fpl.getNofParameters(); ++i) {
                    params.add(fpl.getParameterByIndex(i).getType(this.lastTimeChecked).getTypename());
                }
                content.addText("(" + String.join((CharSequence)", ", params) + ")");
            }
            if (isOverride) {
                content.addStyledText(" (overridden)", 2);
            } else {
                Map<String, String> parentMembers;
                Class_Type parentClass;
                Def_Type parentType;
                Class_Type parentBody;
                if (defs.getValue().booleanValue()) {
                    content.addStyledText(" (inherited)", 2);
                }
                if (def.getNameParent() instanceof Class_Type && !(parentBody = (Class_Type)def.getNameParent()).equals(this) && (parentType = (Def_Type)(parentClass = this.baseClass).getNameParent()).hasDocumentComment() && (parentMembers = parentType.getDocumentComment().getMembers()) != null) {
                    memberText = parentMembers.get(id);
                }
            }
            content.addText(" ").addText(memberText != null ? memberText : "").addText("<br>");
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.body == null || this.body.accept(v);
    }

    public boolean hasDefaultConstructor() {
        return this.defaultConstructor;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain chain) {
        int i;
        if (this.isBuiltIn) {
            return;
        }
        if (this.baseType != null) {
            chain.markState();
            this.baseType.checkRecursions(timestamp, chain);
            chain.previousState();
        }
        if (this.baseTraits != null) {
            for (i = 0; i < this.baseTraits.getNofTypes(); ++i) {
                Type baseTrait = this.baseTraits.getType(i);
                if (baseTrait == null) continue;
                chain.markState();
                baseTrait.checkRecursions(timestamp, chain);
                chain.previousState();
            }
        }
        block5: for (i = 0; i < this.members.getNofAssignments(); ++i) {
            Definition def = this.members.getAssignmentByIndex(i);
            switch (def.getAssignmentType()) {
                case A_VAR: {
                    if (def.getType(timestamp).getTypeRefdLast(timestamp).getTypetype() == IType.Type_type.TYPE_CLASS) continue block5;
                }
                case A_CONST: 
                case A_TEMPLATE: 
                case A_VAR_TEMPLATE: {
                    chain.markState();
                    def.getType(timestamp).checkRecursions(timestamp, chain);
                    chain.previousState();
                    continue block5;
                }
            }
        }
    }

    public Definitions getMembers() {
        return this.members;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.members != null) {
            this.members.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.body != null) {
            this.body.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    public static enum ClassRelation {
        Identical,
        Related,
        Unrelated;

    }
}

