/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EnumItem
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable,
IReferencingElement {
    private static final String PROPOSAL_KIND = "enumeration";
    private final Identifier identifier;
    private Value value;
    private final boolean originalValue;
    private Location location;
    private Location commentLocation = null;

    public EnumItem(Identifier identifier, Value value) {
        this.identifier = identifier;
        this.value = value;
        this.originalValue = value != null;
        this.location = NULL_Location.INSTANCE;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    public Identifier getId() {
        return this.identifier;
    }

    public boolean isOriginal() {
        return this.originalValue;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void check(CompilationTimeStamp timestamp) {
    }

    public void addProposal(ProposalCollector propCollector) {
        propCollector.addProposal(this.identifier, " - enumeration", ImageCache.getImage("enumeration.gif"), PROPOSAL_KIND);
    }

    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() == i + 1 && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            declarationCollector.addDeclaration(this.identifier.getDisplayName(), this.identifier.getLocation(), this);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        return this.value == null || this.value.accept(v);
    }

    @Override
    public Declaration getDeclaration() {
        if (this.getMyScope() == null) {
            return null;
        }
        Module module = this.getMyScope().getModuleScope();
        Assignment assignment = module.getEnclosingAssignment(this.getLocation().getOffset());
        IType type = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
        if (type instanceof ITypeWithComponents) {
            Identifier id = ((ITypeWithComponents)((Object)type)).getComponentIdentifierByName(this.getId());
            return Declaration.createInstance(assignment, id);
        }
        return null;
    }
}

