/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.makefile.InternalMakefileGenerator;
import org.eclipse.titan.designer.core.makefile.ModuleStruct;
import org.eclipse.titan.designer.core.makefile.OtherFileStruct;
import org.eclipse.titan.designer.core.makefile.UserStruct;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class MakeCliArchive
extends AbstractHandler
implements IObjectActionDelegate {
    private static final String BIN_SUBPATH = File.separator + "bin";
    private static final String BACKUP_SUBPATH = File.separator + "backup";
    private ISelection selection;
    private InternalMakefileGenerator makefileGenerator;

    public void run(IAction action) {
        this.generateCLIArchive(this.selection);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.generateCLIArchive(this.selection);
        return null;
    }

    public void generateCLIArchive(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            List selectionList = structSelection.toList();
            if (selectionList.size() == 1) {
                if (selectionList.get(0) instanceof IProject) {
                    IProject singleSelectedProject = (IProject)selectionList.get(0);
                    this.makefileGenerator = new InternalMakefileGenerator(singleSelectedProject);
                    this.makefileGenerator.gatherInformation();
                    File binDir = new File(singleSelectedProject.getLocation().toFile(), BIN_SUBPATH);
                    File backupDir = new File(binDir, BACKUP_SUBPATH);
                    if (backupDir.exists() || !backupDir.exists() && backupDir.mkdirs()) {
                        String dateTime = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
                        String projectName = singleSelectedProject.getName();
                        try {
                            File zipFile = new File(backupDir, projectName + "_" + dateTime + ".zip");
                            zipFile.createNewFile();
                            try {
                                File f;
                                ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipFile));
                                for (ModuleStruct filedesc : this.makefileGenerator.getTtcn3Modules()) {
                                    f = new File(filedesc.getOriginalLocation());
                                    this.addToArchive(f, zip);
                                }
                                for (ModuleStruct filedesc : this.makefileGenerator.getTtcnppModules()) {
                                    f = new File(filedesc.getOriginalLocation());
                                    this.addToArchive(f, zip);
                                }
                                for (ModuleStruct filedesc : this.makefileGenerator.getAsn1modules()) {
                                    f = new File(filedesc.getOriginalLocation());
                                    this.addToArchive(f, zip);
                                }
                                for (UserStruct filedesc : this.makefileGenerator.getUserFiles()) {
                                    File hhFile;
                                    f = new File(filedesc.getOriginalSourceLocation());
                                    this.addToArchive(f, zip);
                                    String absPath = f.getAbsolutePath();
                                    String pathWithoutExt = absPath.substring(0, absPath.lastIndexOf(46) + 1);
                                    File hFile = new File(pathWithoutExt + "h");
                                    if (hFile.exists()) {
                                        this.addToArchive(hFile, zip);
                                    }
                                    if (!(hhFile = new File(pathWithoutExt + "hh")).exists()) continue;
                                    this.addToArchive(hhFile, zip);
                                }
                                for (OtherFileStruct filedesc : this.makefileGenerator.getOtherFiles()) {
                                    String loc;
                                    if (filedesc.getFileName().equals("Makefile")) {
                                        loc = binDir + File.separator + filedesc.getFileName();
                                        f = new File(loc);
                                        this.addToArchive(f, f.getName() + ".orig", zip);
                                        continue;
                                    }
                                    loc = filedesc.getOriginalLocation();
                                    f = new File(loc);
                                    this.addToArchive(f, zip);
                                }
                                this.createReadme(zip);
                                zip.close();
                            }
                            catch (IOException e1) {
                                ErrorReporter.logExceptionStackTrace((Exception)e1);
                                TITANConsole.println("Unable to create contents of archive file");
                            }
                        }
                        catch (IOException ioe) {
                            ErrorReporter.logExceptionStackTrace((Exception)ioe);
                            TITANConsole.println("Unable to create archive file");
                        }
                    }
                } else {
                    TITANConsole.println("Make CLI archive works only for single selected project");
                }
            } else {
                TITANConsole.println("Make CLI archive works only for single selected project");
            }
        }
    }

    private void createReadme(ZipOutputStream zip) {
        StringBuffer buff = new StringBuffer();
        buff.append("This archive contains the files of one or more Eclipe Titan projects.\n");
        buff.append('\n');
        buff.append("The name of the file itself can be interpreted as follows:\n");
        buff.append("<Project>_<Date>_<time>.tar.gz\n");
        buff.append('\n');
        buff.append("To build it the Makefile has to be generated from sratch using the\n");
        buff.append("\"makefilegen ./*\" command or manually created.\n");
        buff.append('\n');
        buff.append("The original Makefile used to compile at the source system\n");
        buff.append("is also included in this archive named \"Makefile.orig\"\n");
        byte[] data = buff.toString().getBytes();
        try {
            zip.putNextEntry(new ZipEntry("README"));
            zip.write(data);
            zip.closeEntry();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TITANDebugConsole.println("Unable to add README to zip");
        }
    }

    private void addToArchive(File input, ZipOutputStream zip) {
        this.addToArchive(input, input.getName(), zip);
    }

    private void addToArchive(File input, String fileName, ZipOutputStream zip) {
        try {
            zip.putNextEntry(new ZipEntry(fileName));
            byte[] buff = Files.readAllBytes(input.toPath());
            zip.write(buff);
            zip.closeEntry();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TITANConsole.println("Unable to add file to zip: " + input.getName());
        }
    }
}

