/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.application;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.wizards.projectFormat.TpdImporter;

public class LoadFromTpd
implements IApplication {
    private boolean result;

    private void reportResult(boolean result) {
        this.result = result;
    }

    public Object start(IApplicationContext context) throws Exception {
        Platform.getBundle((String)"org.eclipse.titan.designer").start();
        Object arguments = context.getArguments().get("application.args");
        if (!(arguments instanceof String[])) {
            System.out.println("A list of strings was expected as argument.");
            return -1;
        }
        final String[] projectFiles = (String[])arguments;
        if (projectFiles.length != 1) {
            System.out.println("This application takes as parameter the location of the Tpd file it should load projects from.");
            return -1;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IProject[] projects;
                Activator.getDefault().pauseHandlingResourceChanges();
                for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                    try {
                        project.delete(true, true, null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                try {
                    new ProgressMonitorDialog(null).run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            boolean result = true;
                            monitor.beginTask("Importing the data of the project", 1);
                            try {
                                TpdImporter tpdImporter = new TpdImporter(null, true);
                                ArrayList<IProject> projectsCreated = new ArrayList<IProject>();
                                result = tpdImporter.internalFinish(projectFiles[0], false, false, false, projectsCreated, monitor, null);
                            }
                            catch (Exception e) {
                                ErrorReporter.logExceptionStackTrace((Exception)e);
                                result = false;
                            }
                            monitor.done();
                            LoadFromTpd.this.reportResult(result);
                        }
                    });
                }
                catch (Exception e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                Activator.getDefault().resumeHandlingResourceChanges();
            }
        });
        if (this.result) {
            return EXIT_OK;
        }
        return -1;
    }

    public void stop() {
    }
}

