/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.designer.AST.Location;

public final class ParserMarkerSupport {
    private ParserMarkerSupport() {
    }

    public static void createTaskMarker(IFile file, TITANMarker taskMarker) {
        if (!file.isAccessible()) {
            return;
        }
        Location location = new Location((IResource)file, taskMarker.getLine() - 1);
        location.reportExternalProblem(taskMarker.getMessage(), taskMarker.getSeverity(), taskMarker.getPriority(), "org.eclipse.titan.designer.ontheflyTaskMarker");
    }

    public static void createWarningMarker(IFile file, TITANMarker warningMarker) {
        if (!file.isAccessible()) {
            return;
        }
        Location location = new Location((IResource)file, warningMarker.getLine());
        location.reportSyntacticWarning(warningMarker.getMessage());
    }

    public static IMarker[] getAllCompilerMarkers(IResource resource) {
        try {
            IMarker[] errors = resource.findMarkers("org.eclipse.titan.designer.compilerErrorMarker", false, 2);
            IMarker[] warnings = resource.findMarkers("org.eclipse.titan.designer.compilerWarningMarker", false, 2);
            IMarker[] infos = resource.findMarkers("org.eclipse.titan.designer.compilerInfoMarker", false, 2);
            IMarker[] result = new IMarker[errors.length + warnings.length + infos.length];
            System.arraycopy(errors, 0, result, 0, errors.length);
            System.arraycopy(warnings, 0, result, errors.length, warnings.length);
            System.arraycopy(infos, 0, result, errors.length + warnings.length, infos.length);
            return result;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return new IMarker[0];
        }
    }

    public static void removeAllCompilerMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.titan.designer.compilerErrorMarker", false, 2);
            resource.deleteMarkers("org.eclipse.titan.designer.compilerWarningMarker", false, 2);
            resource.deleteMarkers("org.eclipse.titan.designer.compilerInfoMarker", false, 2);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public static void removeAllOnTheFlyMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.titan.designer.ontheflySemanticMarker", false, 2);
            resource.deleteMarkers("org.eclipse.titan.designer.ontheflySyntacticMarker", false, 2);
            resource.deleteMarkers("org.eclipse.titan.designer.ontheflyTaskMarker", false, 2);
            resource.deleteMarkers("org.eclipse.titan.designer.ontheflyMixedMarker", false, 2);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public static void createOnTheFlySyntacticMarker(IFile file, SyntacticErrorStorage errorStorage, int severity, Location relativeLocation) {
        if (!file.isAccessible()) {
            return;
        }
        int lineNumber = errorStorage.lineNumber;
        int charStart = errorStorage.charStart;
        int charEnd = errorStorage.charEnd;
        String message = errorStorage.message;
        Location location = new Location((IResource)file, relativeLocation.getLine() + lineNumber - 1, relativeLocation.getOffset() + charStart, relativeLocation.getOffset() + charEnd);
        location.reportSingularExternalProblem(message, severity, "org.eclipse.titan.designer.ontheflySyntacticMarker");
    }

    public static void createOnTheFlyMixedMarker(IFile file, SyntacticErrorStorage errorStorage, int severity, Location relativeLocation) {
        if (!file.isAccessible()) {
            return;
        }
        int lineNumber = errorStorage.lineNumber;
        int charStart = errorStorage.charStart;
        int charEnd = errorStorage.charEnd;
        String message = errorStorage.message;
        Location location = new Location((IResource)file, relativeLocation.getLine() + lineNumber - 1, relativeLocation.getOffset() + charStart, relativeLocation.getOffset() + charEnd);
        location.reportSingularExternalProblem(message, severity, "org.eclipse.titan.designer.ontheflyMixedMarker");
    }

    public static void createOnTheFlySyntacticMarker(IFile file, SyntacticErrorStorage errorStorage, int severity) {
        if (!file.isAccessible()) {
            return;
        }
        int lineNumber = errorStorage.lineNumber;
        int charStart = errorStorage.charStart;
        int charEnd = errorStorage.charEnd;
        String message = errorStorage.message;
        boolean justDoIt = errorStorage.exceptionType == SyntacticErrorStorage.ExceptionType.LEXER_NOVIABLEALT_EXCEPTION;
        try {
            if (justDoIt && lineNumber >= 0) {
                IDocument document = null;
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                IPath fullPath = file.getFullPath();
                if (manager != null) {
                    manager.connect(fullPath, LocationKind.IFILE, null);
                    ITextFileBuffer buffer = manager.getTextFileBuffer(fullPath, LocationKind.IFILE);
                    document = buffer.getDocument();
                }
                try {
                    if (document != null && lineNumber > 0 && lineNumber <= document.getNumberOfLines()) {
                        charStart = document.getLineOffset(lineNumber - 1);
                        charEnd = document.getLineOffset(lineNumber - 1);
                        charStart += errorStorage.charStart;
                        charEnd += errorStorage.charEnd;
                    }
                }
                catch (BadLocationException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            Location location = new Location((IResource)file, lineNumber, charStart, charEnd);
            location.reportSingularExternalProblem(message, severity, "org.eclipse.titan.designer.ontheflySyntacticMarker");
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public static void createOnTheFlyMixedMarker(IFile file, SyntacticErrorStorage errorStorage, int severity) {
        if (!file.isAccessible()) {
            return;
        }
        int lineNumber = errorStorage.lineNumber;
        int charStart = errorStorage.charStart;
        int charEnd = errorStorage.charEnd;
        String message = errorStorage.message;
        boolean justDoIt = errorStorage.exceptionType == SyntacticErrorStorage.ExceptionType.LEXER_NOVIABLEALT_EXCEPTION;
        try {
            if (justDoIt && lineNumber >= 0) {
                IDocument document = null;
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                IPath fullPath = file.getFullPath();
                if (manager != null) {
                    manager.connect(fullPath, LocationKind.IFILE, null);
                    ITextFileBuffer buffer = manager.getTextFileBuffer(fullPath, LocationKind.IFILE);
                    document = buffer.getDocument();
                }
                try {
                    if (document != null && lineNumber > 0 && lineNumber <= document.getNumberOfLines()) {
                        charStart = document.getLineOffset(lineNumber - 1);
                        charEnd = document.getLineOffset(lineNumber - 1);
                        charStart += errorStorage.charStart;
                        charEnd += errorStorage.charEnd;
                    }
                }
                catch (BadLocationException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            Location location = new Location((IResource)file, lineNumber, charStart, charEnd);
            location.reportSingularExternalProblem(message, severity, "org.eclipse.titan.designer.ontheflyMixedMarker");
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }
}

