/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.designer.editors.configeditor.ConfigSkeletons;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.wizards.NewConfigFileWizard;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public final class NewConfigFileCreationWizardPage
extends WizardNewFileCreationPage {
    private static final String TITLE = "New Configuration File";
    private static final String DESCRIPTION = "Create a new configuration file";
    private static final String ERROR_MESSAGE = "When provided the extension of the configuration file must be \"cfg\"";
    private static final String EMPTYCFGFILENAMEERROR = "Configuration files must have a name.";
    private static final String INVALIDCFGFILENAME = "Invalid configuration file name {0}";
    private static final String CFGFILENAMEREGEXP = "[a-zA-Z][a-zA-Z_0-9]*";
    private static final Pattern CFGFILENAMEPATTERN = Pattern.compile("[a-zA-Z][a-zA-Z_0-9]*");
    private final NewConfigFileWizard wizard;

    public NewConfigFileCreationWizardPage(IStructuredSelection selection, NewConfigFileWizard wizard) {
        super(TITLE, selection);
        this.wizard = wizard;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getTitle() {
        return TITLE;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String extension = this.getContainerFullPath().append(this.getFileName()).getFileExtension();
        if (extension == null) {
            this.setErrorMessage(null);
            return this.validateName();
        }
        boolean valid = false;
        for (int i = 0; i < GlobalParser.SUPPORTED_CONFIG_FILE_EXTENSIONS.length; ++i) {
            if (!GlobalParser.SUPPORTED_CONFIG_FILE_EXTENSIONS[i].equals(extension)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            this.setErrorMessage(ERROR_MESSAGE);
            return false;
        }
        this.setErrorMessage(null);
        return this.validateName();
    }

    protected InputStream getInitialContents() {
        if (this.wizard.getOptionsPage().isGenerateSkeletonSelected()) {
            return new BufferedInputStream(new ByteArrayInputStream(ConfigSkeletons.CONFIG_FILE_SKELETON.getBytes()));
        }
        return super.getInitialContents();
    }

    public boolean validateName() {
        String longModuleName;
        String originalmoduleName = this.getFileName();
        if (originalmoduleName == null) {
            return false;
        }
        int dotIndex = originalmoduleName.lastIndexOf(46);
        String string = longModuleName = dotIndex == -1 ? originalmoduleName : originalmoduleName.substring(0, dotIndex);
        if ("".equals(longModuleName)) {
            this.setErrorMessage(EMPTYCFGFILENAMEERROR);
            return false;
        }
        if (!CFGFILENAMEPATTERN.matcher(longModuleName).matches()) {
            this.setErrorMessage(MessageFormat.format(INVALIDCFGFILENAME, longModuleName));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

