/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class MissingImport
extends BaseModuleCodeSmellSpotter {
    private static final String MISSING_MODULE = "There is no module with name `{0}''";

    public MissingImport() {
        super(CodeSmellType.MISSING_IMPORT);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        ImportModule s;
        if (node instanceof ImportModule && (s = (ImportModule)node).getReferredModule() == null) {
            String msg = MessageFormat.format(MISSING_MODULE, s.getIdentifier().getDisplayName());
            problems.report(s.getIdentifier().getLocation(), msg);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(ImportModule.class);
        return ret;
    }
}

