/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanInteger;

public class RAW {
    public static final int[] BitReverseTable = new int[]{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};
    public static final int[] BitMaskTable = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    public static final int RAW_INT_ENC_LENGTH = 4;
    public static final int RAW_INTX = -1;

    public static int REVERSE_BITS(int b) {
        return BitReverseTable[b & 0xFF];
    }

    private RAW() {
    }

    public static int min_bits(int a) {
        int bits = 0;
        int tmp = a;
        if (a < 0) {
            bits = 1;
            tmp = -a;
        }
        while (tmp != 0) {
            ++bits;
            tmp /= 2;
        }
        return bits;
    }

    public static int min_bits(BigInteger a) {
        if (a == null) {
            return 0;
        }
        return a.bitLength();
    }

    public static int RAW_encode_enum_type(Base_Type.TTCN_Typedescriptor p_td, RAW_enc_tree myleaf, int integer_value, int min_bits_enum) {
        if (p_td.raw.fieldlength == 0) {
            int fl = min_bits_enum;
            TTCN_RAWdescriptor my_raw = new TTCN_RAWdescriptor(fl, p_td.raw.comp, p_td.raw.byteorder, p_td.raw.endianness, p_td.raw.bitorderinfield, p_td.raw.bitorderinoctet, p_td.raw.extension_bit, p_td.raw.hexorder, p_td.raw.fieldorder, p_td.raw.top_bit_order, p_td.raw.padding, p_td.raw.prepadding, p_td.raw.ptroffset, p_td.raw.unit, p_td.raw.padding_pattern_length, p_td.raw.padding_pattern, p_td.raw.length_restrition, p_td.raw.stringformat, p_td.raw.forceomit, p_td.raw.csn1lh);
            Base_Type.TTCN_Typedescriptor my_descr = new Base_Type.TTCN_Typedescriptor(p_td.name, null, my_raw, null, null);
            TitanInteger i = new TitanInteger(integer_value);
            i.RAW_encode(my_descr, myleaf);
            myleaf.length = fl;
            return myleaf.length;
        }
        TitanInteger i = new TitanInteger(integer_value);
        i.RAW_encode(p_td, myleaf);
        myleaf.length = p_td.raw.fieldlength;
        return myleaf.length;
    }

    public static int RAW_decode_enum_type(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, AtomicInteger value, int min_bits_enum, boolean no_err) {
        if (p_td.raw.fieldlength == 0) {
            TitanInteger i = new TitanInteger();
            TTCN_RAWdescriptor my_raw = new TTCN_RAWdescriptor(min_bits_enum, p_td.raw.comp, p_td.raw.byteorder, p_td.raw.endianness, p_td.raw.bitorderinfield, p_td.raw.bitorderinoctet, p_td.raw.extension_bit, p_td.raw.hexorder, p_td.raw.fieldorder, p_td.raw.top_bit_order, p_td.raw.padding, p_td.raw.prepadding, p_td.raw.ptroffset, p_td.raw.unit, p_td.raw.padding_pattern_length, p_td.raw.padding_pattern, p_td.raw.length_restrition, p_td.raw.stringformat, p_td.raw.forceomit, p_td.raw.csn1lh);
            Base_Type.TTCN_Typedescriptor my_descr = new Base_Type.TTCN_Typedescriptor(p_td.name, null, my_raw, null, null);
            int fl = i.RAW_decode(my_descr, buff, limit, top_bit_ord, no_err, -1, true, null);
            if (fl < 0 || !i.is_native()) {
                return -1;
            }
            value.set(i.get_int());
            return fl + buff.increase_pos_padd(p_td.raw.padding);
        }
        TitanInteger i = new TitanInteger();
        int fl = i.RAW_decode(p_td, buff, limit, top_bit_ord, no_err, -1, true, null);
        if (fl < 0 || !i.is_native()) {
            return -1;
        }
        value.set(i.get_int());
        return fl + buff.increase_pos_padd(p_td.raw.padding);
    }

    public int[] init_new_tree_pos(RAW_enc_tr_pos old_pos, int new_levels, int[] new_pos) {
        int[] new_position = new int[old_pos.level + new_levels];
        System.arraycopy(old_pos.pos, 0, new_pos, 0, old_pos.level);
        System.arraycopy(new_pos, 0, new_pos, new_pos.length + old_pos.level, new_levels);
        return new_position;
    }

    public static enum calc_type {
        CALC_NO,
        CALC_LENGTH,
        CALC_POINTER;

    }

    public static enum raw_sign_t {
        SG_NO,
        SG_2COMPL,
        SG_SG_BIT;

    }

    public static enum top_bit_order_t {
        TOP_BIT_INHERITED,
        TOP_BIT_LEFT,
        TOP_BIT_RIGHT;

    }

    public static enum ext_bit_t {
        EXT_BIT_NO,
        EXT_BIT_YES,
        EXT_BIT_REVERSE;

    }

    public static class RAW_coding_par {
        public TTCN_EncDec.raw_order_t bitorder;
        public TTCN_EncDec.raw_order_t byteorder;
        public TTCN_EncDec.raw_order_t hexorder;
        public TTCN_EncDec.raw_order_t fieldorder;
        public boolean csn1lh;

        public RAW_coding_par(TTCN_EncDec.raw_order_t bitorder, TTCN_EncDec.raw_order_t byteorder, TTCN_EncDec.raw_order_t hexorder, TTCN_EncDec.raw_order_t fieldorder, boolean csn1lh) {
            this.bitorder = bitorder;
            this.byteorder = byteorder;
            this.hexorder = hexorder;
            this.fieldorder = fieldorder;
            this.csn1lh = csn1lh;
        }

        public RAW_coding_par() {
        }
    }

    public static class RAW_enc_lengthto {
        public int num_of_fields;
        public RAW_enc_tr_pos[] fields;
        public int unit;
        public int offset;

        public RAW_enc_lengthto(int num_of_fields, RAW_enc_tr_pos[] fields, int unit, int offset) {
            this.num_of_fields = num_of_fields;
            this.fields = fields;
            this.unit = unit;
            this.offset = offset;
        }
    }

    public static class RAW_enc_pointer {
        public RAW_enc_tr_pos target;
        public int ptr_offset;
        public int unit;
        public int ptr_base;

        public RAW_enc_pointer(RAW_enc_tr_pos target, int ptr_offset, int unit, int ptr_base) {
            this.target = target;
            this.ptr_offset = ptr_offset;
            this.unit = unit;
            this.ptr_base = ptr_base;
        }
    }

    public static class RAW_enc_tr_pos {
        public int level;
        public int[] pos;

        public RAW_enc_tr_pos(int level, int[] pos) {
            this.level = level;
            this.pos = pos;
        }
    }

    public static final class TTCN_RAWdescriptor {
        public int fieldlength;
        public final raw_sign_t comp;
        public final TTCN_EncDec.raw_order_t byteorder;
        public final TTCN_EncDec.raw_order_t endianness;
        public final TTCN_EncDec.raw_order_t bitorderinfield;
        public final TTCN_EncDec.raw_order_t bitorderinoctet;
        public final ext_bit_t extension_bit;
        public final TTCN_EncDec.raw_order_t hexorder;
        public final TTCN_EncDec.raw_order_t fieldorder;
        public final top_bit_order_t top_bit_order;
        public final int padding;
        public final int prepadding;
        public final int ptroffset;
        public final int unit;
        public final int padding_pattern_length;
        public final byte[] padding_pattern;
        public final int length_restrition;
        public final TitanCharString.CharCoding stringformat;
        public final RAW_Force_Omit forceomit;
        public final boolean csn1lh;

        public TTCN_RAWdescriptor(int fieldlength, raw_sign_t comp, TTCN_EncDec.raw_order_t byteorder, TTCN_EncDec.raw_order_t endianness, TTCN_EncDec.raw_order_t bitorderinfield, TTCN_EncDec.raw_order_t bitorderinoctet, ext_bit_t extension_bit, TTCN_EncDec.raw_order_t hexorder, TTCN_EncDec.raw_order_t fieldorder, top_bit_order_t top_bit_order, int padding, int prepadding, int ptroffset, int unit, int padding_pattern_length, byte[] padding_pattern, int length_restrition, TitanCharString.CharCoding stringformat, RAW_Force_Omit forceomit, boolean csn1lh) {
            this.fieldlength = fieldlength;
            this.comp = comp;
            this.byteorder = byteorder;
            this.endianness = endianness;
            this.bitorderinfield = bitorderinfield;
            this.bitorderinoctet = bitorderinoctet;
            this.extension_bit = extension_bit;
            this.hexorder = hexorder;
            this.fieldorder = fieldorder;
            this.top_bit_order = top_bit_order;
            this.padding = padding;
            this.prepadding = prepadding;
            this.ptroffset = ptroffset;
            this.unit = unit;
            this.padding_pattern_length = padding_pattern_length;
            this.padding_pattern = padding_pattern;
            this.length_restrition = length_restrition;
            this.stringformat = stringformat;
            this.forceomit = forceomit;
            this.csn1lh = csn1lh;
        }
    }

    public static final class RAW_Force_Omit {
        public int size;
        public ArrayList<RAW_Field_List> lists;
        public boolean temporary;

        public RAW_Force_Omit(int size, ArrayList<RAW_Field_List> lists) {
            this.size = size;
            this.lists = lists;
            this.temporary = false;
        }

        public RAW_Force_Omit(int fieldIndex, RAW_Force_Omit parent, RAW_Force_Omit variant) {
            this.size = variant == null ? 0 : variant.size;
            this.lists = null;
            this.temporary = true;
            if (parent != null) {
                for (int i = 0; i < parent.size; ++i) {
                    RAW_Field_List fieldList = parent.lists.get(i);
                    if (fieldList.index != fieldIndex || fieldList.nextPointer == null) continue;
                    ++this.size;
                }
            }
            if (this.size == 0) {
                return;
            }
            this.lists = new ArrayList(this.size);
            int j = 0;
            if (parent != null) {
                for (int i = 0; i < parent.size; ++i) {
                    RAW_Field_List fieldList = parent.lists.get(i);
                    if (fieldList.index != fieldIndex || fieldList.nextPointer == null) continue;
                    this.lists.add(j, fieldList.nextPointer);
                    ++j;
                }
            }
            if (variant != null) {
                this.lists.addAll(variant.lists);
            }
        }

        public boolean shouldOmit(int fieldIndex) {
            for (int i = 0; i < this.size; ++i) {
                RAW_Field_List fieldList = this.lists.get(i);
                if (fieldList.index != fieldIndex || fieldList.nextPointer != null) continue;
                return true;
            }
            return false;
        }
    }

    public static final class RAW_Field_List {
        public int index;
        public RAW_Field_List nextPointer;

        public RAW_Field_List(int index, RAW_Field_List nextPointer) {
            this.index = index;
            this.nextPointer = nextPointer;
        }
    }

    public static class RAW_enc_tree {
        public boolean isleaf;
        public boolean rec_of;
        public RAW_enc_tree parent;
        public RAW_enc_tr_pos curr_pos;
        public int length;
        public int padding;
        public int prepadding;
        public int startpos;
        public int padlength;
        public int prepadlength;
        public int padding_pattern_length;
        public byte[] padding_pattern;
        public int align;
        public int ext_bit_handling;
        public ext_bit_t ext_bit;
        public top_bit_order_t top_bit_order;
        public Base_Type.TTCN_Typedescriptor coding_descr;
        public calc_type calc;
        public RAW_coding_par coding_par;
        public RAW_enc_lengthto lengthto;
        public RAW_enc_pointer pointerto;
        public int num_of_nodes;
        public RAW_enc_tree[] nodes;
        public byte[] data_array = new byte[4];

        public RAW_enc_tree(boolean is_leaf, RAW_enc_tree par, RAW_enc_tr_pos par_pos, int my_pos, Base_Type.TTCN_Typedescriptor type_descriptor) {
            boolean orders;
            TTCN_RAWdescriptor raw_attr = type_descriptor.raw;
            this.isleaf = is_leaf;
            this.rec_of = false;
            this.parent = par;
            this.curr_pos = new RAW_enc_tr_pos(par_pos.level + 1, new int[par_pos.level + 1]);
            if (par_pos.level > 0) {
                System.arraycopy(par_pos.pos, 0, this.curr_pos.pos, 0, par_pos.pos.length);
            }
            this.curr_pos.pos[this.curr_pos.level - 1] = my_pos;
            this.length = 0;
            this.padding = raw_attr.padding;
            this.prepadding = raw_attr.prepadding;
            this.padding_pattern_length = raw_attr.padding_pattern_length;
            this.padding_pattern = raw_attr.padding_pattern;
            this.startpos = 0;
            this.padlength = 0;
            this.prepadlength = 0;
            this.align = 0;
            this.ext_bit_handling = 0;
            this.coding_descr = type_descriptor;
            this.ext_bit = raw_attr.extension_bit;
            this.top_bit_order = raw_attr.top_bit_order;
            this.calc = calc_type.CALC_NO;
            boolean bl = orders = raw_attr.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (raw_attr.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            TTCN_EncDec.raw_order_t tempbyteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl2 = orders = raw_attr.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (raw_attr.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            TTCN_EncDec.raw_order_t tempbitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            TTCN_EncDec.raw_order_t temphexorder = raw_attr.hexorder;
            TTCN_EncDec.raw_order_t tempfieldorder = raw_attr.fieldorder;
            this.coding_par = new RAW_coding_par(tempbitorder, tempbyteorder, temphexorder, tempfieldorder, false);
            if (!is_leaf) {
                this.num_of_nodes = 0;
                this.nodes = null;
            }
        }

        public RAW_enc_tree(boolean is_leaf, RAW_enc_tree par, RAW_enc_tr_pos par_pos, int my_pos, TTCN_RAWdescriptor raw_attr) {
            boolean orders;
            this.isleaf = is_leaf;
            this.rec_of = false;
            this.parent = par;
            this.curr_pos = new RAW_enc_tr_pos(par_pos.level + 1, new int[par_pos.level + 1]);
            if (par_pos.level > 0) {
                System.arraycopy(par_pos.pos, 0, this.curr_pos.pos, 0, par_pos.pos.length);
            }
            this.curr_pos.pos[this.curr_pos.level - 1] = my_pos;
            this.length = 0;
            this.padding = raw_attr.padding;
            this.prepadding = raw_attr.prepadding;
            this.padding_pattern_length = raw_attr.padding_pattern_length;
            this.padding_pattern = raw_attr.padding_pattern;
            this.startpos = 0;
            this.padlength = 0;
            this.prepadlength = 0;
            this.align = 0;
            this.ext_bit_handling = 0;
            this.coding_descr = null;
            this.ext_bit = raw_attr.extension_bit;
            this.top_bit_order = raw_attr.top_bit_order;
            this.calc = calc_type.CALC_NO;
            boolean bl = orders = raw_attr.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (raw_attr.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            TTCN_EncDec.raw_order_t tempbyteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl2 = orders = raw_attr.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (raw_attr.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            TTCN_EncDec.raw_order_t tempbitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            TTCN_EncDec.raw_order_t temphexorder = raw_attr.hexorder;
            TTCN_EncDec.raw_order_t tempfieldorder = raw_attr.fieldorder;
            this.coding_par = new RAW_coding_par(tempbitorder, tempbyteorder, temphexorder, tempfieldorder, false);
            if (!is_leaf) {
                this.num_of_nodes = 0;
                this.nodes = null;
            }
        }

        public void put_to_buf(TTCN_Buffer buf) {
            this.calc_padding(0);
            this.calc_fields();
            this.fill_buf(buf);
        }

        private void calc_fields() {
            if (this.isleaf) {
                switch (this.calc) {
                    case CALC_LENGTH: {
                        int szumm = 0;
                        if (this.lengthto.unit != -1) {
                            for (int a = 0; a < this.lengthto.num_of_fields; ++a) {
                                RAW_enc_tree atm = this.get_node(this.lengthto.fields[a]);
                                if (atm == null) continue;
                                szumm += atm.length + atm.padlength + atm.prepadlength;
                            }
                            szumm = (szumm + this.lengthto.unit - 1) / this.lengthto.unit;
                        } else {
                            RAW_enc_tree atm = this.get_node(this.lengthto.fields[0]);
                            if (atm != null) {
                                szumm = atm.num_of_nodes;
                            }
                        }
                        TitanInteger temp = new TitanInteger(szumm += this.lengthto.offset);
                        temp.RAW_encode(this.coding_descr, this);
                        break;
                    }
                    case CALC_POINTER: {
                        int cl = this.curr_pos.pos[this.curr_pos.level - 1];
                        this.curr_pos.pos[this.curr_pos.level - 1] = this.pointerto.ptr_base;
                        int base = this.pointerto.ptr_base;
                        RAW_enc_tree b = this.get_node(this.curr_pos);
                        while (b == null) {
                            this.curr_pos.pos[this.curr_pos.level - 1] = ++base;
                            b = this.get_node(this.curr_pos);
                        }
                        this.curr_pos.pos[this.curr_pos.level - 1] = cl;
                        int szumm = 0;
                        RAW_enc_tree atm = this.get_node(this.pointerto.target);
                        if (atm != null) {
                            szumm = (atm.startpos - b.startpos + this.pointerto.unit - 1 - this.pointerto.ptr_offset) / this.pointerto.unit;
                        }
                        TitanInteger temp = new TitanInteger(szumm);
                        temp.RAW_encode(this.coding_descr, this);
                        break;
                    }
                }
            } else {
                for (int a = 0; a < this.num_of_nodes; ++a) {
                    if (this.nodes[a] == null) continue;
                    this.nodes[a].calc_fields();
                }
            }
        }

        private int calc_padding(int position) {
            int new_pos;
            int current_pos = position;
            this.startpos = position;
            if (this.prepadding != 0) {
                new_pos = (current_pos + this.prepadding - 1) / this.prepadding * this.prepadding;
                this.prepadlength = new_pos - position;
                current_pos = new_pos;
            }
            if (!this.isleaf) {
                for (int a = 0; a < this.num_of_nodes; ++a) {
                    if (this.nodes[a] == null) continue;
                    current_pos = this.nodes[a].calc_padding(current_pos);
                }
                this.length = current_pos - position - this.prepadlength;
            } else {
                current_pos += this.length;
            }
            if (this.padding != 0) {
                new_pos = (current_pos + this.padding - 1) / this.padding * this.padding;
                this.padlength = new_pos - this.length - position - this.prepadlength;
                current_pos = new_pos;
            }
            return current_pos;
        }

        private void fill_buf(TTCN_Buffer buf) {
            boolean old_order = buf.get_order();
            if (this.top_bit_order != top_bit_order_t.TOP_BIT_INHERITED) {
                buf.set_order(this.top_bit_order != top_bit_order_t.TOP_BIT_RIGHT);
            }
            buf.put_pad(this.prepadlength, this.padding_pattern, this.padding_pattern_length, this.coding_par.fieldorder);
            if (this.isleaf) {
                int align_length;
                int n = align_length = this.align < 0 ? -this.align : this.align;
                if (this.ext_bit != ext_bit_t.EXT_BIT_NO) {
                    buf.start_ext_bit(this.ext_bit == ext_bit_t.EXT_BIT_REVERSE);
                }
                buf.put_b(this.length - align_length, this.data_array, this.coding_par, this.align);
                if (this.ext_bit_handling > 1) {
                    buf.stop_ext_bit();
                } else if (this.ext_bit != ext_bit_t.EXT_BIT_NO && this.ext_bit_handling == 0) {
                    buf.stop_ext_bit();
                }
            } else {
                if (!(this.ext_bit == ext_bit_t.EXT_BIT_NO || this.rec_of && this.ext_bit_handling % 2 == 0)) {
                    buf.start_ext_bit(this.ext_bit == ext_bit_t.EXT_BIT_REVERSE);
                }
                for (int a = 0; a < this.num_of_nodes; ++a) {
                    if (this.nodes[a] != null) {
                        this.nodes[a].fill_buf(buf);
                    }
                    if (this.ext_bit == ext_bit_t.EXT_BIT_NO || !this.rec_of || this.ext_bit_handling != 0) continue;
                    buf.set_last_bit(this.ext_bit != ext_bit_t.EXT_BIT_YES);
                }
                if (this.ext_bit_handling == 0) {
                    if (this.ext_bit != ext_bit_t.EXT_BIT_NO) {
                        if (this.rec_of) {
                            buf.set_last_bit(this.ext_bit == ext_bit_t.EXT_BIT_YES);
                        } else {
                            buf.stop_ext_bit();
                        }
                    }
                } else if (this.ext_bit_handling > 1) {
                    buf.stop_ext_bit();
                }
            }
            buf.put_pad(this.padlength, this.padding_pattern, this.padding_pattern_length, this.coding_par.fieldorder);
            buf.set_order(old_order);
        }

        public RAW_enc_tree get_node(RAW_enc_tr_pos req_pos) {
            if (req_pos.level == 0) {
                return null;
            }
            RAW_enc_tree t = this;
            int cur_level = this.curr_pos.level;
            for (int b = 1; b < cur_level; ++b) {
                t = t.parent;
            }
            for (cur_level = 1; cur_level < req_pos.level; ++cur_level) {
                if (t == null || t.isleaf || t.num_of_nodes <= req_pos.pos[cur_level]) {
                    return null;
                }
                t = t.nodes[req_pos.pos[cur_level]];
            }
            return t;
        }
    }
}

