/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.markdown;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IStateStack;
import org.eclipse.tm4e.core.model.ITokenizationSupport;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.core.model.TMTokenization;
import org.eclipse.tm4e.core.model.TokenizationResult;
import org.eclipse.tm4e.markdown.marked.HTMLRenderer;
import org.eclipse.tm4e.markdown.marked.Helpers;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;

public class TMHTMLRenderer
extends HTMLRenderer {
    private final String defaultLang;

    public TMHTMLRenderer(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    @Override
    public void code(String code, @Nullable String lang, boolean escaped) {
        IGrammar grammar;
        IGrammar iGrammar = grammar = lang == null ? this.getDefaultGrammar() : this.getGrammar(lang);
        if (grammar == null) {
            super.code(code, lang, escaped);
        } else {
            TMTokenization tokenizationSupport = new TMTokenization(grammar);
            this.html.append("<div style=\"white-space: pre-wrap;\">");
            this.tokenizeLines(code, (ITokenizationSupport)tokenizationSupport);
            this.html.append("</div>");
        }
    }

    private void tokenizeLines(String text, ITokenizationSupport tokenizationSupport) {
        String[] lines = text.split("\r\n|\r|\n");
        @Nullable IStateStack currentState = tokenizationSupport.getInitialState();
        int i = 0;
        while (i < lines.length) {
            currentState = this.tokenizeLine(lines[i], tokenizationSupport, currentState);
            if (i < lines.length - 1) {
                this.emitNewLine();
            }
            ++i;
        }
    }

    private void emitNewLine() {
        this.html.append("<br/>");
    }

    private @Nullable IStateStack tokenizeLine(String line, ITokenizationSupport tokenizationSupport, @Nullable IStateStack startState) {
        TokenizationResult tokenized = tokenizationSupport.tokenize(line, startState);
        IStateStack endState = tokenized.getEndState();
        List tokens = tokenized.getTokens();
        int offset = 0;
        int j = 0;
        while (j < tokens.size()) {
            String tokenText;
            TMToken token = (TMToken)tokens.get(j);
            if (j < tokens.size() - 1) {
                tokenText = line.substring(offset, ((TMToken)tokens.get((int)(j + 1))).startIndex);
                offset = ((TMToken)tokens.get((int)(j + 1))).startIndex;
            } else {
                tokenText = line.substring(offset);
            }
            String className = "token";
            String safeType = token.type.replaceAll("[^a-z0-9\\-]", " ");
            if (!safeType.isEmpty()) {
                className = String.valueOf(className) + ' ' + safeType;
            }
            this.html.append("<span ");
            this.html.append("class=\"");
            this.html.append(className);
            this.html.append("\">");
            this.html.append(Helpers.htmlEscape(tokenText));
            this.html.append("</span>");
            ++j;
        }
        return endState;
    }

    protected @Nullable IGrammar getDefaultGrammar() {
        return this.getGrammar(this.defaultLang);
    }

    protected @Nullable IGrammar getGrammar(String lang) {
        IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor("x." + lang);
        return TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarFor(contentTypes);
    }
}

