/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.impl.list.mutable.MutableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutableListIterator<T>
extends MutableIterator<T>
implements ListIterator<T> {
    public MutableListIterator(List<T> list, int index) {
        super(list);
        this.currentIndex = index;
    }

    @Override
    public boolean hasPrevious() {
        return this.currentIndex != 0;
    }

    @Override
    public T previous() {
        try {
            int i = this.currentIndex - 1;
            Object previous = this.list.get(i);
            this.currentIndex = i;
            this.lastIndex = i;
            return (T)previous;
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int nextIndex() {
        return this.currentIndex;
    }

    @Override
    public int previousIndex() {
        return this.currentIndex - 1;
    }

    @Override
    public void set(T o) {
        if (this.lastIndex == -1) {
            throw new IllegalStateException();
        }
        try {
            this.list.set(this.lastIndex, o);
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void add(T o) {
        this.list.add(this.currentIndex++, o);
        this.lastIndex = -1;
    }
}

