/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.extension;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.extension.IAlternativePatternMatcherFactory;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VIATRAGTMatcherPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.viatra2.gtasm.patternmatcher.impl";
    public static final String PATTERN_MATCHER_EXT_ID = "org.eclipse.viatra2.gtasm.patternmatcher.impl.alternativepatternmatcher";
    public static final String INCREMENTAL_PM_FACTORY_ID = "org.eclipse.viatra2.gtasm.patternmatcher.incremental.alternativeGTmatcher";
    public static final String DEFAULT_ALTERNATIVE_PM_FACTORY_ID = "org.eclipse.viatra2.gtasm.patternmatcher.incremental.alternativeGTmatcher";
    private static VIATRAGTMatcherPlugin plugin;
    private Map<String, IAlternativePatternMatcherFactory> patternMatcherFactories;

    public VIATRAGTMatcherPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static VIATRAGTMatcherPlugin getDefault() {
        return plugin;
    }

    public Map<String, IAlternativePatternMatcherFactory> getPatternMatcherFactories() {
        if (this.patternMatcherFactories == null) {
            this.patternMatcherFactories = this.initPatternMatcherFactories();
        }
        return this.patternMatcherFactories;
    }

    public IAlternativePatternMatcherFactory getPatternMatcherFactory(String id) {
        if (this.patternMatcherFactories == null) {
            this.patternMatcherFactories = this.initPatternMatcherFactories();
        }
        return this.patternMatcherFactories.containsKey(id) ? this.patternMatcherFactories.get(id) : null;
    }

    private Map<String, IAlternativePatternMatcherFactory> initPatternMatcherFactories() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(PATTERN_MATCHER_EXT_ID);
        HashMap<String, IAlternativePatternMatcherFactory> r = new HashMap<String, IAlternativePatternMatcherFactory>();
        if (poi == null) {
            return r;
        }
        IExtension[] exts = poi.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    Object o = el[j].createExecutableExtension("class");
                    if (o instanceof IAlternativePatternMatcherFactory) {
                        String id = el[j].getAttribute("id");
                        r.put(id, (IAlternativePatternMatcherFactory)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return r;
    }

    public Boolean hasAlternativePatternMatcher() {
        if (this.patternMatcherFactories == null) {
            this.patternMatcherFactories = this.initPatternMatcherFactories();
        }
        if (this.patternMatcherFactories.size() > 0) {
            return true;
        }
        return false;
    }
}

