/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleInterpreter;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternMatcherParameters;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherCompileTimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTRuleBuildingException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GraphTransformationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTElementMapping;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTOperationContext;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTRuleMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.RightHandSideMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.IUpdatePlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.core.PatternBuilder;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ISearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.BasicTermHandler;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.ITermHandler;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.SymbolicRuleParameter;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraditionalGTRuleMatcher
extends GTRuleMatcher {
    IPatternMatcher leftHandSidePatternMatcher;
    RightHandSideMatcher rightHandSideMatcher;
    boolean isRandom;
    Collection<GTElementMapping> elementMappings = new ArrayList<GTElementMapping>();
    Collection<IUpdatePlanOperation> nonchangeableGTOperations;
    Collection<ISearchPlanOperation> checkSet;

    public TraditionalGTRuleMatcher(GTRule gt, IExecutionEnvironment enviroment, ITermHandler handler, PatternMatcherParameters mp) throws ViatraTransformationException {
        super(enviroment.getFramework().getLogger(), enviroment.getFramework().getTopmodel().getModelManager(), gt);
        this.initGTRule(enviroment);
        this.construct(this.manager, mp.getCallSignature());
    }

    protected IPatternMatcher getPatternMatcherforPreCondition() throws ViatraTransformationException {
        PatternBuilder pb = new PatternBuilder(this.logger, this.manager, this.handler);
        try {
            return pb.construct(this.gtRule.getPrecondition().getCalledPattern());
        }
        catch (PatternMatcherCompileTimeException e) {
            throw e.addNewStackElement((EObject)this.gtRule);
        }
    }

    protected boolean isLeftHandSideRandom() {
        for (Object annot : this.gtRule.getPrecondition().getCalledPattern().getRuntimeAnnotations()) {
            if (!"@random".equals(((RuntimeAnnotation)annot).getAnnotationName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void construct(IModelManager manager, PatternCallSignature[] symSignatures) throws ViatraTransformationException {
        if (this.gtRule.getPostcondition() != null && this.gtRule.getPrecondition() == null) {
            this.logger.error("There is only PostCondition defined for the GTRule " + this.gtRule.getName());
        }
        if (this.gtRule.getPostcondition() != null) {
            PatternCallSignature sig;
            try {
                this.leftHandSidePatternMatcher = this.getPatternMatcherforPreCondition();
                this.isRandom = this.isLeftHandSideRandom();
                this.rightHandSideMatcher = new RightHandSideMatcher(this.gtRule.getPostcondition().getCalledPattern(), this.logger, manager, this.handler);
            }
            catch (PatternMatcherCompileTimeException e) {
                this.logger.error(e.getMessage());
                throw e.addNewStackElement((EObject)this.gtRule);
            }
            this.elementMappings = new ArrayList<GTElementMapping>();
            int actualIndex = 0;
            for (Object obj : this.gtRule.getPrecondition().getActualParameters()) {
                VariableReference varReference = (VariableReference)obj;
                Variable actualVariable = varReference.getVariable();
                if (this.getActualParameterIndexof(this.gtRule.getPostcondition(), actualVariable) != -1) {
                    GTElementMapping map = new GTElementMapping(actualIndex, this.getActualParameterIndexof(this.gtRule.getPostcondition(), actualVariable));
                    this.elementMappings.add(map);
                }
                ++actualIndex;
            }
            PatternCallSignature[] rhsSignatures = new PatternCallSignature[this.gtRule.getPostcondition().getActualParameters().size()];
            if (this.gtRule.getPostcondition().getActualParameters().size() > 0) {
                int i = 0;
                while (i < symSignatures.length) {
                    SymbolicRuleParameter symParam = (SymbolicRuleParameter)this.gtRule.getSymParameters().get(i);
                    if (symParam.getVariable().getReferences().size() > 0 && this.getActualParameterIndexofSymbolicParameter(this.gtRule.getPostcondition(), symParam) != -1) {
                        if (symSignatures[i].getParameterMode().compareTo((Enum)ParameterMode.INPUT) == 0) {
                            sig = new PatternCallSignature();
                            sig.setParameterMode(ParameterMode.INPUT);
                            rhsSignatures[this.getActualParameterIndexofSymbolicParameter((GTPatternCall)this.gtRule.getPostcondition(), (SymbolicRuleParameter)symParam)] = sig;
                        } else {
                            rhsSignatures[this.getActualParameterIndexofSymbolicParameter((GTPatternCall)this.gtRule.getPostcondition(), (SymbolicRuleParameter)symParam)] = symSignatures[i].clone();
                        }
                    }
                    ++i;
                }
            }
            for (GTElementMapping map : this.elementMappings) {
                if (rhsSignatures[map.getRhsInputOrderIndex()] == null) {
                    sig = new PatternCallSignature();
                    sig.setParameterMode(ParameterMode.INPUT);
                    rhsSignatures[map.getRhsInputOrderIndex()] = sig;
                    continue;
                }
                rhsSignatures[map.getRhsInputOrderIndex()].setParameterMode(ParameterMode.INPUT);
            }
            int j = 0;
            while (j < this.gtRule.getPostcondition().getActualParameters().size()) {
                if (rhsSignatures[j] == null) {
                    rhsSignatures[j] = new PatternCallSignature();
                    rhsSignatures[j].setParameterMode(ParameterMode.OUTPUT);
                }
                ++j;
            }
            try {
                GTOperationContext _temp = this.rightHandSideMatcher.generateGTOperation(this.elementMappings, rhsSignatures);
                this.nonchangeableGTOperations = _temp.getFinalOperations();
                this.checkSet = _temp.getCheckSet();
            }
            catch (GTRuleBuildingException e) {
                throw e.addNewStackElement((EObject)this.gtRule);
            }
        }
        this.leftHandSidePatternMatcher = this.getPatternMatcherforPreCondition();
        this.elementMappings = null;
        this.nonchangeableGTOperations = null;
    }

    public void initGTRule(IExecutionEnvironment actualEnvironment) throws ViatraTransformationException {
        this.gtEnvironment = actualEnvironment;
        this.handler = new BasicTermHandler(actualEnvironment);
        try {
            for (Object o : this.gtRule.getLocalVariables()) {
                this.gtEnvironment.addVariable((Variable)o, (Object)ValueKind.UNDEF_LITERAL);
            }
        }
        catch (ViatraTransformationException e) {
            throw e.addNewStackElement((EObject)this.gtRule);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object[] executeGTOperations(PatternCallSignature[] symSignatures, Object[] symInputMapping, IMatching lhsFrame) throws ViatraTransformationException {
        void var7_21;
        Object actualValue;
        Variable actualVariable;
        Object symParam;
        GTOperationContext actualGTContext = null;
        GTPatternCall preConditionCall = this.gtRule.getPrecondition();
        GTPatternCall postConditionCall = this.gtRule.getPostcondition();
        this.logger.debug("[debug] Starting GT rule: " + this.gtRule.getName());
        if (lhsFrame != null && postConditionCall != null) {
            PatternCallSignature sig;
            PatternCallSignature[] patternCallSignatureArray = new PatternCallSignature[postConditionCall.getActualParameters().size()];
            Object[] rhsInputMapping = new Object[postConditionCall.getActualParameters().size()];
            if (postConditionCall.getActualParameters().size() > 0) {
                int i = 0;
                while (i < symSignatures.length) {
                    SymbolicRuleParameter symParam2 = (SymbolicRuleParameter)this.gtRule.getSymParameters().get(i);
                    if (symParam2.getVariable().getReferences().size() > 0 && this.getActualParameterIndexofSymbolicParameter(postConditionCall, symParam2) != -1) {
                        rhsInputMapping[this.getActualParameterIndexofSymbolicParameter((GTPatternCall)postConditionCall, (SymbolicRuleParameter)symParam2)] = symInputMapping[i];
                        if (symSignatures[i].getParameterMode().compareTo((Enum)ParameterMode.INPUT) == 0) {
                            sig = new PatternCallSignature();
                            sig.setParameterMode(ParameterMode.INPUT);
                            sig.setParameterScope(new Scope());
                            patternCallSignatureArray[this.getActualParameterIndexofSymbolicParameter((GTPatternCall)postConditionCall, (SymbolicRuleParameter)symParam2)] = sig;
                        } else {
                            patternCallSignatureArray[this.getActualParameterIndexofSymbolicParameter((GTPatternCall)postConditionCall, (SymbolicRuleParameter)symParam2)] = symSignatures[i];
                        }
                    }
                    ++i;
                }
            }
            for (GTElementMapping map : this.elementMappings) {
                if (patternCallSignatureArray[map.getRhsInputOrderIndex()] == null) {
                    rhsInputMapping[map.getRhsInputOrderIndex()] = lhsFrame.lookup(map.getLhsInputOrderIndex());
                    sig = new PatternCallSignature();
                    sig.setParameterMode(ParameterMode.INPUT);
                    sig.setParameterScope(new Scope());
                    patternCallSignatureArray[map.getRhsInputOrderIndex()] = sig;
                    continue;
                }
                rhsInputMapping[map.getRhsInputOrderIndex()] = lhsFrame.lookup(map.getLhsInputOrderIndex());
                patternCallSignatureArray[map.getRhsInputOrderIndex()].setParameterMode(ParameterMode.INPUT);
            }
            int j = 0;
            while (j < postConditionCall.getActualParameters().size()) {
                if (patternCallSignatureArray[j] == null) {
                    patternCallSignatureArray[j] = new PatternCallSignature();
                    patternCallSignatureArray[j].setParameterMode(ParameterMode.OUTPUT);
                    patternCallSignatureArray[j].setParameterScope(new Scope());
                    rhsInputMapping[j] = ValueKind.UNDEF_LITERAL;
                }
                ++j;
            }
            try {
                MatchingFrame frame = this.rightHandSideMatcher.generateMatchingFrameofInputContext(this.elementMappings, rhsInputMapping, patternCallSignatureArray);
                actualGTContext = new GTOperationContext(frame, this.nonchangeableGTOperations, this.checkSet);
            }
            catch (GTRuleBuildingException e) {
                throw e.addNewStackElement((EObject)this.gtRule);
            }
        }
        if (lhsFrame != null && actualGTContext != null) {
            String[] context;
            this.logger.debug("GT Opeations of the GtRule: " + this.gtRule.getName());
            for (IUpdatePlanOperation iUpdatePlanOperation : actualGTContext.getFinalOperations()) {
                try {
                    if (iUpdatePlanOperation.update(actualGTContext.getReturnFrame())) {
                        this.logger.debug(iUpdatePlanOperation.toString(actualGTContext.getReturnFrame()));
                        continue;
                    }
                    context = new String[]{iUpdatePlanOperation.toString(actualGTContext.getReturnFrame()), this.gtRule.getName()};
                    GraphTransformationException e = new GraphTransformationException("The '{1}' model manipulation operation failed on the right hand side of the {2} gtRule.", context, iUpdatePlanOperation.getErrorfulElement(actualGTContext.getReturnFrame()));
                    e.addNewStackElement((EObject)postConditionCall.getCalledPattern());
                    throw e.addNewStackElement((EObject)this.gtRule);
                }
                catch (GTOperationException e) {
                    e.addNewStackElement((EObject)postConditionCall.getCalledPattern());
                    throw e.addNewStackElement((EObject)this.gtRule);
                }
            }
            for (ISearchPlanOperation iSearchPlanOperation : actualGTContext.getCheckSet()) {
                try {
                    iSearchPlanOperation.preprocess(actualGTContext.getReturnFrame());
                    if (iSearchPlanOperation.execute(actualGTContext.getReturnFrame())) continue;
                    context = new String[]{iSearchPlanOperation.toString(actualGTContext.getReturnFrame()), this.gtRule.getName()};
                    GraphTransformationException ex = new GraphTransformationException("The '{1}' consistency check operation failed on the right hand side of the {2} gtRule.", context, iSearchPlanOperation.getErrorfulElement(actualGTContext.getReturnFrame()));
                    ex.addNewStackElement((EObject)postConditionCall.getCalledPattern());
                    throw ex.addNewStackElement((EObject)this.gtRule);
                }
                catch (PatternMatcherRuntimeException e) {
                    e.addNewStackElement((EObject)postConditionCall.getCalledPattern());
                    throw e.addNewStackElement((EObject)this.gtRule);
                }
            }
        }
        if (this.gtRule.getAction() != null) {
            try {
                if (postConditionCall == null) {
                    void var7_13;
                    boolean bl = false;
                    while (var7_13 < symInputMapping.length) {
                        symParam = (SymbolicRuleParameter)this.gtRule.getSymParameters().get((int)var7_13);
                        if (this.getActualParameterIndexofSymbolicParameter(preConditionCall, (SymbolicRuleParameter)symParam) == -1) {
                            if (symParam.getVariable().getReferences().size() > 0) {
                                this.gtEnvironment.setVariableValue(symParam.getVariable(), symInputMapping[var7_13]);
                            } else {
                                this.logger.warning("SymbolicRuleParameter " + symParam.getName() + " in gtRule " + this.gtRule.getName() + "is never used");
                            }
                        }
                        ++var7_13;
                    }
                    for (Object e : this.gtRule.getLocalVariables()) {
                        actualVariable = (Variable)e;
                        if (this.getActualParameterIndexof(preConditionCall, actualVariable) == -1) continue;
                        actualValue = lhsFrame.lookup(this.getActualParameterIndexof(preConditionCall, actualVariable));
                        this.gtEnvironment.setVariableValue(actualVariable, this.returnValidValue(actualValue));
                    }
                } else {
                    void var7_16;
                    boolean bl = false;
                    while (var7_16 < symInputMapping.length) {
                        symParam = (SymbolicRuleParameter)this.gtRule.getSymParameters().get((int)var7_16);
                        if (this.getActualParameterIndexofSymbolicParameter(postConditionCall, (SymbolicRuleParameter)symParam) == -1 && this.getActualParameterIndexofSymbolicParameter(preConditionCall, (SymbolicRuleParameter)symParam) == -1) {
                            if (symParam.getVariable().getReferences().size() > 0) {
                                this.gtEnvironment.setVariableValue(symParam.getVariable(), symInputMapping[var7_16]);
                            } else {
                                this.logger.warning("SymbolicRuleParameter " + symParam.getName() + " in gtRule " + this.gtRule.getName() + "is never used");
                            }
                        }
                        ++var7_16;
                    }
                    for (Object e : this.gtRule.getLocalVariables()) {
                        actualVariable = (Variable)e;
                        if (this.getActualParameterIndexof(postConditionCall, actualVariable) != -1) {
                            actualValue = actualGTContext.getReturnFrame().getValue(this.getActualParameterIndexof(postConditionCall, actualVariable));
                            this.gtEnvironment.setVariableValue(actualVariable, this.returnValidValue(actualValue));
                            continue;
                        }
                        if (this.getActualParameterIndexof(preConditionCall, actualVariable) == -1) continue;
                        actualValue = lhsFrame.lookup(this.getActualParameterIndexof(preConditionCall, actualVariable));
                        this.gtEnvironment.setVariableValue(actualVariable, this.returnValidValue(actualValue));
                    }
                }
            }
            catch (ViatraTransformationException viatraTransformationException) {
                throw viatraTransformationException.addNewStackElement((EObject)this.gtRule);
            }
            try {
                RuleInterpreter.getInstance().interpretRule(this.gtEnvironment, this.gtRule.getAction(), null);
                return this.getOutPutSymbolicParatemerRules();
            }
            catch (ViatraTransformationException viatraTransformationException) {
                throw viatraTransformationException.addNewStackElement((EObject)this.gtRule);
            }
        }
        boolean bl = false;
        while (var7_21 < symInputMapping.length) {
            symParam = (SymbolicRuleParameter)this.gtRule.getSymParameters().get((int)var7_21);
            if (this.getActualParameterIndexofSymbolicParameter(postConditionCall, (SymbolicRuleParameter)symParam) == -1 && this.getActualParameterIndexofSymbolicParameter(preConditionCall, (SymbolicRuleParameter)symParam) == -1) {
                if (symParam.getVariable().getReferences().size() > 0) {
                    this.gtEnvironment.setVariableValue(symParam.getVariable(), symInputMapping[var7_21]);
                } else {
                    this.logger.warning("SymbolicRuleParameter " + symParam.getName() + " in gtRule " + this.gtRule.getName() + "is never used");
                }
            }
            ++var7_21;
        }
        if (postConditionCall != null && preConditionCall != null) {
            for (Object e : this.gtRule.getLocalVariables()) {
                actualVariable = (Variable)e;
                if (this.getActualParameterIndexof(postConditionCall, actualVariable) != -1) {
                    actualValue = actualGTContext.getReturnFrame().getValue(this.getActualParameterIndexof(postConditionCall, actualVariable));
                    this.gtEnvironment.setVariableValue(actualVariable, this.returnValidValue(actualValue));
                    continue;
                }
                if (this.getActualParameterIndexof(preConditionCall, actualVariable) == -1) continue;
                actualValue = lhsFrame.lookup(this.getActualParameterIndexof(preConditionCall, actualVariable));
                this.gtEnvironment.setVariableValue(actualVariable, this.returnValidValue(actualValue));
            }
        }
        return this.getOutPutSymbolicParatemerRules();
    }

    private Object returnValidValue(Object obj) {
        IModelElement element;
        if (obj == null) {
            return ValueKind.UNDEF_LITERAL;
        }
        if (obj instanceof IModelElement && (element = (IModelElement)obj).isDeleted()) {
            return ValueKind.UNDEF_LITERAL;
        }
        return obj;
    }

    public Object[] match(PatternCallSignature[] symSignatures, Object[] symInputMapping) throws ViatraTransformationException {
        IMatching lhsFrame;
        PatternMatcherParameters lhsParamters = this.initLHSPattern(symSignatures, symInputMapping, null);
        IMatching iMatching = lhsFrame = this.isRandom ? this.leftHandSidePatternMatcher.matchRandomly(lhsParamters.getInputMapping(), lhsParamters.getCallSignature()) : this.leftHandSidePatternMatcher.match(lhsParamters.getInputMapping(), lhsParamters.getCallSignature());
        if (lhsFrame != null) {
            return this.executeGTOperations(symSignatures, symInputMapping, lhsFrame);
        }
        return null;
    }

    public Collection<IMatching> initMatchAll(PatternCallSignature[] symSignatures, Object[] symInputMapping, Integer[] quantificationOrder) throws ViatraTransformationException {
        PatternMatcherParameters lhsParamters = this.initLHSPattern(symSignatures, symInputMapping, quantificationOrder);
        return this.leftHandSidePatternMatcher.matchAll(lhsParamters.getInputMapping(), lhsParamters.getCallSignature(), lhsParamters.getQuantificationOrder());
    }

    public Object[] matchAll(IMatching LHSMatching, PatternCallSignature[] symSignatures, Object[] symInputMapping) throws ViatraTransformationException {
        IMatching lhsFrame = LHSMatching;
        return this.executeGTOperations(symSignatures, symInputMapping, lhsFrame);
    }
}

