/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.AbstractTermCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.TermCheckExecutionEnvironment;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;

public class TermCheckOperation
extends AbstractTermCheckOperation {
    private IExecutionEnvironment parentEnv;
    private GTPattern pattern;
    private int uid;
    private Term term;

    public TermCheckOperation(IExecutionEnvironment parentEnv, GTPattern pattern, int uid, Term term) {
        this.parentEnv = parentEnv;
        this.pattern = pattern;
        this.uid = uid;
        this.term = term;
    }

    public boolean check(MatchingFrame frame) throws PatternMatcherRuntimeException {
        TermCheckExecutionEnvironment env = new TermCheckExecutionEnvironment(this.parentEnv, this.pattern, this.uid, frame);
        Boolean result = false;
        try {
            result = (Boolean)TermEvaluator.getInstance().evaluate((IExecutionEnvironment)env, this.term);
        }
        catch (ViatraTransformationException e) {
            throw new PatternMatcherRuntimeException(e, (AnnotatedElement)this.term);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.pattern.getName()};
            throw new PatternMatcherRuntimeException("The Check expression in the {1} pattern did not evaluate to a boolean", context, (AnnotatedElement)this.term);
        }
        return result;
    }

    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.term;
    }
}

