/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import java.util.Set;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.CheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableAssignmentCheckOperation
extends CheckOperation {
    private Integer source;
    private Integer target;
    private SearchGraphEdge relatedSearchGraphEdge;

    public VariableAssignmentCheckOperation(Integer source, Integer target, SearchGraphEdge edge) {
        this.source = source;
        this.target = target;
        this.relatedSearchGraphEdge = edge;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws PatternMatcherRuntimeException {
        IModelElement sourceElement = null;
        IModelElement targetElement = null;
        try {
            sourceElement = (IModelElement)frame.getValue(this.source);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, this.relatedSearchGraphEdge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            targetElement = (IModelElement)frame.getValue(this.target);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, this.relatedSearchGraphEdge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (sourceElement == null) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.relatedSearchGraphEdge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (targetElement == null) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.relatedSearchGraphEdge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        return sourceElement.equals(targetElement);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.source + " == " + this.target;
    }

    @Override
    public void calculateSidewaysPassedVariables(Set<Integer> variables) {
        variables.add(this.source);
        variables.add(this.target);
    }

    @Override
    public void calculateLocalVariables(Set<Integer> variables) {
        variables.add(this.source);
        variables.add(this.target);
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.relatedSearchGraphEdge.getTraceabilityElement().getRepresentativeEMFElement();
    }
}

