/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Vector;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.IKeyGenerator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingKey;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.Goal;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.HistoryList;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.IndexedRule;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.MagicSet;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.Rule;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.UnindexedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteGoal
extends Goal
implements Iterable<MatchingFrame> {
    protected String id;
    protected PatternNode pattern;
    private Vector<Rule> children;
    private Vector<Queue<MatchingFrame>> queues;
    private Map<MatchingKey, List<MatchingFrame>> mapWithAdornedIndex;
    private Map<MatchingKey, List<MatchingFrame>> map;
    private Queue<MatchingFrame> newFrames;
    protected MagicSet ms;
    protected Boolean[] adornment;
    protected IKeyGenerator<MatchingKey, IMatching> adornedKeyGenerator;
    protected IKeyGenerator<MatchingKey, IMatching> keyGenerator;

    public RemoteGoal(PatternNode pattern, Boolean[] adornment) {
        this.pattern = pattern;
        this.id = RemoteGoal.generateID(pattern, adornment);
        this.children = new Vector();
        this.queues = new Vector();
        this.newFrames = new LinkedList<MatchingFrame>();
        this.adornment = adornment;
        this.mapWithAdornedIndex = new HashMap<MatchingKey, List<MatchingFrame>>();
        this.map = new HashMap<MatchingKey, List<MatchingFrame>>();
        this.ms = new MagicSet(adornment);
        Vector<Integer> adornedVector = new Vector<Integer>();
        Vector<Integer> vector = new Vector<Integer>();
        int i = 0;
        while (i < adornment.length) {
            if (adornment[i].booleanValue()) {
                adornedVector.add(i);
            }
            vector.add(i);
            ++i;
        }
        final Integer[] key1 = new Integer[adornedVector.size()];
        adornedVector.toArray(key1);
        this.adornedKeyGenerator = new IKeyGenerator<MatchingKey, IMatching>(){

            @Override
            public MatchingKey calculateKey(IMatching value) {
                Object[] matchingKey = new Object[key1.length];
                int i = 0;
                while (i < key1.length) {
                    matchingKey[i] = value.lookup(key1[i].intValue());
                    ++i;
                }
                return new MatchingKey(matchingKey);
            }

            @Override
            public int size() {
                return key1.length;
            }
        };
        final Integer[] key2 = new Integer[vector.size()];
        vector.toArray(key2);
        this.keyGenerator = new IKeyGenerator<MatchingKey, IMatching>(){

            @Override
            public MatchingKey calculateKey(IMatching value) {
                Object[] matchingKey = new Object[key2.length];
                int i = 0;
                while (i < key2.length) {
                    matchingKey[i] = value.lookup(key2[i].intValue());
                    ++i;
                }
                return new MatchingKey(matchingKey);
            }

            @Override
            public int size() {
                return key2.length;
            }
        };
    }

    public static String generateID(PatternNode pattern, Boolean[] adornment) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < adornment.length) {
            b.append(adornment[i] != false ? (char)'b' : 'f');
            ++i;
        }
        return String.valueOf(pattern.getPattern().getName()) + "^" + b.toString();
    }

    public void calculateAllDeltas(IndexedRule parent, Queue<MatchingFrame> output) throws PatternMatcherRuntimeException {
        HistoryList<MatchingKey, MatchingFrame> input = parent.getQueue();
        Iterator i = input.iterator();
        while (i.hasNext()) {
            MatchingFrame leftFrame = (MatchingFrame)i.next();
            MatchingKey keyForLeftFrame = parent.getBoundHeader(leftFrame);
            List<MatchingFrame> list = this.mapWithAdornedIndex.get(keyForLeftFrame);
            if (list != null) {
                for (MatchingFrame rightFrame : list) {
                    MatchingFrame newFrame = (MatchingFrame)leftFrame.clone();
                    parent.merge(newFrame, rightFrame);
                    output.offer(newFrame);
                }
            }
            this.ms.addArray(keyForLeftFrame);
            i.remove();
        }
        for (MatchingFrame rightFrame : this.newFrames) {
            Vector<Object> v = new Vector<Object>();
            int size = 0;
            int i2 = 0;
            while (i2 < this.adornment.length) {
                if (this.adornment[i2].booleanValue()) {
                    v.add(rightFrame.getValue(i2));
                    ++size;
                }
                ++i2;
            }
            Object[] key = new Object[size];
            v.toArray(key);
            HistoryList<MatchingKey, MatchingFrame> queue = parent.getQueue();
            List<MatchingFrame> list = queue.get(new MatchingKey(key));
            if (list == null) continue;
            for (MatchingFrame leftFrame : list) {
                MatchingFrame newFrame = (MatchingFrame)leftFrame.clone();
                parent.merge(newFrame, rightFrame);
                output.offer(newFrame);
            }
        }
    }

    public MagicSet getMagicSet() {
        return this.ms;
    }

    public void addChild(Rule child, Queue<MatchingFrame> queue) {
        this.children.add(child);
        this.queues.add(queue);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof RemoteGoal) {
            RemoteGoal rg = (RemoteGoal)other;
            return this.id.equals(rg.id);
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    public boolean synchronize() throws ViatraTransformationException {
        boolean result = false;
        Iterator i = this.newFrames.iterator();
        while (i.hasNext()) {
            MatchingFrame frame = (MatchingFrame)i.next();
            MatchingKey keyForFrame = this.adornedKeyGenerator.calculateKey(frame);
            List<MatchingFrame> currentList = this.mapWithAdornedIndex.get(keyForFrame);
            if (currentList == null) {
                currentList = new LinkedList<MatchingFrame>();
            }
            currentList.add(frame);
            this.mapWithAdornedIndex.put(keyForFrame, currentList);
            i.remove();
        }
        assert (this.newFrames.isEmpty());
        for (Queue<MatchingFrame> queue : this.queues) {
            Iterator i2 = queue.iterator();
            while (i2.hasNext()) {
                MatchingFrame frame = (MatchingFrame)i2.next();
                MatchingKey keyForFrame = this.keyGenerator.calculateKey(frame);
                List<MatchingFrame> currentList = this.map.get(keyForFrame);
                if (currentList == null) {
                    currentList = new LinkedList<MatchingFrame>();
                    this.newFrames.add(frame);
                    result = true;
                }
                currentList.add(frame);
                this.map.put(keyForFrame, currentList);
                i2.remove();
            }
        }
        for (Rule rule : this.children) {
            rule.synchronize();
        }
        return this.ms.synchronizeFromGoal() ? true : result;
    }

    public void init() {
        this.ms.init();
        this.map.clear();
        this.mapWithAdornedIndex.clear();
        for (Queue<MatchingFrame> queue : this.queues) {
            queue.clear();
        }
        this.newFrames.clear();
        for (Rule r : this.children) {
            r.init();
        }
    }

    public void matchAll() throws PatternMatcherRuntimeException {
        assert (this.children.size() == this.queues.size());
        int i = 0;
        while (i < this.children.size()) {
            Rule rule = this.children.get(i);
            MatchingFrame template = new MatchingFrame(rule.pattern);
            rule.traverseAll(this.queues.get(i), template);
            ++i;
        }
    }

    @Override
    public Iterator<MatchingFrame> iterator() {
        return new ResultFrameIterator();
    }

    public void debug() {
        for (Rule rule : this.children) {
            if (!(rule instanceof UnindexedRule)) continue;
            ((UnindexedRule)rule).debug();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultFrameIterator
    implements Iterator<MatchingFrame> {
        Iterator<List<MatchingFrame>> listIterator;
        Iterator<MatchingFrame> frameIterator;

        private ResultFrameIterator() {
            this.listIterator = RemoteGoal.this.map.values().iterator();
            this.frameIterator = this.listIterator.hasNext() ? this.listIterator.next().iterator() : null;
        }

        @Override
        public boolean hasNext() {
            while (this.frameIterator != null && !this.frameIterator.hasNext()) {
                Iterator<MatchingFrame> iterator = this.frameIterator = this.listIterator.hasNext() ? this.listIterator.next().iterator() : null;
            }
            return this.frameIterator != null;
        }

        @Override
        public MatchingFrame next() {
            if (this.hasNext()) {
                return this.frameIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

