/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.IDbgpService;
import org.eclipse.dltk.mod.debug.core.IDebugOptions;
import org.eclipse.dltk.mod.debug.core.model.DefaultDebugOptions;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugTargetListener;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.mod.debug.core.model.IScriptThread;
import org.eclipse.dltk.mod.debug.core.model.IScriptVariable;
import org.eclipse.dltk.mod.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptBreakpointPathMapper;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptThreadManager;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptThreadManagerListener;
import org.eclipse.dltk.mod.internal.debug.core.model.NopScriptbreakpointPathMapper;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptBreakpointManager;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptThreadManager;

public class ScriptDebugTarget
extends ScriptDebugElement
implements IScriptDebugTarget,
IScriptThreadManagerListener {
    private static final String LAUNCH_CONFIGURATION_ATTR_PROJECT = "project";
    private static final String LAUNCH_CONFIGURATION_ATTR_BREAK_ON_FIRST_LINE = "enableBreakOnFirstLine";
    private static final int THREAD_TERMINATION_TIMEOUT = 5000;
    private final ListenerList listeners;
    private IScriptStreamProxy streamProxy;
    private IProcess process;
    private final ILaunch launch;
    private String name;
    private boolean disconnected;
    private final IScriptThreadManager threadManager;
    private final ScriptBreakpointManager breakpointManager;
    private final IDbgpService dbgpService;
    private final String sessionId;
    private final String modelId;
    private static final WeakHashMap targets = new WeakHashMap();
    private String[] stepFilters;
    private boolean useStepFilters;
    private final Object processLock = new Object();
    private boolean initialized = false;
    private boolean retrieveGlobalVariables;
    private boolean retrieveClassVariables;
    private boolean retrieveLocalVariables;
    private final IDebugOptions options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllTargets() {
        WeakHashMap weakHashMap = targets;
        synchronized (weakHashMap) {
            return new ArrayList(targets.keySet());
        }
    }

    public ScriptDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process) {
        this(modelId, dbgpService, sessionId, launch, process, DefaultDebugOptions.getDefaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process, IDebugOptions options) {
        Assert.isNotNull((Object)options);
        this.modelId = modelId;
        this.listeners = new ListenerList();
        this.process = process;
        this.launch = launch;
        this.options = options;
        this.threadManager = new ScriptThreadManager(this);
        this.sessionId = sessionId;
        this.dbgpService = dbgpService;
        this.dbgpService.registerAcceptor(this.sessionId, this.threadManager);
        this.disconnected = false;
        this.breakpointManager = new ScriptBreakpointManager(this, this.createPathMapper());
        this.threadManager.addListener(this);
        DebugEventHelper.fireCreateEvent(this);
        WeakHashMap weakHashMap = targets;
        synchronized (weakHashMap) {
            targets.put(this, "");
        }
    }

    public void shutdown() {
        try {
            this.terminate(true);
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public String getModelIdentifier() {
        return this.modelId;
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcess getProcess() {
        Object object = this.processLock;
        synchronized (object) {
            return this.process;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcess(IProcess process) {
        Object object = this.processLock;
        synchronized (object) {
            this.process = process;
        }
    }

    public boolean hasThreads() {
        return this.threadManager.hasThreads();
    }

    public IThread[] getThreads() {
        return this.threadManager.getThreads();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canTerminate() {
        Object object = this.processLock;
        synchronized (object) {
            return this.threadManager.canTerminate() || this.process != null && this.process.canTerminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.processLock;
        synchronized (object) {
            return this.threadManager.isTerminated() && (this.process == null || this.process.isTerminated());
        }
    }

    protected static boolean waitTermianted(ITerminate terminate, int chunk, long timeout) {
        long start = System.currentTimeMillis();
        while (!terminate.isTerminated()) {
            if (System.currentTimeMillis() - start > timeout) {
                return false;
            }
            try {
                Thread.sleep(chunk);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public void terminate() throws DebugException {
        this.terminate(true);
    }

    protected void terminate(boolean waitTermination) throws DebugException {
        this.dbgpService.unregisterAcceptor(this.sessionId);
        this.threadManager.sendTerminationRequest();
        if (waitTermination) {
            IProcess p = this.getProcess();
            if ((!ScriptDebugTarget.waitTermianted(this.threadManager, 500, 5000L) || p != null && !ScriptDebugTarget.waitTermianted((ITerminate)p, 500, 5000L)) && p != null && p.canTerminate()) {
                p.terminate();
            }
        }
        this.threadManager.removeListener(this);
        this.breakpointManager.threadTerminated();
        DebugEventHelper.fireTerminateEvent(this);
    }

    public boolean canSuspend() {
        return this.threadManager.canSuspend();
    }

    public boolean isSuspended() {
        return this.threadManager.isSuspended();
    }

    public void suspend() throws DebugException {
        this.threadManager.suspend();
    }

    public boolean canResume() {
        return this.threadManager.canResume();
    }

    public void resume() throws DebugException {
        this.threadManager.resume();
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() {
        this.disconnected = true;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) {
        return null;
    }

    public IScriptVariable findVariable(String variableName) {
        return null;
    }

    @Override
    public int getRequestTimeout() {
        return 0;
    }

    @Override
    public void setRequestTimeout(int timeout) {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.breakpointManager.breakpointAdded(breakpoint);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointChanged(breakpoint, delta);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointRemoved(breakpoint, delta);
    }

    @Override
    public IScriptStreamProxy getStreamProxy() {
        return this.streamProxy;
    }

    @Override
    public void setStreamProxy(IScriptStreamProxy proxy) {
        this.streamProxy = proxy;
    }

    @Override
    public void threadAccepted(IScriptThread thread, boolean first) {
        if (first) {
            DebugEventHelper.fireExtendedEvent(this, 2);
            this.breakpointManager.setupDeferredBreakpoints();
            this.breakpointManager.threadAccepted();
            this.initialized = true;
            this.fireTargetInitialized();
        }
    }

    protected IScriptBreakpointPathMapper createPathMapper() {
        return new NopScriptbreakpointPathMapper();
    }

    @Override
    public void allThreadsTerminated() {
        try {
            if (this.streamProxy != null) {
                this.streamProxy.close();
            }
            this.terminate(false);
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public String toString() {
        return "Debugging engine (id = " + this.sessionId + ")";
    }

    @Override
    public void runToLine(URI uri, int lineNumber) throws DebugException {
        this.breakpointManager.setBreakpointUntilFirstSuspend(uri, lineNumber);
        this.resume();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    protected void fireTargetInitialized() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptDebugTargetListener)list[i]).targetInitialized();
            ++i;
        }
    }

    @Override
    public void addListener(IScriptDebugTargetListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IScriptDebugTargetListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.breakpointManager.supportsBreakpoint(breakpoint);
    }

    @Override
    public void setFilters(String[] activeFilters) {
        this.stepFilters = activeFilters;
    }

    @Override
    public String[] getFilters() {
        if (this.stepFilters != null) {
            return this.stepFilters;
        }
        return new String[0];
    }

    @Override
    public boolean isUseStepFilters() {
        return this.useStepFilters;
    }

    @Override
    public void setUseStepFilters(boolean useStepFilters) {
        this.useStepFilters = useStepFilters;
    }

    @Override
    public IDLTKLanguageToolkit getLanguageToolkit() {
        IScriptProject scriptProject = this.getScriptProject();
        if (scriptProject != null) {
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)scriptProject);
            return toolkit;
        }
        return null;
    }

    protected IScriptProject getScriptProject() {
        block4: {
            ILaunchConfiguration configuration = this.launch.getLaunchConfiguration();
            if (configuration != null) {
                try {
                    String projectName = configuration.getAttribute(LAUNCH_CONFIGURATION_ATTR_PROJECT, null);
                    if (projectName != null && (projectName = projectName.trim()).length() > 0) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        return DLTKCore.create((IProject)project);
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public boolean breakOnFirstLineEnabled() {
        try {
            return this.launch.getLaunchConfiguration().getAttribute(LAUNCH_CONFIGURATION_ATTR_BREAK_ON_FIRST_LINE, false);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public void toggleGlobalVariables(boolean enabled) {
        this.retrieveGlobalVariables = enabled;
        this.threadManager.refreshThreads();
    }

    @Override
    public void toggleClassVariables(boolean enabled) {
        this.retrieveClassVariables = enabled;
        this.threadManager.refreshThreads();
    }

    @Override
    public void toggleLocalVariables(boolean enabled) {
        this.retrieveLocalVariables = enabled;
        this.threadManager.refreshThreads();
    }

    @Override
    public boolean retrieveClassVariables() {
        return this.retrieveClassVariables;
    }

    @Override
    public boolean retrieveGlobalVariables() {
        return this.retrieveGlobalVariables;
    }

    @Override
    public boolean retrieveLocalVariables() {
        return this.retrieveLocalVariables;
    }

    @Override
    public String getConsoleEncoding() {
        String encoding = "UTF-8";
        try {
            encoding = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", encoding);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return encoding;
    }

    public void setScriptDebugThreadConfigurator(IScriptDebugThreadConfigurator configurator) {
        this.threadManager.setScriptThreadConfigurator(configurator);
    }

    @Override
    public IDebugOptions getOptions() {
        return this.options;
    }
}

