/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.scriptdoc;

class Alignment {
    public String name;
    public Alignment enclosing;
    public int fragmentIndex;
    public int fragmentCount;
    public int[] fragmentIndentations;
    public boolean needRedoColumnAlignment;
    public int chunkStartIndex;
    public int chunkKind;
    public int originalIndentationLevel;
    public int breakIndentationLevel;
    public int shiftBreakIndentationLevel;
    public int[] fragmentBreaks;
    public boolean wasSplit;
    public static final int M_FORCE = 1;
    public static final int M_INDENT_ON_COLUMN = 2;
    public static final int M_INDENT_BY_ONE = 4;
    public static final int M_COMPACT_SPLIT = 16;
    public static final int M_COMPACT_FIRST_BREAK_SPLIT = 32;
    public static final int M_ONE_PER_LINE_SPLIT = 48;
    public static final int M_NEXT_SHIFTED_SPLIT = 64;
    public static final int M_NEXT_PER_LINE_SPLIT = 80;
    public static final int M_MULTICOLUMN = 256;
    public static final int M_NO_ALIGNMENT = 0;
    public int mode;
    public static final int SPLIT_MASK = 112;
    public static final int R_OUTERMOST = 1;
    public static final int R_INNERMOST = 2;
    public int tieBreakRule;
    public static final int NONE = 0;
    public static final int BREAK = 1;
    public static final int CHUNK_FIELD = 1;
    public static final int CHUNK_METHOD = 2;
    public static final int CHUNK_TYPE = 3;
    public static final int CHUNK_ENUM = 4;

    Alignment() {
    }

    public boolean couldBreak() {
        switch (this.mode & 0x70) {
            case 32: {
                if (this.fragmentBreaks[0] == 0) {
                    this.fragmentBreaks[0] = 1;
                    this.fragmentIndentations[0] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                }
                int i = this.fragmentIndex;
                do {
                    if (this.fragmentBreaks[i] != 0) continue;
                    this.fragmentBreaks[i] = 1;
                    this.fragmentIndentations[i] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                } while (--i >= 0);
                break;
            }
            case 16: {
                int i = this.fragmentIndex;
                do {
                    if (this.fragmentBreaks[i] != 0) continue;
                    this.fragmentBreaks[i] = 1;
                    this.fragmentIndentations[i] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                } while (--i >= 0);
                break;
            }
            case 64: {
                if (this.fragmentBreaks[0] != 0) break;
                this.fragmentBreaks[0] = 1;
                this.fragmentIndentations[0] = this.breakIndentationLevel;
                int i = 1;
                while (i < this.fragmentCount) {
                    this.fragmentBreaks[i] = 1;
                    this.fragmentIndentations[i] = this.shiftBreakIndentationLevel;
                    ++i;
                }
                this.wasSplit = true;
                return true;
            }
            case 48: {
                if (this.fragmentBreaks[0] == 0) {
                    int i = 0;
                    while (i < this.fragmentCount) {
                        this.fragmentBreaks[i] = 1;
                        this.fragmentIndentations[i] = this.breakIndentationLevel;
                        ++i;
                    }
                    this.wasSplit = true;
                    return true;
                }
            }
            case 80: {
                if (this.fragmentBreaks[0] != 0 || this.fragmentCount <= 1 || this.fragmentBreaks[1] != 0) break;
                if ((this.mode & 2) != 0) {
                    this.fragmentIndentations[0] = this.breakIndentationLevel;
                }
                int i = 1;
                while (i < this.fragmentCount) {
                    this.fragmentBreaks[i] = 1;
                    this.fragmentIndentations[i] = this.breakIndentationLevel;
                    ++i;
                }
                this.wasSplit = true;
                return true;
            }
        }
        return false;
    }

    public Alignment getAlignment(String targetName) {
        if (targetName.equals(this.name)) {
            return this;
        }
        if (this.enclosing == null) {
            return null;
        }
        return this.enclosing.getAlignment(targetName);
    }

    public void performFragmentEffect() {
        if ((this.mode & 0x100) == 0) {
            switch (this.mode & 0x70) {
                case 16: 
                case 32: 
                case 48: 
                case 64: 
                case 80: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void reset() {
        if (this.fragmentCount > 0) {
            this.fragmentIndentations = new int[this.fragmentCount];
            this.fragmentBreaks = new int[this.fragmentCount];
        }
        if ((this.mode & 1) != 0) {
            this.couldBreak();
        }
    }

    public void toFragmentsString(StringBuffer buffer) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(this.getClass().getName()).append(':').append("<name: ").append(this.name).append(">");
        if (this.enclosing != null) {
            buffer.append("<enclosingName: ").append(this.enclosing.name).append('>');
        }
        buffer.append('\n');
        int i = 0;
        while (i < this.fragmentCount) {
            buffer.append(" - fragment ").append(i).append(": ").append("<break: ").append(this.fragmentBreaks[i] > 0 ? "YES" : "NO").append(">").append("<indent: ").append(this.fragmentIndentations[i]).append(">\n");
            ++i;
        }
        buffer.append('\n');
        return buffer.toString();
    }

    public void update() {
        int i = 1;
        while (i < this.fragmentCount) {
            if (this.fragmentBreaks[i] == 1) {
                this.fragmentIndentations[i] = this.breakIndentationLevel;
            }
            ++i;
        }
    }

    public boolean isWrapped() {
        int i = 0;
        int max = this.fragmentCount;
        while (i < max) {
            if (this.fragmentBreaks[i] == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

