/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.eclipse.internal.ui.editor.EditorHighlightingSynchronizer;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.CompletionProposal;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class MethodCompletionProposal
extends CompletionProposal {
    private IRegion fSelectedRegion = null;

    public MethodCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition);
    }

    public MethodCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, IJstMethod method) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, method);
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            this.fSelectedRegion = this.getSelectedRegion(document);
        }
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    protected IRegion getSelectedRegion(IDocument document) {
        Region fSelectedRegion = null;
        int baseOffset = this.getReplacementOffset();
        String replacement = this.getReplacementString();
        int[][] argInfo = this.genArgInfo(replacement);
        if (argInfo != null && this.getTextViewer() != null) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != argInfo.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + argInfo[i][0], argInfo[i][1], -1));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                VjoEditor editor = this.getVjoEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new CompletionProposal.ExitPolicy(')', document));
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                VjetUIPlugin.log((Exception)((Object)e));
            }
        } else {
            fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
        }
        return fSelectedRegion;
    }

    @Override
    public int getContextInformationPosition() {
        if (this.fSelectedRegion != null) {
            return this.fSelectedRegion.getOffset();
        }
        return super.getContextInformationPosition();
    }

    private int[][] genArgInfo(String replaceString) {
        int begin = replaceString.indexOf("(");
        int end = replaceString.indexOf(")");
        if (end == -1 || begin == -1 || end < begin) {
            return null;
        }
        int offset = begin + 1;
        String argStr = replaceString.substring(offset, end);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int index = 0;
        index = argStr.indexOf(",");
        while (index != -1) {
            list.add(index);
            index = argStr.indexOf(",", index + 1);
        }
        int length = list.size();
        if (length == 0) {
            return new int[][]{{offset, argStr.length()}};
        }
        int[][] result = new int[length + 1][2];
        result[0][0] = offset;
        int i = 0;
        while (i < length) {
            int temp = (Integer)list.get(i);
            result[i][1] = offset + temp - result[i][0];
            result[i + 1][0] = offset + temp + 1;
            ++i;
        }
        result[length][1] = offset + argStr.length() - result[length][0];
        return result;
    }

    private int getBegin(String sub) {
        int i = 0;
        while (i < sub.length()) {
            if (!Character.isWhitespace(sub.charAt(i))) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

