/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.typespace;

import java.util.Map;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

class TypespaceTreeLabelProvider
extends LabelProvider {
    static ISharedImages s_images = DLTKUIPlugin.getDefault().getWorkbench().getSharedImages();
    static ImageDescriptorRegistry s_fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();

    TypespaceTreeLabelProvider() {
    }

    public String getText(Object element) {
        if (element instanceof IGroup) {
            int size = ((IGroup)element).getEntities().values().size();
            return String.valueOf(((IGroup)element).getName()) + "(" + size + ")";
        }
        if (element instanceof IJstType) {
            IJstType jstType = (IJstType)element;
            return String.valueOf(this.getJstNodeLabel((IJstNode)jstType)) + " " + this.getEntityKey(jstType);
        }
        if (element instanceof IJstNode) {
            return this.getJstNodeLabel((IJstNode)element);
        }
        return element.toString();
    }

    private String getEntityKey(IJstType jstType) {
        Group group = TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr().getTypeSpace().getGroup((Object)jstType);
        for (Map.Entry entry : group.getEntities().entrySet()) {
            if (entry.getValue() != jstType) continue;
            return "[entity key = " + entry.getKey() + "]";
        }
        return "";
    }

    private String getJstNodeLabel(IJstNode jstNode) {
        return String.valueOf(this.getName(jstNode)) + this.getSourceRange(jstNode);
    }

    private String getName(IJstNode jstNode) {
        String simpleName = jstNode.getClass().getSimpleName();
        if (jstNode instanceof IJstType) {
            return String.valueOf(simpleName) + ":" + ((IJstType)jstNode).getName();
        }
        if (jstNode instanceof IJstMethod) {
            return String.valueOf(simpleName) + ":" + ((IJstMethod)jstNode).getName();
        }
        if (jstNode instanceof IJstProperty) {
            return String.valueOf(simpleName) + ":" + ((IJstProperty)jstNode).getName();
        }
        if (jstNode instanceof JstVar) {
            return String.valueOf(simpleName) + ":" + ((JstVar)jstNode).getName();
        }
        if (jstNode instanceof JstIdentifier) {
            return String.valueOf(simpleName) + ":" + ((JstIdentifier)jstNode).getName();
        }
        return simpleName;
    }

    private String getSourceRange(IJstNode jstNode) {
        JstSource jstSource = jstNode.getSource();
        if (jstSource != null) {
            return "[" + jstSource.getStartOffSet() + "," + jstSource.getEndOffSet() + "]";
        }
        return "";
    }

    public Image getImage(Object element) {
        if (element instanceof IGroup) {
            IGroup group = (IGroup)element;
            String groupName = group.getName();
            if (CodeassistUtils.isBinaryPath((String)groupName)) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.library_obj.gif");
            }
            if (CodeassistUtils.isNativeGroup((String)groupName)) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.library_obj.gif");
            }
            return TypespaceTreeLabelProvider.getImageFromIDEImage("IMG_OBJ_PROJECT");
        }
        if (element instanceof IJstNode) {
            return this.getJstNodeImage((IJstNode)element);
        }
        return super.getImage(element);
    }

    private Image getJstNodeImage(IJstNode jstNode) {
        if (jstNode instanceof IJstType) {
            IJstType type = (IJstType)jstNode;
            if (type.isInterface()) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.int_obj.gif");
            }
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.class_obj.gif");
        }
        if (jstNode instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)jstNode;
            JstModifiers modifiers = method.getModifiers();
            if (modifiers.isPrivate()) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpri_obj.gif");
            }
            if (modifiers.isProtected()) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpro_obj.gif");
            }
            if (modifiers.isPublic()) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpub_obj.gif");
            }
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methdef_obj.gif");
        }
        if (jstNode instanceof IJstProperty) {
            IJstProperty property = (IJstProperty)jstNode;
            if (property.getModifiers().isPrivate()) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.field_private_obj.gif");
            }
            if (property.getModifiers().isProtected()) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.field_protected_obj.gif");
            }
            if (property.getModifiers().isPublic()) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.field_public_obj.gif");
            }
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.field_default_obj.gif");
        }
        if (jstNode instanceof JstVar) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.localvariable_obj.gif");
        }
        if (jstNode instanceof JstIdentifier) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.field_default_obj.gif");
        }
        if (jstNode instanceof JstTypeReference) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.imp_obj.gif");
        }
        return null;
    }

    static Image getImageFromIDEImage(String imageId) {
        return s_fRegistry.get(s_images.getImageDescriptor(imageId));
    }
}

