/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.text.completion;

import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.ScriptElementImageProvider;
import org.eclipse.dltk.mod.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.FieldOrMethodCompletionHandler;
import org.eclipse.vjet.eclipse.core.IJSMethod;
import org.eclipse.vjet.eclipse.ui.VjoElementImageDescriptor;
import org.eclipse.vjet.eclipse.ui.VjoElementImageProvider;

public class VjoCompletionProposalLabelProvider
extends CompletionProposalLabelProvider {
    private static final char COMMA = ',';
    private static final String SPACE = " ";

    protected ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(VjoElementImageProvider.getTypeImageDescriptor(flags, false), proposal);
    }

    public ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        int adornments = ScriptElementImageProvider.computeAdornmentFlags((IModelElement)proposal.getModelElement(), (int)3);
        if (proposal.isConstructor()) {
            adornments |= 0x200;
        }
        return new VjoElementImageDescriptor(descriptor, adornments, VjoElementImageProvider.SMALL_SIZE);
    }

    protected String createSimpleLabelWithType(CompletionProposal proposal) {
        StringBuffer nameBuffer = new StringBuffer();
        String name = super.createSimpleLabelWithType(proposal);
        nameBuffer.append(name);
        if (proposal.extraInfo != null && proposal.extraInfo instanceof String) {
            nameBuffer.append(SPACE);
            nameBuffer.append(proposal.extraInfo);
        }
        return nameBuffer.toString();
    }

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        String name = super.createMethodProposalLabel(methodProposal);
        nameBuffer.append(name);
        if (methodProposal.extraInfo != null && methodProposal.extraInfo instanceof String) {
            nameBuffer.append(SPACE);
            nameBuffer.append(methodProposal.extraInfo);
        }
        return nameBuffer.toString();
    }

    public String createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        StringBuffer nameBuffer = new StringBuffer();
        String name = super.createLabelWithTypeAndDeclaration(proposal);
        nameBuffer.append(name);
        if (proposal.extraInfo != null && proposal.extraInfo instanceof String) {
            nameBuffer.append(SPACE);
            nameBuffer.append(proposal.extraInfo);
        }
        return nameBuffer.toString();
    }

    protected String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        char[][] parameterNames = methodProposal.findParameterNames(null);
        char[][] parameterTypes = null;
        String returnType = null;
        String inType = null;
        if (methodProposal.extraInfo != null && methodProposal.extraInfo instanceof FieldOrMethodCompletionHandler.MethodCompletionExtraInfo) {
            FieldOrMethodCompletionHandler.MethodCompletionExtraInfo info = (FieldOrMethodCompletionHandler.MethodCompletionExtraInfo)methodProposal.extraInfo;
            if (info.parameterTypes != null) {
                parameterTypes = new char[info.parameterTypes.length][];
                int i = 0;
                while (i < info.parameterTypes.length) {
                    parameterTypes[i] = info.parameterTypes[i].toCharArray();
                    ++i;
                }
            }
            returnType = info.returnType;
            inType = info.inType;
        }
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        if (parameterTypes != null && parameterNames != null && parameterNames.length == parameterTypes.length) {
            this.appendParameterSignature(nameBuffer, parameterTypes, parameterNames);
        }
        nameBuffer.append(")  ");
        nameBuffer.append(returnType);
        nameBuffer.append(" - ");
        nameBuffer.append("Override method in '").append(inType).append("'");
        return nameBuffer.toString();
    }

    protected StringBuffer appendUnboundedParameterList(StringBuffer buffer, CompletionProposal methodProposal) {
        StringBuffer buff = buffer;
        IModelElement element = methodProposal.getModelElement();
        buff = element instanceof IJSMethod ? this.appendUnboundedParameterList(buffer, element) : super.appendUnboundedParameterList(buffer, methodProposal);
        return buff;
    }

    private StringBuffer appendUnboundedParameterList(StringBuffer buffer, IModelElement element) {
        IJSMethod method = (IJSMethod)element;
        try {
            buffer = this.appendUnboundedParameterList(buffer, method);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    private StringBuffer appendUnboundedParameterList(StringBuffer buffer, IJSMethod method) throws ModelException {
        String[] names = method.getParameters();
        String[] types = method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buffer.append(',');
                buffer.append(SPACE);
            }
            buffer.append(types[i]);
            buffer.append(SPACE);
            buffer.append(names[i]);
            ++i;
        }
        return buffer;
    }
}

