/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.statistics.DarwinStatisticsCtxHelper;
import org.eclipse.vjet.dsf.css.CssClassConstant;
import org.eclipse.vjet.dsf.css.CssIdConstant;
import org.eclipse.vjet.dsf.css.dom.impl.DCssStyleDeclaration;
import org.eclipse.vjet.dsf.dom.Associator;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.support.Jif;
import org.eclipse.vjet.dsf.html.ctx.HtmlCtx;
import org.eclipse.vjet.dsf.html.dom.DBr;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.events.EventHandlerAttacher;
import org.eclipse.vjet.dsf.html.events.EventHandlerContainer;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.IDomEventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class BaseHtmlElement
extends DElement {
    private static final long serialVersionUID = 3833188025499792690L;
    public static final String DIR_LTR = "ltr";
    public static final String DIR_RTL = "rtl";

    protected BaseHtmlElement(HtmlTypeEnum type) {
        this(null, type);
    }

    protected BaseHtmlElement(DHtmlDocument doc, HtmlTypeEnum type) {
        super((DDocument)doc, type.getName());
        if (type != this.htmlType()) {
            throw new DsfRuntimeException("type is not consistent with htmlType() mehtod.");
        }
    }

    public NodeList getElementsByTagName(HtmlTypeEnum htmlType) {
        return this.getElementsByTagName(htmlType.getName());
    }

    public NodeList getElementsByTagName(String tagName) {
        return super.getElementsByTagName(tagName.toLowerCase());
    }

    public abstract HtmlTypeEnum htmlType();

    public String getHtmlAccessKey() {
        return this.getHtmlAttribute(EHtmlAttr.accesskey);
    }

    public BaseHtmlElement setHtmlAccessKey(String accesskey) {
        this.setHtmlAttribute(EHtmlAttr.accesskey, accesskey);
        return this;
    }

    public String getHtmlClassName() {
        return this.getHtmlAttribute(EHtmlAttr._class);
    }

    public BaseHtmlElement setHtmlClassName(String className) {
        this.setHtmlAttribute(EHtmlAttr._class, className);
        return this;
    }

    public BaseHtmlElement setHtmlClassName(CssClassConstant ccc) {
        DarwinStatisticsCtxHelper.countCssStatistics((String)ccc.getCssrName());
        return this.setHtmlClassName(ccc.getName());
    }

    public String getHtmlContentEditable() {
        return this.getHtmlAttribute(EHtmlAttr.contentEditable);
    }

    public BaseHtmlElement setHtmlContentEditable(String editable) {
        this.setHtmlAttribute(EHtmlAttr.contentEditable, editable);
        return this;
    }

    public String getHtmlContextMenu() {
        return this.getHtmlAttribute(EHtmlAttr.contextMenu);
    }

    public BaseHtmlElement setHtmlContextMenu(String contextMenu) {
        this.setHtmlAttribute(EHtmlAttr.contextMenu, contextMenu);
        return this;
    }

    public String getHtmlDir() {
        return this.getHtmlAttribute(EHtmlAttr.dir);
    }

    public BaseHtmlElement setHtmlDir(String dir) {
        this.setHtmlAttribute(EHtmlAttr.dir, dir);
        return this;
    }

    public String getHtmlDraggable() {
        return this.getHtmlAttribute(EHtmlAttr.draggable);
    }

    public BaseHtmlElement setHtmlDraggable(String draggable) {
        this.setHtmlAttribute(EHtmlAttr.draggable, draggable);
        return this;
    }

    public BaseHtmlElement setHtmlDraggable(boolean draggable) {
        return this.setHtmlDraggable(Boolean.toString(draggable));
    }

    public String getHtmlHidden() {
        return this.getHtmlAttribute(EHtmlAttr.hidden);
    }

    public BaseHtmlElement setHtmlHidden(String hidden) {
        this.setHtmlAttribute(EHtmlAttr.hidden, hidden);
        return this;
    }

    public BaseHtmlElement setHtmlHidden(boolean hidden) {
        this.setHtmlAttribute(EHtmlAttr.hidden, hidden);
        return this;
    }

    public String getHtmlId() {
        return this.getHtmlAttribute(EHtmlAttr.id);
    }

    public BaseHtmlElement setHtmlId(String id) {
        this.setHtmlAttribute(EHtmlAttr.id, id);
        return this;
    }

    public BaseHtmlElement setHtmlId(CssIdConstant id) {
        return this.setHtmlId(id.getName());
    }

    public String getHtmlItem() {
        return this.getHtmlAttribute(EHtmlAttr.item);
    }

    public BaseHtmlElement setHtmlItem(String item) {
        this.setHtmlAttribute(EHtmlAttr.item, item);
        return this;
    }

    public String getHtmlItemProp() {
        return this.getHtmlAttribute(EHtmlAttr.itemprop);
    }

    public BaseHtmlElement setHtmlItemProp(String itemprop) {
        this.setHtmlAttribute(EHtmlAttr.itemprop, itemprop);
        return this;
    }

    public String getHtmlLang() {
        return this.getHtmlAttribute(EHtmlAttr.lang);
    }

    public BaseHtmlElement setHtmlLang(String lang) {
        this.setHtmlAttribute(EHtmlAttr.lang, lang);
        return this;
    }

    public String getHtmlSpellCheck() {
        return this.getHtmlAttribute(EHtmlAttr.spellcheck);
    }

    public BaseHtmlElement setHtmlSpellCheck(String spellcheck) {
        this.setHtmlAttribute(EHtmlAttr.spellcheck, spellcheck);
        return this;
    }

    public BaseHtmlElement setHtmlSpellCheck(boolean spellcheck) {
        this.setHtmlAttribute(EHtmlAttr.spellcheck, spellcheck);
        return this;
    }

    public CSSStyleDeclaration getHtmlStyle() {
        String styleString = this.getHtmlAttribute(EHtmlAttr.style);
        if (styleString == null || "".equals(styleString)) {
            return null;
        }
        DCssStyleDeclaration style = new DCssStyleDeclaration(null);
        style.setCssText("{" + styleString + "}");
        return style;
    }

    public String getHtmlStyleAsString() {
        return this.getHtmlAttribute(EHtmlAttr.style);
    }

    public BaseHtmlElement setHtmlStyleAsString(String styleString) {
        if (styleString == null) {
            if (this.hasAttributes()) {
                this.getDsfAttributes().remove((Object)EHtmlAttr.style.getAttributeName());
            }
            return this;
        }
        if (DsfVerifierConfig.getInstance().isVerifyNaming()) {
            String bastardizedStyleString = "{" + styleString + "}";
            DCssStyleDeclaration style = new DCssStyleDeclaration(null);
            style.setCssText(bastardizedStyleString);
        }
        this.setStyleInternal(styleString);
        return this;
    }

    public BaseHtmlElement setHtmlStyle(CSSStyleDeclaration style) {
        if (style == null) {
            if (this.hasAttributes()) {
                this.getDsfAttributes().remove((Object)EHtmlAttr.style.getAttributeName());
            }
            return this;
        }
        String styleString = style.getCssText();
        String realText = styleString.substring(1, styleString.length() - 1);
        this.setStyleInternal(realText);
        return this;
    }

    public String getHtmlSubject() {
        return this.getHtmlAttribute(EHtmlAttr.subject);
    }

    public BaseHtmlElement setHtmlSubject(String subject) {
        this.setHtmlAttribute(EHtmlAttr.subject, subject);
        return this;
    }

    public int getHtmlTabIndex() {
        return this.getHtmlAttributeInteger(EHtmlAttr.tabindex);
    }

    public BaseHtmlElement setHtmlTabIndex(String tabindex) {
        this.setHtmlAttribute(EHtmlAttr.tabindex, tabindex);
        return this;
    }

    public BaseHtmlElement setHtmlTabIndex(int tabindex) {
        this.setHtmlAttribute(EHtmlAttr.tabindex, tabindex);
        return this;
    }

    public String getHtmlTitle() {
        return this.getHtmlAttribute(EHtmlAttr.title);
    }

    public BaseHtmlElement setHtmlTitle(String title) {
        this.setHtmlAttribute(EHtmlAttr.title, title);
        return this;
    }

    public String getHtmlOnAbort() {
        return this.getHtmlAttribute(EHtmlAttr.onabort);
    }

    public BaseHtmlElement setHtmlOnAbort(String script) {
        this.setInlineEvent(EHtmlAttr.onabort, script, EventType.ABORT);
        return this;
    }

    public String getHtmlOnBlur() {
        return this.getHtmlAttribute(EHtmlAttr.onblur);
    }

    public BaseHtmlElement setHtmlOnBlur(String onblur) {
        this.setInlineEvent(EHtmlAttr.onblur, onblur, EventType.BLUR);
        return this;
    }

    public String getHtmlOnCanPlay() {
        return this.getHtmlAttribute(EHtmlAttr.oncanplay);
    }

    public BaseHtmlElement setHtmlOnCanPlay(String script) {
        this.setInlineEvent(EHtmlAttr.oncanplay, script, EventType.CANPLAY);
        return this;
    }

    public String getHtmlOnCanPlayThrough() {
        return this.getHtmlAttribute(EHtmlAttr.oncanplaythrough);
    }

    public BaseHtmlElement setHtmlOnCanPlayThrough(String script) {
        this.setInlineEvent(EHtmlAttr.oncanplaythrough, script, EventType.CANPLAYTHROUGH);
        return this;
    }

    public String getHtmlOnChange() {
        return this.getHtmlAttribute(EHtmlAttr.onchange);
    }

    public BaseHtmlElement setHtmlOnChange(String script) {
        this.setInlineEvent(EHtmlAttr.onchange, script, EventType.CHANGE);
        return this;
    }

    public String getHtmlOnClick() {
        return this.getHtmlAttribute(EHtmlAttr.onclick);
    }

    public BaseHtmlElement setHtmlOnClick(String script) {
        this.setInlineEvent(EHtmlAttr.onclick, script, EventType.CLICK);
        return this;
    }

    public String getHtmlOnContextMenu() {
        return this.getHtmlAttribute(EHtmlAttr.oncontextmenu);
    }

    public BaseHtmlElement setHtmlOnContextMenu(String script) {
        this.setInlineEvent(EHtmlAttr.oncontextmenu, script, EventType.CONTEXTMENU);
        return this;
    }

    public String getHtmlOnDblClick() {
        return this.getHtmlAttribute(EHtmlAttr.ondblclick);
    }

    public BaseHtmlElement setHtmlOnDblClick(String script) {
        this.setInlineEvent(EHtmlAttr.ondblclick, script, EventType.DBLCLICK);
        return this;
    }

    public String getHtmlOnDoubleClick() {
        return this.getHtmlAttribute(EHtmlAttr.ondblclick);
    }

    public BaseHtmlElement setHtmlOnDoubleClick(String script) {
        this.setInlineEvent(EHtmlAttr.ondblclick, script, EventType.DBLCLICK);
        return this;
    }

    public String getHtmlOnDrag() {
        return this.getHtmlAttribute(EHtmlAttr.ondrag);
    }

    public BaseHtmlElement setHtmlOnDrag(String script) {
        this.setInlineEvent(EHtmlAttr.ondrag, script, EventType.DRAG);
        return this;
    }

    public String getHtmlOnDragEnd() {
        return this.getHtmlAttribute(EHtmlAttr.ondragend);
    }

    public BaseHtmlElement setHtmlOnDragEnd(String script) {
        this.setInlineEvent(EHtmlAttr.ondragend, script, EventType.DRAGEND);
        return this;
    }

    public String getHtmlOnDragEnter() {
        return this.getHtmlAttribute(EHtmlAttr.ondragenter);
    }

    public BaseHtmlElement setHtmlOnDragEnter(String script) {
        this.setInlineEvent(EHtmlAttr.ondragenter, script, EventType.DRAGENTER);
        return this;
    }

    public String getHtmlOnDragLeave() {
        return this.getHtmlAttribute(EHtmlAttr.ondragleave);
    }

    public BaseHtmlElement setHtmlOnDragLeave(String script) {
        this.setInlineEvent(EHtmlAttr.ondragleave, script, EventType.DRAGLEAVE);
        return this;
    }

    public String getHtmlOnDragOver() {
        return this.getHtmlAttribute(EHtmlAttr.ondragover);
    }

    public BaseHtmlElement setHtmlOnDragOver(String script) {
        this.setInlineEvent(EHtmlAttr.ondragover, script, EventType.DRAGOVER);
        return this;
    }

    public String getHtmlOnDragStart() {
        return this.getHtmlAttribute(EHtmlAttr.ondragstart);
    }

    public BaseHtmlElement setHtmlOnDragStart(String script) {
        this.setInlineEvent(EHtmlAttr.ondragstart, script, EventType.DRAGSTART);
        return this;
    }

    public String getHtmlOnDrop() {
        return this.getHtmlAttribute(EHtmlAttr.ondrop);
    }

    public BaseHtmlElement setHtmlOnDrop(String script) {
        this.setInlineEvent(EHtmlAttr.ondrop, script, EventType.DROP);
        return this;
    }

    public String getHtmlOnDurationChange() {
        return this.getHtmlAttribute(EHtmlAttr.ondurationchange);
    }

    public BaseHtmlElement setHtmlOnDurationChange(String script) {
        this.setInlineEvent(EHtmlAttr.ondurationchange, script, EventType.DURATIONCHANGE);
        return this;
    }

    public String getHtmlOnEmptied() {
        return this.getHtmlAttribute(EHtmlAttr.onemptied);
    }

    public BaseHtmlElement setHtmlOnEmptied(String script) {
        this.setInlineEvent(EHtmlAttr.onemptied, script, EventType.EMPTIED);
        return this;
    }

    public String getHtmlOnEnded() {
        return this.getHtmlAttribute(EHtmlAttr.onended);
    }

    public BaseHtmlElement setHtmlOnEnded(String script) {
        this.setInlineEvent(EHtmlAttr.onended, script, EventType.ENDED);
        return this;
    }

    public String getHtmlOnError() {
        return this.getHtmlAttribute(EHtmlAttr.onerror);
    }

    public BaseHtmlElement setHtmlOnError(String script) {
        this.setInlineEvent(EHtmlAttr.onerror, script, EventType.ERROR);
        return this;
    }

    public String getHtmlOnFocus() {
        return this.getHtmlAttribute(EHtmlAttr.onfocus);
    }

    public BaseHtmlElement setHtmlOnFocus(String script) {
        this.setInlineEvent(EHtmlAttr.onfocus, script, EventType.FOCUS);
        return this;
    }

    public String getHtmlOnFormChange() {
        return this.getHtmlAttribute(EHtmlAttr.onformchange);
    }

    public BaseHtmlElement setHtmlOnFormChange(String script) {
        this.setInlineEvent(EHtmlAttr.onformchange, script, EventType.FORMCHANGE);
        return this;
    }

    public String getHtmlOnFormInput() {
        return this.getHtmlAttribute(EHtmlAttr.onforminput);
    }

    public BaseHtmlElement setHtmlOnFormInput(String script) {
        this.setInlineEvent(EHtmlAttr.onforminput, script, EventType.FORMINPUT);
        return this;
    }

    public String getHtmlOnInput() {
        return this.getHtmlAttribute(EHtmlAttr.oninput);
    }

    public BaseHtmlElement setHtmlOnInput(String script) {
        this.setInlineEvent(EHtmlAttr.oninput, script, EventType.INPUT);
        return this;
    }

    public String getHtmlOnInvalid() {
        return this.getHtmlAttribute(EHtmlAttr.oninvalid);
    }

    public BaseHtmlElement setHtmlOnInvalid(String script) {
        this.setInlineEvent(EHtmlAttr.oninvalid, script, EventType.INVALID);
        return this;
    }

    public String getHtmlOnKeyDown() {
        return this.getHtmlAttribute(EHtmlAttr.onkeydown);
    }

    public BaseHtmlElement setHtmlOnKeyDown(String script) {
        this.setInlineEvent(EHtmlAttr.onkeydown, script, EventType.KEYDOWN);
        return this;
    }

    public String getHtmlOnKeyPress() {
        return this.getHtmlAttribute(EHtmlAttr.onkeypress);
    }

    public BaseHtmlElement setHtmlOnKeyPress(String script) {
        this.setInlineEvent(EHtmlAttr.onkeypress, script, EventType.KEYPRESS);
        return this;
    }

    public String getHtmlOnKeyUp() {
        return this.getHtmlAttribute(EHtmlAttr.onkeyup);
    }

    public BaseHtmlElement setHtmlOnKeyUp(String script) {
        this.setInlineEvent(EHtmlAttr.onkeyup, script, EventType.KEYUP);
        return this;
    }

    public String getHtmlOnLoad() {
        return this.getHtmlAttribute(EHtmlAttr.onload);
    }

    public BaseHtmlElement setHtmlOnLoad(String script) {
        this.setInlineEvent(EHtmlAttr.onload, script, EventType.LOAD);
        return this;
    }

    public String getHtmlOnLoadedData() {
        return this.getHtmlAttribute(EHtmlAttr.onloadeddata);
    }

    public BaseHtmlElement setHtmlOnLoadedData(String script) {
        this.setInlineEvent(EHtmlAttr.onloadeddata, script, EventType.LOADEDDATA);
        return this;
    }

    public String getHtmlOnLoadedMetadata() {
        return this.getHtmlAttribute(EHtmlAttr.onloadedmetadata);
    }

    public BaseHtmlElement setHtmlOnLoadedMetadata(String script) {
        this.setInlineEvent(EHtmlAttr.onloadedmetadata, script, EventType.LOADEDMETADATA);
        return this;
    }

    public String getHtmlOnLoadStart() {
        return this.getHtmlAttribute(EHtmlAttr.onloadstart);
    }

    public BaseHtmlElement setHtmlOnLoadStart(String script) {
        this.setInlineEvent(EHtmlAttr.onloadstart, script, EventType.LOADSTART);
        return this;
    }

    public String getHtmlOnMouseDown() {
        return this.getHtmlAttribute(EHtmlAttr.onmousedown);
    }

    public BaseHtmlElement setHtmlOnMouseDown(String script) {
        this.setInlineEvent(EHtmlAttr.onmousedown, script, EventType.MOUSEDOWN);
        return this;
    }

    public String getHtmlOnMouseMove() {
        return this.getHtmlAttribute(EHtmlAttr.onmousemove);
    }

    public BaseHtmlElement setHtmlOnMouseMove(String script) {
        this.setInlineEvent(EHtmlAttr.onmousemove, script, EventType.MOUSEMOVE);
        return this;
    }

    public String getHtmlOnMouseOut() {
        return this.getHtmlAttribute(EHtmlAttr.onmouseout);
    }

    public BaseHtmlElement setHtmlOnMouseOut(String script) {
        this.setInlineEvent(EHtmlAttr.onmouseout, script, EventType.MOUSEOUT);
        return this;
    }

    public String getHtmlOnMouseOver() {
        return this.getHtmlAttribute(EHtmlAttr.onmouseover);
    }

    public BaseHtmlElement setHtmlOnMouseOver(String script) {
        this.setInlineEvent(EHtmlAttr.onmouseover, script, EventType.MOUSEOVER);
        return this;
    }

    public String getHtmlOnMouseUp() {
        return this.getHtmlAttribute(EHtmlAttr.onmouseup);
    }

    public BaseHtmlElement setHtmlOnMouseUp(String script) {
        this.setInlineEvent(EHtmlAttr.onmouseup, script, EventType.MOUSEUP);
        return this;
    }

    public String getHtmlOnMouseWheel() {
        return this.getHtmlAttribute(EHtmlAttr.onmousewheel);
    }

    public BaseHtmlElement setHtmlOnMouseWheel(String script) {
        this.setInlineEvent(EHtmlAttr.onmousewheel, script, EventType.MOUSEWHEEL);
        return this;
    }

    public String getHtmlOnPause() {
        return this.getHtmlAttribute(EHtmlAttr.onpause);
    }

    public BaseHtmlElement setHtmlOnPause(String script) {
        this.setInlineEvent(EHtmlAttr.onpause, script, EventType.PAUSE);
        return this;
    }

    public String getHtmlOnPlay() {
        return this.getHtmlAttribute(EHtmlAttr.onplay);
    }

    public BaseHtmlElement setHtmlOnPlay(String script) {
        this.setInlineEvent(EHtmlAttr.onplay, script, EventType.PLAY);
        return this;
    }

    public String getHtmlOnPlaying() {
        return this.getHtmlAttribute(EHtmlAttr.onplaying);
    }

    public BaseHtmlElement setHtmlOnPlaying(String script) {
        this.setInlineEvent(EHtmlAttr.onplaying, script, EventType.PLAYING);
        return this;
    }

    public String getHtmlOnProgress() {
        return this.getHtmlAttribute(EHtmlAttr.onprogress);
    }

    public BaseHtmlElement setHtmlOnProgress(String script) {
        this.setInlineEvent(EHtmlAttr.onprogress, script, EventType.PROGRESS);
        return this;
    }

    public String getHtmlOnRateChange() {
        return this.getHtmlAttribute(EHtmlAttr.onratechange);
    }

    public BaseHtmlElement setHtmlOnRateChange(String script) {
        this.setInlineEvent(EHtmlAttr.onratechange, script, EventType.RATECHANGE);
        return this;
    }

    public String getHtmlOnReadyStateChange() {
        return this.getHtmlAttribute(EHtmlAttr.onreadystatechange);
    }

    public BaseHtmlElement setHtmlOnReadyStateChange(String script) {
        this.setInlineEvent(EHtmlAttr.onreadystatechange, script, EventType.READYSTATECHANGE);
        return this;
    }

    public String getHtmlOnScroll() {
        return this.getHtmlAttribute(EHtmlAttr.onscroll);
    }

    public BaseHtmlElement setHtmlOnScroll(String script) {
        this.setInlineEvent(EHtmlAttr.onscroll, script, EventType.SCROLL);
        return this;
    }

    public String getHtmlOnSeeked() {
        return this.getHtmlAttribute(EHtmlAttr.onseeked);
    }

    public BaseHtmlElement setHtmlOnSeeked(String script) {
        this.setInlineEvent(EHtmlAttr.onseeked, script, EventType.SEEKED);
        return this;
    }

    public String getHtmlOnSeeking() {
        return this.getHtmlAttribute(EHtmlAttr.onseeking);
    }

    public BaseHtmlElement setHtmlOnSeeking(String script) {
        this.setInlineEvent(EHtmlAttr.onseeking, script, EventType.SEEKING);
        return this;
    }

    public String getHtmlOnSelect() {
        return this.getHtmlAttribute(EHtmlAttr.onselect);
    }

    public BaseHtmlElement setHtmlOnSelect(String script) {
        this.setInlineEvent(EHtmlAttr.onselect, script, EventType.SELECT);
        return this;
    }

    public String getHtmlOnShow() {
        return this.getHtmlAttribute(EHtmlAttr.onshow);
    }

    public BaseHtmlElement setHtmlOnShow(String script) {
        this.setInlineEvent(EHtmlAttr.onshow, script, EventType.SHOW);
        return this;
    }

    public String getHtmlOnStalled() {
        return this.getHtmlAttribute(EHtmlAttr.onstalled);
    }

    public BaseHtmlElement setHtmlOnStalled(String script) {
        this.setInlineEvent(EHtmlAttr.onstalled, script, EventType.STALLED);
        return this;
    }

    public String getHtmlOnSubmit() {
        return this.getHtmlAttribute(EHtmlAttr.onsubmit);
    }

    public BaseHtmlElement setHtmlOnSubmit(String script) {
        this.setInlineEvent(EHtmlAttr.onsubmit, script, EventType.SUBMIT);
        return this;
    }

    public String getHtmlOnSuspend() {
        return this.getHtmlAttribute(EHtmlAttr.onsuspend);
    }

    public BaseHtmlElement setHtmlOnSuspend(String script) {
        this.setInlineEvent(EHtmlAttr.onsuspend, script, EventType.SUSPEND);
        return this;
    }

    public String getHtmlOnTimeUpdate() {
        return this.getHtmlAttribute(EHtmlAttr.ontimeupdate);
    }

    public BaseHtmlElement setHtmlOnTimeUpdate(String script) {
        this.setInlineEvent(EHtmlAttr.ontimeupdate, script, EventType.TIMEUPDATE);
        return this;
    }

    public String getHtmlOnVolumeChange() {
        return this.getHtmlAttribute(EHtmlAttr.onvolumechange);
    }

    public BaseHtmlElement setHtmlOnVolumeChange(String script) {
        this.setInlineEvent(EHtmlAttr.onvolumechange, script, EventType.VOLUMECHANGE);
        return this;
    }

    public String getHtmlOnWaiting() {
        return this.getHtmlAttribute(EHtmlAttr.onwaiting);
    }

    public BaseHtmlElement setHtmlOnWaiting(String script) {
        this.setInlineEvent(EHtmlAttr.onwaiting, script, EventType.WAITING);
        return this;
    }

    public BaseHtmlElement add(EventType eventType, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.add((DElement)this, (IDomEventType)eventType, handler);
        return this;
    }

    public BaseHtmlElement add(EventType eventType, IJsFunc func) {
        EventHandlerAttacher.add((DElement)this, (IDomEventType)eventType, func);
        return this;
    }

    public BaseHtmlElement add(EventType eventType, String jsText) {
        EventHandlerAttacher.add((DElement)this, (IDomEventType)eventType, jsText);
        return this;
    }

    public boolean hasEventHandlers() {
        return this.getEventHandlerContainer().getNumOfHandlers(this) > 0;
    }

    public boolean removeEventHandler(ISimpleJsEventHandler handler) {
        return this.getEventHandlerContainer().removeHandler(this, handler);
    }

    public BaseHtmlElement addBr() {
        DBr br = new DBr();
        this.add((DNode)br);
        return this;
    }

    public BaseHtmlElement addBr(int howMany) {
        int i = 0;
        while (i < howMany) {
            this.addBr();
            ++i;
        }
        return this;
    }

    public BaseHtmlElement addHtmlClassName(String className) {
        if (this.hasHtmlAttribute(EHtmlAttr._class)) {
            this.setHtmlAttribute(EHtmlAttr._class, String.valueOf(this.getHtmlAttribute(EHtmlAttr._class)) + " " + className);
        } else {
            this.setHtmlAttribute(EHtmlAttr._class, className);
        }
        return this;
    }

    public BaseHtmlElement addHtmlClassName(CssClassConstant ccc) {
        DarwinStatisticsCtxHelper.countCssStatistics((String)ccc.getCssrName());
        return this.addHtmlClassName(ccc.getName());
    }

    public BaseHtmlElement jif(String jif) {
        Jif.jif((Object)((Object)this), (String)jif, (boolean)true, (String[])new String[]{"Html", "Dsf"});
        return this;
    }

    public BaseHtmlElement add(BaseHtmlElement ... elems) throws DOMException {
        BaseHtmlElement[] baseHtmlElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            BaseHtmlElement elem = baseHtmlElementArray[n2];
            this.add((DNode)elem);
            ++n2;
        }
        return this;
    }

    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)EHtmlAttr.dir.getAttributeName(), (Object)this.getHtmlDir()) + Z.fmt((String)EHtmlAttr.lang.getAttributeName(), (Object)this.getHtmlLang()) + Z.fmt((String)EHtmlAttr._class.getAttributeName(), (Object)this.getHtmlClassName()) + Z.fmt((String)EHtmlAttr.id.getAttributeName(), (Object)this.getHtmlId()) + Z.fmt((String)EHtmlAttr.style.getAttributeName(), (Object)this.getHtmlStyleAsString()) + Z.fmt((String)EHtmlAttr.title.getAttributeName(), (Object)this.getHtmlTitle());
    }

    int getHtmlAttributeInteger(EHtmlAttr attr) {
        try {
            String value = this.getHtmlAttribute(attr);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    boolean getHtmlAttributeExists(EHtmlAttr attr) {
        return this.hasAttribute(attr.getAttributeName());
    }

    boolean hasHtmlAttribute(EHtmlAttr attr) {
        return super.hasAttribute(attr.getAttributeName());
    }

    String getHtmlAttribute(EHtmlAttr attr) {
        return super.getAttribute(attr.getAttributeName());
    }

    public void setHtmlAttribute(EHtmlAttr attr, String value) {
        this.setAttributeInternal(attr.getAttributeName(), value, attr.ordinal());
    }

    void setHtmlAttribute(EHtmlAttr attr, int value) {
        this.setHtmlAttribute(attr, String.valueOf(value));
    }

    void setHtmlAttribute(EHtmlAttr attr, double value) {
        this.setHtmlAttribute(attr, String.valueOf(value));
    }

    void setHtmlAttribute(EHtmlAttr attr, boolean value) {
        if (value) {
            this.setAttribute(attr.getAttributeName(), attr.getAttributeName());
        } else {
            this.getDsfAttributes().remove((Object)attr.getAttributeName());
        }
    }

    private void setAttributeInternal(String name, String value, int nameAsCharsIndex) {
        DAttr attr = new DAttr(name, value);
        this.getAttributes();
        DAttr previousAttr = DomAssociator.attributeMapPut(this, attr);
        if (previousAttr == null) {
            DomAssociator.setNameAsCharIndex(attr, nameAsCharsIndex);
            attr.setValue(value);
            return;
        }
        previousAttr.setValue(value);
        DomAssociator.attributeMapPut(this, previousAttr);
    }

    void setInlineEvent(EHtmlAttr attr, String script, EventType eventType) {
        if (HtmlCtx.ctx().isDisableInlineHandler()) {
            HtmlCtx.ctx().getInlineEventHandlerContainer().add(this, (IDomEventType)eventType, script);
        } else {
            this.setHtmlAttribute(attr, script);
        }
    }

    private EventHandlerContainer getEventHandlerContainer() {
        return HtmlCtx.ctx().getEventHandlerContainer();
    }

    private final void setStyleInternal(String style) {
        this.setHtmlAttribute(EHtmlAttr.style, style);
    }

    String capitalize(String value) {
        return value;
    }

    String getCapitalized(String name) {
        return name;
    }

    static class DomAssociator
    extends Associator {
        DomAssociator() {
        }

        protected static void setNameAsCharIndex(DAttr attr, int index) {
            Associator.setNameAsCharIndex((DAttr)attr, (int)index);
        }

        protected static int getNameAsCharIndex(DAttr attr) {
            return Associator.getNameAsCharIndex((DAttr)attr);
        }

        protected static DAttr attributeMapPut(DElement element, DAttr attr) {
            return Associator.attributeMapPut((DElement)element, (DAttr)attr);
        }
    }
}

