/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.naming;

import org.eclipse.vjet.dsf.common.naming.BaseNameCheckerVisitor;
import org.eclipse.vjet.dsf.common.naming.DElementId;
import org.eclipse.vjet.dsf.common.naming.DsfInvalidNameException;
import org.eclipse.vjet.dsf.common.naming.ParentScopes;
import org.eclipse.vjet.dsf.common.node.NameBasedDNodeFinder;
import org.eclipse.vjet.dsf.common.node.visitor.AbortDNodeTraversalException;
import org.eclipse.vjet.dsf.common.node.visitor.DNodeVisitStatus;
import org.eclipse.vjet.dsf.dom.DNode;

class ScopeNameCheckerVisitor
extends BaseNameCheckerVisitor {
    ScopeNameCheckerVisitor(DNode child, DNode enclosingScope) {
        super(child, enclosingScope);
    }

    @Override
    public DNodeVisitStatus preVisit(DNode component) throws AbortDNodeTraversalException {
        if (component == this.m_child) {
            return DNodeVisitStatus.CONTINUE;
        }
        if (!component.hasDsfName()) {
            return DNodeVisitStatus.CONTINUE;
        }
        String scopeName = component.getDsfName().getScopeName();
        if (scopeName == null) {
            return DNodeVisitStatus.CONTINUE;
        }
        ParentScopes scopes = new ParentScopes();
        scopes.appendScope(new DElementId(scopeName).toString());
        DNode foundConflict = NameBasedDNodeFinder.get(scopes, null, this.m_enclosingScope);
        if (foundConflict != null) {
            throw new DsfInvalidNameException("can't add child with scope '" + scopeName + "' because the scope is already used in parent\n\n");
        }
        return DNodeVisitStatus.ABORT_SUBTREE;
    }
}

