/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.support;

import java.util.Enumeration;

class JifTokenizer
implements Enumeration<String> {
    private String m_data;
    private int m_currentSemicolonIndex = 0;
    private int m_currentStartingPosition = 0;
    private boolean m_hasMoreElements = true;

    public JifTokenizer(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Token data must not be null");
        }
        this.m_data = data;
        this.m_currentSemicolonIndex = this.nextNonEscapedSemicolonIndex(this.m_currentStartingPosition);
    }

    public static void main(String[] args) {
        String s = "offset:100%; style:stop-color:rgb(0,0,255)//;stop-opacity:1";
        JifTokenizer toker = new JifTokenizer(s);
        while (toker.hasMoreElements()) {
            JifTokenizer.out(toker.nextElement());
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_hasMoreElements;
    }

    @Override
    public String nextElement() {
        String answer;
        if (!this.m_hasMoreElements) {
            throw new IllegalStateException("No more elements present");
        }
        if (this.m_currentSemicolonIndex == -1) {
            this.m_hasMoreElements = false;
            answer = this.m_data.substring(this.m_currentStartingPosition);
        } else {
            answer = this.m_data.substring(this.m_currentStartingPosition, this.m_currentSemicolonIndex);
            this.m_currentStartingPosition = this.m_currentSemicolonIndex + 1;
            this.m_currentSemicolonIndex = this.nextNonEscapedSemicolonIndex(this.m_currentStartingPosition);
            if (this.m_currentSemicolonIndex == -1 && "".equals(this.m_data.substring(this.m_currentStartingPosition).trim())) {
                this.m_hasMoreElements = false;
            }
        }
        return answer;
    }

    private int nextNonEscapedSemicolonIndex(int startingPos) {
        if (startingPos >= this.m_data.length()) {
            return -1;
        }
        int si = this.m_data.indexOf(";", startingPos);
        if (si == -1) {
            return -1;
        }
        if (this.m_data.length() - startingPos <= 2) {
            return si;
        }
        if (this.m_data.charAt(si - 1) == '/' && this.m_data.charAt(si - 2) == '/') {
            return this.nextNonEscapedSemicolonIndex(si + 1);
        }
        return si;
    }

    private static void out(Object o) {
        System.out.println(o);
    }
}

